/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.SeriesData;
import org.jetbrains.annotations.NotNull;

public interface Interpolatable<T, R> {
    public static final Interpolatable<Long, Double> SegmentInterpolator = (start, end, x) -> {
        double x1 = start.x;
        double y1 = ((Long)start.value).longValue();
        double x2 = end.x;
        double y2 = ((Long)end.value).longValue();
        return (x - x1) / (x2 - x1) * (y2 - y1) + y1;
    };
    public static final Interpolatable<Long, Double> RoundedSegmentInterpolator = (start, end, x) -> Math.round(SegmentInterpolator.interpolate(start, end, x));
    public static final Interpolatable<Long, Double> SteppedLineInterpolator = (start, end, x) -> {
        double eps = 1.0E-6;
        return Math.abs(x - (double)end.x) < eps ? ((Long)end.value).doubleValue() : ((Long)start.value).doubleValue();
    };

    public R interpolate(@NotNull SeriesData<T> var1, SeriesData<T> var2, double var3);
}

