/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;

public class RotatedLabel
extends JLabel {
    private boolean myPainting;
    private boolean mIsMirrored;

    public RotatedLabel() {
    }

    public RotatedLabel(String label2) {
        super(label2);
    }

    @Override
    public void setUI(LabelUI newUI) {
        super.setUI(new RotatedLabelUI(newUI));
    }

    @Override
    public int getWidth() {
        if (this.myPainting && this.getIcon() == null) {
            return super.getHeight();
        }
        return super.getWidth();
    }

    private class RotatedLabelUI
    extends LabelUI {
        private final ComponentUI myUI;

        public RotatedLabelUI(ComponentUI delegate) {
            this.myUI = delegate;
        }

        public void setMirrored(boolean isMirrored) {
            RotatedLabel.this.mIsMirrored = isMirrored;
        }

        @Override
        public void installUI(JComponent component) {
            this.myUI.installUI(component);
        }

        @Override
        public void uninstallUI(JComponent component) {
            this.myUI.uninstallUI(component);
        }

        @Override
        public void paint(Graphics g, JComponent component) {
            this.prepareForDrawing(g, component);
            try {
                RotatedLabel.this.myPainting = true;
                this.myUI.paint(g, component);
            }
            finally {
                RotatedLabel.this.myPainting = false;
            }
        }

        @Override
        public void update(Graphics g, JComponent component) {
            this.prepareForDrawing(g, component);
            try {
                RotatedLabel.this.myPainting = true;
                this.myUI.update(g, component);
            }
            finally {
                RotatedLabel.this.myPainting = false;
            }
        }

        private void prepareForDrawing(Graphics g, JComponent component) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension text = component.getPreferredSize();
            Dimension box = component.getSize();
            int numQuadrants = RotatedLabel.this.mIsMirrored ? 1 : -1;
            g2d.translate((text.width + numQuadrants * box.height) / 2, (box.height - numQuadrants * text.height) / 2);
            g2d.transform(AffineTransform.getQuadrantRotateInstance(numQuadrants));
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Dimension size = this.myUI.getPreferredSize(c);
            return new Dimension(size.height, size.width);
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            Dimension size = this.myUI.getMinimumSize(c);
            return new Dimension(size.height, size.width);
        }

        @Override
        public Dimension getMaximumSize(JComponent c) {
            Dimension size = this.myUI.getMaximumSize(c);
            return new Dimension(size.height, size.width);
        }

        @Override
        public boolean contains(JComponent c, int x, int y) {
            return this.myUI.contains(c, x, y);
        }

        @Override
        public int getBaseline(JComponent c, int width, int height) {
            return this.myUI.getBaseline(c, width, height);
        }

        @Override
        public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
            return this.myUI.getBaselineResizeBehavior(c);
        }

        @Override
        public int getAccessibleChildrenCount(JComponent c) {
            return this.myUI.getAccessibleChildrenCount(c);
        }

        @Override
        public Accessible getAccessibleChild(JComponent c, int i2) {
            return this.myUI.getAccessibleChild(c, i2);
        }
    }
}

