/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.chart.linechart.AbstractDurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DurationDataRenderer<E extends DurationData>
extends AspectObserver
implements AbstractDurationDataRenderer {
    static final float EPSILON = 1.0E-6f;
    static final JBColor BACKGROUND_HIGHLIGHT_COLOR = new JBColor(ColorUtil.withAlpha((Color)JBColor.BLACK, (double)0.2f), ColorUtil.withAlpha((Color)JBColor.WHITE, (double)0.2f));
    @NotNull
    private DurationDataModel<E> myModel;
    @NotNull
    private final List<Rectangle2D.Float> myClickRegionCache = new ArrayList<Rectangle2D.Float>();
    @NotNull
    private final List<SeriesData<E>> myDataCache = new ArrayList<SeriesData<E>>();
    @NotNull
    private final List<Boolean> myRegionOnLineSeries = new ArrayList<Boolean>();
    @NotNull
    private final Color myColor;
    @Nullable
    private final Color myDurationBgColor;
    @Nullable
    private Icon myIcon;
    @Nullable
    private Function<E, Icon> myIconMapper;
    @Nullable
    private Stroke myStroke;
    @Nullable
    private Function<E, String> myLabelProvider;
    @Nullable
    private Consumer<E> myClickHandler;
    @Nullable
    private Consumer<E> myHoverHandler;
    @Nullable
    private Color myLabelBgColor;
    @Nullable
    private Color myLabelHoveredBgColor;
    @Nullable
    private Color myLabelClickedBgColor;
    @Nullable
    private Color myLabelTextColor;
    private float myLineStrokeOffset;
    private float myLabelXOffset;
    private float myLabelYOffset;
    private boolean myBackgroundClickable;
    @NotNull
    private final Insets myHostInsets;
    private int myClickRegionPaddingX;
    private int myClickRegionPaddingY;
    @NotNull
    private final List<Rectangle2D.Float> myPathCache = new ArrayList<Rectangle2D.Float>();
    @NotNull
    private final List<JLabel> myLabelCache = new ArrayList<JLabel>();
    @NotNull
    private final Map<RangedContinuousSeries, LineConfig> myCustomLineConfigs = new HashMap<RangedContinuousSeries, LineConfig>();
    private Point myMousePosition;
    private Component myMouseComponent;
    private boolean myClick;
    private boolean myInComponentRegion;

    public DurationDataRenderer(@NotNull DurationDataModel<E> model2, @NotNull Builder<E> builder) {
        this.myModel = model2;
        this.myColor = builder.myColor;
        this.myDurationBgColor = builder.myDurationBgColor;
        this.myIcon = builder.myIcon;
        this.myIconMapper = builder.myIconMapper;
        this.myStroke = builder.myStroke;
        this.myLabelProvider = builder.myLabelProvider;
        this.myClickHandler = builder.myClickHandler;
        this.myHoverHandler = builder.myHoverHandler;
        this.myLabelBgColor = builder.myLabelBgColor;
        this.myLabelHoveredBgColor = builder.myLabelHoveredBgColor;
        this.myLabelClickedBgColor = builder.myLabelClickedBgColor;
        this.myLabelTextColor = builder.myLabelTextColor;
        this.myLabelXOffset = builder.myLabelXOffset;
        this.myLabelYOffset = builder.myLabelYOffset;
        this.myHostInsets = builder.myHostInsets;
        this.myClickRegionPaddingX = builder.myClickRegionPaddingX;
        this.myClickRegionPaddingY = builder.myClickRegionPaddingY;
        this.myBackgroundClickable = builder.myBackgroundClickable;
        if (this.myStroke instanceof BasicStroke) {
            BasicStroke stroke = (BasicStroke)this.myStroke;
            this.myLineStrokeOffset = stroke.getLineWidth() / 2.0f;
        } else {
            this.myLineStrokeOffset = 0.0f;
        }
        this.myModel.addDependency(this).onChange(DurationDataModel.Aspect.DURATION_DATA, this::modelChanged);
    }

    public void addCustomLineConfig(@NotNull RangedContinuousSeries series, @NotNull LineConfig config) {
        this.myCustomLineConfigs.put(series, config);
    }

    @VisibleForTesting
    LineConfig getCustomLineConfig(@NotNull RangedContinuousSeries series) {
        return this.myCustomLineConfigs.get(series);
    }

    @VisibleForTesting
    @NotNull
    public List<Rectangle2D.Float> getClickRegionCache() {
        return this.myClickRegionCache;
    }

    @VisibleForTesting
    @NotNull
    public List<Boolean> getRegionOnLineSeries() {
        return this.myRegionOnLineSeries;
    }

    private void modelChanged() {
        this.myDataCache.clear();
        this.myClickRegionCache.clear();
        this.myPathCache.clear();
        this.myLabelCache.clear();
        this.myRegionOnLineSeries.clear();
        RangedSeries<E> series = this.myModel.getSeries();
        RangedContinuousSeries attached = this.myModel.getAttachedSeries();
        Predicate<SeriesData<E>> attachedPredicate = this.myModel.getAttachPredicate();
        double xMin = series.getXRange().getMin();
        double xLength = series.getXRange().getLength();
        List<SeriesData<E>> seriesList = series.getSeries();
        List attachedSeriesList = attached != null ? attached.getSeries() : null;
        double yMin = attached == null ? 0.0 : attached.getYRange().getMin();
        double yMax = attached == null ? 0.0 : attached.getYRange().getMax();
        int j = 0;
        SeriesData lastFoundData = null;
        for (SeriesData<E> data : seriesList) {
            Rectangle2D.Float rect = new Rectangle2D.Float();
            double yStart = 1.0;
            double xStart = ((double)data.x - xMin) / xLength;
            double xDuration = (double)((DurationData)data.value).getDurationUs() / xLength;
            rect.setRect(xStart, 0.0, xDuration, 1.0);
            this.myPathCache.add(rect);
            Rectangle2D.Float clickRegion = new Rectangle2D.Float();
            boolean regionIsOnLineSeries = false;
            if (attachedSeriesList != null && (attachedPredicate == null || attachedPredicate.test(data))) {
                while (j < attachedSeriesList.size()) {
                    SeriesData seriesData = attachedSeriesList.get(j);
                    if ((float)(seriesData.x - data.x) > 1.0E-6f) {
                        if (lastFoundData == null) break;
                        assert (this.myModel.getInterpolatable() != null);
                        double adjustedY = this.myModel.getInterpolatable().interpolate(lastFoundData, seriesData, data.x);
                        yStart = 1.0 - (adjustedY - yMin) / (yMax - yMin);
                        regionIsOnLineSeries = true;
                        break;
                    }
                    if (j == attachedSeriesList.size() - 1) {
                        yStart = 1.0 - ((double)((Long)seriesData.value).longValue() - yMin) / (yMax - yMin);
                        regionIsOnLineSeries = true;
                    }
                    lastFoundData = seriesData;
                    ++j;
                }
            }
            this.myDataCache.add(data);
            this.myClickRegionCache.add(clickRegion);
            this.myRegionOnLineSeries.add(regionIsOnLineSeries);
            double regionWidth = 0.0;
            double regionHeight = 0.0;
            Icon icon = this.getIcon((DurationData)data.value);
            if (icon != null) {
                regionWidth += (double)icon.getIconWidth();
                regionHeight += (double)icon.getIconHeight();
            }
            if (this.myLabelProvider != null) {
                JLabel label2 = new JLabel(this.myLabelProvider.apply((DurationData)data.value));
                label2.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(9.0f));
                label2.setForeground(this.myLabelTextColor);
                Dimension size = label2.getPreferredSize();
                label2.setBounds(0, 0, size.width, size.height);
                this.myLabelCache.add(label2);
                regionWidth += size.getWidth();
                regionHeight = Math.max(regionHeight, size.getHeight());
            }
            if (!(regionWidth > 0.0)) continue;
            clickRegion.setRect(xStart, yStart, regionWidth, regionHeight);
        }
        if (this.myHoverHandler != null) {
            E pickData = this.calculatePickData();
            this.myHoverHandler.accept(pickData);
        }
    }

    @Override
    public void renderLines(@NotNull LineChart lineChart, @NotNull Graphics2D g2d, @NotNull List<Path2D> transformedPaths, @NotNull List<RangedContinuousSeries> series) {
        BiPredicate<SeriesData<E>, RangedContinuousSeries> renderSeriesPredicate = this.myModel.getRenderSeriesPredicate();
        if (this.myDurationBgColor != null || !this.myCustomLineConfigs.isEmpty() || renderSeriesPredicate != null) {
            Shape originalClip = g2d.getClip();
            Dimension dim = lineChart.getSize();
            Rectangle2D.Float clipRect = new Rectangle2D.Float();
            ArrayList<LineConfig> configs = new ArrayList<LineConfig>(series.size());
            for (RangedContinuousSeries rangedSeries : series) {
                LineConfig config = lineChart.getLineConfig(rangedSeries);
                if (this.myCustomLineConfigs.containsKey(rangedSeries)) {
                    LineConfig customConfig = this.myCustomLineConfigs.get(rangedSeries);
                    if (config.isAdjustDash() && customConfig.isAdjustDash()) {
                        customConfig.setAdjustedDashPhase(config.getAdjustedDashPhase());
                    }
                    config = customConfig;
                }
                configs.add(config);
            }
            for (int i2 = 0; i2 < this.myPathCache.size(); ++i2) {
                Rectangle2D.Float rect = this.myPathCache.get(i2);
                SeriesData<E> data = this.myDataCache.get(i2);
                double scaledXStart = (double)rect.x * dim.getWidth();
                double scaledXDuration = (double)rect.width * dim.getWidth();
                double newX = Math.max(scaledXStart, originalClip.getBounds().getX());
                ((Rectangle2D)clipRect).setRect(newX, originalClip.getBounds().getY(), Math.min(scaledXDuration + scaledXStart - newX, originalClip.getBounds().getX() + originalClip.getBounds().getWidth() - newX), Math.min(originalClip.getBounds().getHeight(), dim.getHeight()));
                g2d.setColor(this.myDurationBgColor == null ? lineChart.getBackground() : this.myDurationBgColor);
                g2d.setClip(clipRect);
                g2d.fill(clipRect);
                for (int j = 0; j < transformedPaths.size(); ++j) {
                    RangedContinuousSeries rangedSeries = series.get(j);
                    if (renderSeriesPredicate != null && !renderSeriesPredicate.test(data, rangedSeries)) continue;
                    LineChart.drawLine(g2d, transformedPaths.get(j), (LineConfig)configs.get(j));
                }
                if (this.myBackgroundClickable && this.myMousePosition != null && (double)this.myMousePosition.x > scaledXStart && (double)this.myMousePosition.x < scaledXStart + scaledXDuration) {
                    g2d.setColor((Color)BACKGROUND_HIGHLIGHT_COLOR);
                    g2d.fill(clipRect);
                }
                g2d.setClip(originalClip);
            }
        }
        if (this.myStroke != null) {
            g2d.setColor(this.myColor);
            g2d.setStroke(this.myStroke);
            Line2D.Float eventLine = new Line2D.Float();
            for (Rectangle2D.Float rect : this.myPathCache) {
                double scaledXStart = rect.x * (float)lineChart.getWidth();
                double scaledXDuration = rect.width * (float)lineChart.getWidth();
                g2d.translate(scaledXStart, 0.0);
                ((Line2D)eventLine).setLine(0.0, 0.0, 0.0, lineChart.getHeight());
                g2d.draw(eventLine);
                ((Line2D)eventLine).setLine(scaledXDuration, 0.0, scaledXDuration, lineChart.getHeight());
                g2d.draw(eventLine);
                g2d.translate(-scaledXStart, 0.0);
            }
        }
    }

    @VisibleForTesting
    Rectangle2D.Float getScaledClickRegion(@NotNull Rectangle2D.Float rect, int componentWidth, int componentHeight, boolean regionOnLineSeries) {
        float paddedHeight = rect.height + (float)(this.myClickRegionPaddingY * 2);
        float paddedWidth = rect.width + (float)(this.myClickRegionPaddingX * 2);
        int totalXInsets = this.myHostInsets.left + this.myHostInsets.right;
        float scaledStartX = (float)this.myHostInsets.left + rect.x * (float)(componentWidth - totalXInsets) + this.myLabelXOffset + this.myLineStrokeOffset;
        float scaledStartY = this.getClampedLabelY(rect.y, paddedHeight, componentHeight, !regionOnLineSeries);
        return new Rectangle2D.Float(scaledStartX, scaledStartY, paddedWidth, paddedHeight);
    }

    @Override
    public void renderOverlay(@NotNull Component host, @NotNull Graphics2D g2d) {
        for (int i2 = 0; i2 < this.myClickRegionCache.size(); ++i2) {
            Rectangle2D.Float rect = this.getScaledClickRegion(this.myClickRegionCache.get(i2), host.getWidth(), host.getHeight(), this.myRegionOnLineSeries.get(i2));
            if (this.myLabelBgColor != null) {
                g2d.setColor(this.myLabelBgColor);
                if (this.myMousePosition != null && rect.contains(this.myMousePosition)) {
                    g2d.setColor(this.myHoverHandler != null || this.myClick && this.myClickHandler != null ? this.myLabelClickedBgColor : this.myLabelHoveredBgColor);
                }
                g2d.fill(rect);
            }
            rect.x += (float)this.myClickRegionPaddingX;
            rect.y += (float)this.myClickRegionPaddingY;
            g2d.translate(rect.x, rect.y);
            Icon icon = this.getIcon((DurationData)this.myDataCache.get((int)i2).value);
            if (icon != null) {
                icon.paintIcon(host, g2d, 0, 0);
                float shift = icon.getIconWidth();
                g2d.translate(shift, 0.0);
                rect.x += shift;
            }
            if (this.myLabelProvider != null) {
                this.myLabelCache.get(i2).paint(g2d);
            }
            g2d.translate(-rect.x, -rect.y);
        }
        this.myClick = false;
    }

    private boolean isHoveringOverClickRegion(@NotNull Component overlayComponent, @NotNull MouseEvent event) {
        for (int i2 = 0; i2 < this.myClickRegionCache.size(); ++i2) {
            Rectangle2D.Float region = this.myClickRegionCache.get(i2);
            boolean regionOnLineSeries = this.myRegionOnLineSeries.get(i2);
            Rectangle2D.Float rect = this.getScaledClickRegion(region, overlayComponent.getWidth(), overlayComponent.getHeight(), regionOnLineSeries);
            if (this.myMousePosition == null || !rect.contains(this.myMousePosition)) continue;
            return true;
        }
        return this.myBackgroundClickable && this.calculateBackgroundData() != null;
    }

    @Override
    public boolean handleMouseEvent(@NotNull Component overlayComponent, @NotNull Component selectionComponent, @NotNull MouseEvent event) {
        this.myMousePosition = event.getPoint();
        if (event.getID() == 504) {
            this.myInComponentRegion = true;
        } else if (event.getID() == 505) {
            this.myInComponentRegion = false;
        }
        this.myMouseComponent = event.getComponent();
        E pickData = this.calculatePickData();
        if (this.myHoverHandler != null) {
            this.myHoverHandler.accept(pickData);
        }
        boolean bl = this.myClick = event.getClickCount() > 0 && event.getButton() == 1;
        if (this.myClickHandler != null && this.myClick) {
            if (pickData == null && this.myBackgroundClickable) {
                pickData = this.calculateBackgroundData();
            }
            if (pickData != null) {
                this.myClickHandler.accept(pickData);
                return true;
            }
        }
        if (this.isHoveringOverClickRegion(overlayComponent, event)) {
            selectionComponent.setCursor(Cursor.getPredefinedCursor(0));
            return true;
        }
        return false;
    }

    @Nullable
    private E calculateBackgroundData() {
        assert (this.myMousePosition != null);
        for (int i2 = 0; i2 < this.myPathCache.size(); ++i2) {
            Rectangle2D.Float rect = this.myPathCache.get(i2);
            Dimension dim = this.myMouseComponent.getSize();
            double scaledXStart = (double)rect.x * dim.getWidth();
            double scaledXWidth = (double)rect.width * dim.getWidth();
            if (!((double)this.myMousePosition.x >= scaledXStart) || !((double)this.myMousePosition.x < scaledXStart + scaledXWidth)) continue;
            return (E)((DurationData)this.myDataCache.get((int)i2).value);
        }
        return null;
    }

    @Nullable
    private E calculatePickData() {
        if (!this.myInComponentRegion || this.myMouseComponent == null) {
            return null;
        }
        DurationData closestData = null;
        double closestManhattanDistance = 3.4028234663852886E38;
        Dimension dim = this.myMouseComponent.getSize();
        for (int i2 = 0; i2 < this.myDataCache.size(); ++i2) {
            double manhattanDistance;
            Rectangle2D.Float rect = this.myClickRegionCache.get(i2);
            float paddedWidth = rect.width + (float)(this.myClickRegionPaddingX * 2);
            float paddedHeight = rect.height + (float)(this.myClickRegionPaddingY * 2);
            boolean onLineSeries = this.myRegionOnLineSeries.get(i2);
            float scaledY = this.getClampedLabelY(rect.y, paddedHeight, dim.height, !onLineSeries);
            Rectangle2D.Float scaledRect = new Rectangle2D.Float(rect.x * (float)dim.width + this.myLabelXOffset + this.myLineStrokeOffset, scaledY, paddedWidth, paddedWidth);
            if (!scaledRect.contains(this.myMousePosition) || !((manhattanDistance = Math.abs(this.myMousePosition.getX() + this.myMousePosition.getY() - scaledRect.getX() - scaledRect.getY() - (scaledRect.getWidth() + scaledRect.getHeight()) * 0.5)) < closestManhattanDistance)) continue;
            closestManhattanDistance = manhattanDistance;
            closestData = (DurationData)this.myDataCache.get((int)i2).value;
        }
        return (E)closestData;
    }

    private float getClampedLabelY(float normalizedY, float height, int hostHeight, boolean shouldRespectInsets) {
        float totalYInsets = this.myHostInsets.top + this.myHostInsets.bottom;
        float maxScaledY = (float)(hostHeight - this.myHostInsets.bottom) - height;
        float scaledY = (float)this.myHostInsets.top + normalizedY * ((float)hostHeight - totalYInsets) - height + this.myLabelYOffset;
        return shouldRespectInsets ? Math.max((float)this.myHostInsets.top, Math.min(scaledY, maxScaledY)) : scaledY;
    }

    @VisibleForTesting
    @Nullable
    Icon getIcon(E durationData) {
        if (this.myIconMapper != null) {
            return this.myIconMapper.apply(durationData);
        }
        if (this.myIcon != null) {
            return this.myIcon;
        }
        return null;
    }

    public static class Builder<E extends DurationData> {
        @NotNull
        private final DurationDataModel<E> myModel;
        @NotNull
        private final Color myColor;
        @Nullable
        private Color myDurationBgColor;
        @Nullable
        private Icon myIcon = null;
        @Nullable
        private Function<E, Icon> myIconMapper = null;
        @Nullable
        private Stroke myStroke = null;
        @Nullable
        private Function<E, String> myLabelProvider = null;
        @Nullable
        private Consumer<E> myClickHandler = null;
        @Nullable
        private Consumer<E> myHoverHandler = null;
        @Nullable
        private Color myLabelBgColor = null;
        @Nullable
        private Color myLabelHoveredBgColor = null;
        @Nullable
        private Color myLabelClickedBgColor = null;
        @Nullable
        private Color myLabelTextColor = null;
        private float myLabelXOffset;
        private float myLabelYOffset;
        @NotNull
        private Insets myHostInsets = JBInsets.emptyInsets();
        private int myClickRegionPaddingX = 4;
        private int myClickRegionPaddingY = 2;
        private boolean myBackgroundClickable = false;

        public Builder(@NotNull DurationDataModel<E> model2, @NotNull Color color) {
            this.myModel = model2;
            this.myColor = color;
        }

        public Builder<E> setDurationBg(@NotNull Color durationBgColor) {
            this.myDurationBgColor = durationBgColor;
            return this;
        }

        public Builder<E> setIcon(@NotNull Icon icon) {
            this.myIcon = icon;
            return this;
        }

        public Builder<E> setIconMapper(@Nullable Function<E, Icon> iconMapper) {
            this.myIconMapper = iconMapper;
            return this;
        }

        public Builder<E> setStroke(@NotNull Stroke stroke) {
            this.myStroke = stroke;
            return this;
        }

        public Builder<E> setLabelProvider(@NotNull Function<E, String> provider) {
            this.myLabelProvider = provider;
            return this;
        }

        public Builder<E> setClickHandler(@NotNull Consumer<E> handler2) {
            this.myClickHandler = handler2;
            return this;
        }

        public Builder<E> setHoverHandler(@NotNull Consumer<E> handler2) {
            this.myHoverHandler = handler2;
            return this;
        }

        public Builder<E> setLabelColors(@NotNull Color bgColor, @NotNull Color hoveredColor, @NotNull Color clickedColor, @NotNull Color color) {
            this.myLabelBgColor = bgColor;
            this.myLabelHoveredBgColor = hoveredColor;
            this.myLabelClickedBgColor = clickedColor;
            this.myLabelTextColor = color;
            return this;
        }

        public Builder<E> setLabelOffsets(float xOffset, float yOffset) {
            this.myLabelXOffset = xOffset;
            this.myLabelYOffset = yOffset;
            return this;
        }

        public Builder<E> setHostInsets(@NotNull Insets insets) {
            this.myHostInsets = insets;
            return this;
        }

        public Builder<E> setClickRegionPadding(int xPadding, int yPadding) {
            this.myClickRegionPaddingX = xPadding;
            this.myClickRegionPaddingY = yPadding;
            return this;
        }

        public Builder<E> setBackgroundClickable(boolean clickable) {
            this.myBackgroundClickable = clickable;
            return this;
        }

        @NotNull
        public DurationDataRenderer<E> build() {
            return new DurationDataRenderer<E>(this.myModel, this);
        }
    }
}

