/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.intellij.icons.AllIcons;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ZoomType {
    FIT("Zoom to Fit Screen", "Zoom to Fit Screen", AllIcons.General.FitContent, AllIcons.General.FitContent),
    ACTUAL("Zoom to Actual Size (100%)", "100%", null, AllIcons.General.ActualZoom),
    IN("Zoom In", "Zoom In", AllIcons.General.ZoomIn, AllIcons.General.Add),
    OUT("Zoom Out", "Zoom Out", AllIcons.General.ZoomOut, AllIcons.General.Remove);

    private final String myLabel;
    private final String myFloatingLabel;
    private final Icon myIcon;
    private final Icon myFloatingIcon;
    private static final int[] ZOOM_POINTS;

    private ZoomType(@Nullable String normalLabel, @Nullable String floatingLabel, Icon normalIcon, Icon floatingIcon) {
        this.myLabel = normalLabel;
        this.myFloatingLabel = floatingLabel;
        this.myIcon = normalIcon;
        this.myFloatingIcon = floatingIcon;
    }

    public String getLabel() {
        return this.myLabel;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public Icon getFloatingIcon() {
        return this.myFloatingIcon;
    }

    public String getFloatingLabel() {
        return this.myFloatingLabel;
    }

    public String toString() {
        return this.getLabel();
    }

    public static int zoomIn(int percentage) {
        return ZoomType.zoomIn(percentage, ZOOM_POINTS);
    }

    public static int zoomIn(int percentage, int @NotNull [] zoomPoints) {
        int i2 = Arrays.binarySearch(zoomPoints, percentage);
        if (i2 < 0) {
            if ((i2 = -i2 - 1) == 0 && (double)percentage < (double)zoomPoints[0] * 0.75) {
                return Math.min((int)Math.ceil((double)percentage * 1.2), zoomPoints[0]);
            }
            if (i2 < zoomPoints.length) {
                return zoomPoints[i2];
            }
            return (percentage / 100 + 1) * 100;
        }
        if (i2 < zoomPoints.length - 1) {
            return zoomPoints[i2 + 1];
        }
        return percentage + 100;
    }

    public static int zoomOut(int percentage) {
        return ZoomType.zoomOut(percentage, ZOOM_POINTS);
    }

    public static int zoomOut(int percentage, int @NotNull [] zoomPoints) {
        int i2 = Arrays.binarySearch(zoomPoints, percentage);
        if (i2 < 0) {
            if ((i2 = -i2 - 1) == 0) {
                return (int)Math.floor((double)percentage / 1.1);
            }
            if (i2 < zoomPoints.length) {
                return zoomPoints[i2 - 1];
            }
            return (percentage / 100 - 1) * 100;
        }
        if (i2 > 0) {
            return zoomPoints[i2 - 1];
        }
        return (int)Math.floor((double)percentage / 1.1);
    }

    static {
        ZOOM_POINTS = new int[]{25, 33, 50, 67, 75, 90, 100, 110, 125, 150, 200};
    }
}

