/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TabularLayoutKt;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u000545678B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB%\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\"H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010)\u001a\u00020(2\u0006\u0010&\u001a\u00020\"H\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010&\u001a\u00020\"H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0004J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0007J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0014J\u0014\u00101\u001a\u00020(*\u00020\"2\u0006\u00102\u001a\u000203H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00040\u000fj\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0004`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/android/tools/adtui/TabularLayout;", "Ljava/awt/LayoutManager2;", "colSizes", "", "Lcom/android/tools/adtui/TabularLayout$SizingRule;", "([Lcom/android/tools/adtui/TabularLayout$SizingRule;)V", "colSizesString", "", "(Ljava/lang/String;)V", "initialRowSizesString", "(Ljava/lang/String;Ljava/lang/String;)V", "initialRowSizes", "([Lcom/android/tools/adtui/TabularLayout$SizingRule;[Lcom/android/tools/adtui/TabularLayout$SizingRule;)V", "", "constraints", "Ljava/util/HashMap;", "Ljava/awt/Component;", "Lcom/android/tools/adtui/TabularLayout$Constraint;", "Lkotlin/collections/HashMap;", "numColumns", "", "getNumColumns", "()I", "rowSizes", "vGap", "addLayoutComponent", "", "comp", "constraint", "", "name", "getLayoutAlignmentX", "", "target", "Ljava/awt/Container;", "getLayoutAlignmentY", "invalidateLayout", "layoutContainer", "parent", "maximumLayoutSize", "Ljava/awt/Dimension;", "minimumLayoutSize", "preferredLayoutSize", "removeLayoutComponent", "setRowSizing", "rowIndex", "rowSize", "rowSizeString", "setVGap", "getLayoutSize", "includeExtraSize", "", "Constraint", "LayoutResult", "PosSize", "SizeCalculator", "SizingRule", "intellij.android.adt.ui"})
public final class TabularLayout
implements LayoutManager2 {
    @NotNull
    private final List<SizingRule> colSizes;
    @NotNull
    private final HashMap<Integer, SizingRule> rowSizes;
    private int vGap;
    @NotNull
    private final HashMap<Component, Constraint> constraints;

    public TabularLayout(@NotNull SizingRule[] colSizes, @NotNull SizingRule[] initialRowSizes) {
        Intrinsics.checkNotNullParameter((Object)colSizes, (String)"colSizes");
        Intrinsics.checkNotNullParameter((Object)initialRowSizes, (String)"initialRowSizes");
        this.colSizes = CollectionsKt.listOf((Object[])Arrays.copyOf(colSizes, colSizes.length));
        this.rowSizes = new HashMap();
        this.constraints = new HashMap();
        int n = initialRowSizes.length;
        for (int j = 0; j < n; ++j) {
            int i2 = j;
            SizingRule irs = initialRowSizes[j];
            this.setRowSizing(i2, irs);
        }
    }

    public final int getNumColumns() {
        return this.colSizes.size();
    }

    public TabularLayout(SizingRule ... colSizes) {
        Intrinsics.checkNotNullParameter((Object)colSizes, (String)"colSizes");
        this(colSizes, new SizingRule[0]);
    }

    public TabularLayout(@NotNull String colSizesString) {
        Intrinsics.checkNotNullParameter((Object)colSizesString, (String)"colSizesString");
        SizingRule[] sizingRuleArray = TabularLayoutKt.access$parseSizingRules(colSizesString);
        this(Arrays.copyOf(sizingRuleArray, sizingRuleArray.length));
    }

    public TabularLayout(@NotNull String colSizesString, @NotNull String initialRowSizesString) {
        Intrinsics.checkNotNullParameter((Object)colSizesString, (String)"colSizesString");
        Intrinsics.checkNotNullParameter((Object)initialRowSizesString, (String)"initialRowSizesString");
        this(TabularLayoutKt.access$parseSizingRules(colSizesString), TabularLayoutKt.access$parseSizingRules(initialRowSizesString));
    }

    @NotNull
    public final TabularLayout setVGap(int vGap) {
        this.vGap = vGap;
        return this;
    }

    @NotNull
    public final TabularLayout setRowSizing(int rowIndex, @NotNull SizingRule rowSize) {
        Intrinsics.checkNotNullParameter((Object)rowSize, (String)"rowSize");
        Integer n = rowIndex;
        ((Map)this.rowSizes).put(n, rowSize);
        return this;
    }

    @NotNull
    public final TabularLayout setRowSizing(int rowIndex, @NotNull String rowSizeString) {
        Intrinsics.checkNotNullParameter((Object)rowSizeString, (String)"rowSizeString");
        return this.setRowSizing(rowIndex, SizingRule.Companion.fromString(rowSizeString));
    }

    @Override
    public void addLayoutComponent(@NotNull Component comp, @NotNull Object constraint) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        if (!(constraint instanceof Constraint)) {
            boolean $i$a$-require-TabularLayout$addLayoutComponent$22 = false;
            String $i$a$-require-TabularLayout$addLayoutComponent$22 = "Children of containers using " + this.getClass().getSimpleName() + " must be added with a constraint";
            throw new IllegalArgumentException($i$a$-require-TabularLayout$addLayoutComponent$22.toString());
        }
        Constraint $this$addLayoutComponent_u24lambda_u2d2 = (Constraint)constraint;
        boolean bl = false;
        if (!($this$addLayoutComponent_u24lambda_u2d2.getCol() + $this$addLayoutComponent_u24lambda_u2d2.getColSpan() <= this.colSizes.size())) {
            boolean bl2 = false;
            String string = "Component added with invalid column span. col: " + $this$addLayoutComponent_u24lambda_u2d2.getCol() + ", span: " + $this$addLayoutComponent_u24lambda_u2d2.getColSpan() + ", num cols: " + this.colSizes.size();
            throw new IllegalArgumentException(string.toString());
        }
        ((Map)this.constraints).put(comp, constraint);
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return 0.5f;
    }

    @Override
    public void invalidateLayout(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
    }

    @Override
    public void addLayoutComponent(@NotNull String name, @NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
    }

    @Override
    public void removeLayoutComponent(@NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        this.constraints.remove(comp);
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.getLayoutSize(parent, true);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.getLayoutSize(parent, false);
    }

    private final Dimension getLayoutSize(Container $this$getLayoutSize, boolean includeExtraSize) {
        LayoutResult result = new LayoutResult($this$getLayoutSize);
        int w = result.getColCalculator().getTotalSize(includeExtraSize);
        int h = result.getRowCalculator().getTotalSize(includeExtraSize);
        Insets $this$getLayoutSize_u24lambda_u2d3 = result.getInsets();
        boolean bl = false;
        return new Dimension($this$getLayoutSize_u24lambda_u2d3.left + $this$getLayoutSize_u24lambda_u2d3.right + w, $this$getLayoutSize_u24lambda_u2d3.top + $this$getLayoutSize_u24lambda_u2d3.bottom + h);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layoutContainer(@NotNull Container parent) {
        Sequence visibleComponents2;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        boolean bl = EdtInvocationManager.getInstance().isEventDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        LayoutResult result = new LayoutResult(parent);
        SizeCalculator colCalc = result.getColCalculator();
        SizeCalculator rowCalc = result.getRowCalculator();
        if (colCalc.getLength() == 0 || rowCalc.getLength() == 0) {
            return;
        }
        Insets insets = parent.getInsets();
        List<PosSize> rowBounds = rowCalc.getBounds(insets.top, parent.getHeight() - insets.bottom - insets.top);
        List<PosSize> colBounds = colCalc.getBounds(insets.left, parent.getWidth() - insets.right - insets.left);
        Sequence $this$forEach$iv = visibleComponents2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Object)0, (Function1)layoutContainer.visibleComponents.1.INSTANCE), (int)parent.getComponentCount()), (Function1)((Function1)new Function1<Integer, Component>(parent){
            final /* synthetic */ Container $parent;
            {
                this.$parent = $parent;
                super(1);
            }

            public final Component invoke(int it) {
                return this.$parent.getComponent(it);
            }
        })), (Function1)layoutContainer.visibleComponents.3.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            int n2;
            int n3;
            Constraint cons;
            Component comp = (Component)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)this.constraints.get(comp));
            Iterable $this$sumBy$iv = (Iterable)RangesKt.until((int)cons.getCol(), (int)(cons.getCol() + cons.getColSpan()));
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            Iterator iterator = $this$sumBy$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int element$iv2;
                int n4 = element$iv2 = ((IntIterator)iterator).nextInt();
                n3 = sum$iv;
                n2 = 0;
                n = colBounds.get((int)it).getSize();
                sum$iv = n3 + n;
            }
            int totalWidth = sum$iv;
            Iterable $this$sumBy$iv2 = (Iterable)RangesKt.until((int)cons.getRow(), (int)(cons.getRow() + cons.getRowSpan()));
            boolean $i$f$sumBy2 = false;
            int sum$iv2 = 0;
            Iterator iterator2 = $this$sumBy$iv2.iterator();
            while (iterator2.hasNext()) {
                void it;
                int element$iv3;
                n2 = element$iv3 = ((IntIterator)iterator2).nextInt();
                n3 = sum$iv2;
                boolean bl3 = false;
                n = rowBounds.get((int)it).getSize();
                sum$iv2 = n3 + n;
            }
            int totalHeight = sum$iv2;
            PosSize c = colBounds.get(cons.getCol());
            PosSize r = rowBounds.get(cons.getRow());
            comp.setBounds(c.getPos(), r.getPos(), totalWidth, totalHeight);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizingRule;", "", "type", "Lcom/android/tools/adtui/TabularLayout$SizingRule$Type;", "value", "", "(Lcom/android/tools/adtui/TabularLayout$SizingRule$Type;I)V", "getType", "()Lcom/android/tools/adtui/TabularLayout$SizingRule$Type;", "getValue", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "FitSizing", "Type", "intellij.android.adt.ui"})
    public static final class SizingRule {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Type type;
        private final int value;

        public SizingRule(@NotNull Type type, int value) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.value = value;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public final int getValue() {
            return this.value;
        }

        @NotNull
        public final Type component1() {
            return this.type;
        }

        public final int component2() {
            return this.value;
        }

        @NotNull
        public final SizingRule copy(@NotNull Type type, int value) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new SizingRule(type, value);
        }

        public static /* synthetic */ SizingRule copy$default(SizingRule sizingRule, Type type, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                type = sizingRule.type;
            }
            if ((n2 & 2) != 0) {
                n = sizingRule.value;
            }
            return sizingRule.copy(type, n);
        }

        @NotNull
        public String toString() {
            return "SizingRule(type=" + this.type + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.value);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SizingRule)) {
                return false;
            }
            SizingRule sizingRule = (SizingRule)other;
            if (this.type != sizingRule.type) {
                return false;
            }
            return this.value == sizingRule.value;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizingRule$Type;", "", "(Ljava/lang/String;I)V", "FIT", "FIXED", "PROPORTIONAL", "intellij.android.adt.ui"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type FIT = new Type();
            public static final /* enum */ Type FIXED = new Type();
            public static final /* enum */ Type PROPORTIONAL = new Type();
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            static {
                $VALUES = typeArray = new Type[]{Type.FIT, Type.FIXED, Type.PROPORTIONAL};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizingRule$FitSizing;", "", "(Ljava/lang/String;I)V", "MINIMUM", "PREFERRED", "intellij.android.adt.ui"})
        public static final class FitSizing
        extends Enum<FitSizing> {
            public static final /* enum */ FitSizing MINIMUM = new FitSizing();
            public static final /* enum */ FitSizing PREFERRED = new FitSizing();
            private static final /* synthetic */ FitSizing[] $VALUES;

            public static FitSizing[] values() {
                return (FitSizing[])$VALUES.clone();
            }

            public static FitSizing valueOf(String value) {
                return Enum.valueOf(FitSizing.class, value);
            }

            static {
                $VALUES = fitSizingArray = new FitSizing[]{FitSizing.MINIMUM, FitSizing.PREFERRED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizingRule$Companion;", "", "()V", "fromString", "Lcom/android/tools/adtui/TabularLayout$SizingRule;", "s", "", "intellij.android.adt.ui"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SizingRule fromString(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                try {
                    SizingRule sizingRule;
                    if (Intrinsics.areEqual((Object)s, (Object)"*")) {
                        sizingRule = new SizingRule(Type.PROPORTIONAL, 1);
                    } else if (StringsKt.startsWith$default((String)s, (String)"Fit", (boolean)false, (int)2, null)) {
                        sizingRule = new SizingRule(Type.FIT, com.android.tools.adtui.TabularLayout$SizingRule$Companion.fromString$getFitSizing(s).ordinal());
                    } else if (StringsKt.endsWith$default((String)s, (String)"px", (boolean)false, (int)2, null)) {
                        sizingRule = new SizingRule(Type.FIXED, Integer.parseInt(StringsKt.dropLast((String)s, (int)2)));
                    } else if (StringsKt.endsWith$default((String)s, (String)"*", (boolean)false, (int)2, null)) {
                        sizingRule = new SizingRule(Type.PROPORTIONAL, Integer.parseInt(StringsKt.dropLast((String)s, (int)1)));
                    } else {
                        throw new IllegalArgumentException("Bad size value: \"" + s + "\"");
                    }
                    return sizingRule;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Bad size value: \"" + s + "\"");
                }
            }

            private static final FitSizing fromString$getFitSizing(String $this$fromString_u24getFitSizing) {
                FitSizing fitSizing;
                FitSizing it = fitSizing = FitSizing.MINIMUM;
                boolean bl = false;
                FitSizing fitSizing2 = StringsKt.endsWith$default((CharSequence)$this$fromString_u24getFitSizing, (char)'-', (boolean)false, (int)2, null) ? fitSizing : null;
                if (fitSizing2 == null) {
                    fitSizing2 = FitSizing.PREFERRED;
                }
                return fitSizing2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/adtui/TabularLayout$Constraint;", "", "row", "", "col", "colSpan", "(III)V", "rowSpan", "(IIII)V", "getCol", "()I", "getColSpan", "getRow", "getRowSpan", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.adt.ui"})
    public static final class Constraint {
        private final int row;
        private final int col;
        private final int rowSpan;
        private final int colSpan;

        public Constraint(int row, int col, int rowSpan, int colSpan) {
            this.row = row;
            this.col = col;
            this.rowSpan = rowSpan;
            this.colSpan = colSpan;
            if (!(this.colSpan > 0)) {
                boolean bl = false;
                String string = "TabularLayout column span must be greater than 0";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final int getRow() {
            return this.row;
        }

        public final int getCol() {
            return this.col;
        }

        public final int getRowSpan() {
            return this.rowSpan;
        }

        public final int getColSpan() {
            return this.colSpan;
        }

        @JvmOverloads
        public Constraint(int row, int col, int colSpan) {
            this(row, col, 1, colSpan);
        }

        public /* synthetic */ Constraint(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 4) != 0) {
                n3 = 1;
            }
            this(n, n2, n3);
        }

        public final int component1() {
            return this.row;
        }

        public final int component2() {
            return this.col;
        }

        public final int component3() {
            return this.rowSpan;
        }

        public final int component4() {
            return this.colSpan;
        }

        @NotNull
        public final Constraint copy(int row, int col, int rowSpan, int colSpan) {
            return new Constraint(row, col, rowSpan, colSpan);
        }

        public static /* synthetic */ Constraint copy$default(Constraint constraint, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = constraint.row;
            }
            if ((n5 & 2) != 0) {
                n2 = constraint.col;
            }
            if ((n5 & 4) != 0) {
                n3 = constraint.rowSpan;
            }
            if ((n5 & 8) != 0) {
                n4 = constraint.colSpan;
            }
            return constraint.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Constraint(row=" + this.row + ", col=" + this.col + ", rowSpan=" + this.rowSpan + ", colSpan=" + this.colSpan + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.row);
            result = result * 31 + Integer.hashCode(this.col);
            result = result * 31 + Integer.hashCode(this.rowSpan);
            result = result * 31 + Integer.hashCode(this.colSpan);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Constraint)) {
                return false;
            }
            Constraint constraint = (Constraint)other;
            if (this.row != constraint.row) {
                return false;
            }
            if (this.col != constraint.col) {
                return false;
            }
            if (this.rowSpan != constraint.rowSpan) {
                return false;
            }
            return this.colSpan == constraint.colSpan;
        }

        @JvmOverloads
        public Constraint(int row, int col) {
            this(row, col, 0, 4, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u001b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizeCalculator;", "", "sparseRules", "", "", "Lcom/android/tools/adtui/TabularLayout$SizingRule;", "numRules", "gap", "(Ljava/util/Map;II)V", "rules", "", "(Ljava/util/List;I)V", "extraSize", "length", "getLength", "()I", "percentages", "", "", "sizes", "getBounds", "Lcom/android/tools/adtui/TabularLayout$PosSize;", "start", "totalSpace", "getComponentDimension", "Ljava/awt/Dimension;", "i", "c", "Ljava/awt/Component;", "getTotalSize", "includeExtraSize", "", "notifySize", "", "size", "intellij.android.adt.ui"})
    private static final class SizeCalculator {
        @NotNull
        private final List<SizingRule> rules;
        private final int gap;
        @NotNull
        private final List<Integer> sizes;
        @NotNull
        private final List<Float> percentages;
        private int extraSize;

        /*
         * WARNING - void declaration
         */
        public SizeCalculator(@NotNull List<SizingRule> rules, int gap) {
            void $this$sumBy$iv;
            void $this$filterTo$iv$iv;
            ArrayList<Number> arrayList;
            int n;
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            this.rules = rules;
            this.gap = gap;
            int n2 = this.rules.size();
            SizeCalculator sizeCalculator = this;
            Object object = new ArrayList<Number>(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n = n3++;
                arrayList = object;
                boolean bl = false;
                arrayList.add(0);
            }
            sizeCalculator.sizes = (List)object;
            n2 = this.rules.size();
            sizeCalculator = this;
            object = new ArrayList(n2);
            n3 = 0;
            while (n3 < n2) {
                int it = n = n3++;
                arrayList = object;
                boolean bl = false;
                arrayList.add(Float.valueOf(0.0f));
            }
            sizeCalculator.percentages = (List)object;
            Iterable $this$filter$iv = this.rules;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SizingRule it = (SizingRule)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == SizingRule.Type.PROPORTIONAL)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                SizingRule sizingRule = (SizingRule)element$iv;
                int n5 = sum$iv;
                boolean bl = false;
                int n6 = it.getValue();
                sum$iv = n5 + n6;
            }
            float totalProportionalSize = sum$iv;
            object = this.rules.iterator();
            n3 = 0;
            while (object.hasNext()) {
                int i2 = n3++;
                SizingRule rule = (SizingRule)object.next();
                switch (WhenMappings.$EnumSwitchMapping$0[rule.getType().ordinal()]) {
                    case 1: {
                        boolean bl;
                        boolean bl2 = bl = totalProportionalSize > 0.0f;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        this.percentages.set(i2, Float.valueOf((float)rule.getValue() / totalProportionalSize));
                        break;
                    }
                    case 2: {
                        this.sizes.set(i2, JBUI.scale((int)rule.getValue()));
                    }
                }
            }
        }

        public final int getLength() {
            return this.sizes.size();
        }

        public SizeCalculator(@NotNull Map<Integer, SizingRule> sparseRules, int numRules, int gap) {
            Intrinsics.checkNotNullParameter(sparseRules, (String)"sparseRules");
            this(TabularLayoutKt.access$fromSparseRules(sparseRules, numRules), gap);
        }

        public final void notifySize(int i2, int size) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.rules.get(i2).getType().ordinal()]) {
                case 3: {
                    this.sizes.set(i2, RangesKt.coerceAtLeast((int)((Number)this.sizes.get(i2)).intValue(), (int)size));
                    break;
                }
                case 1: {
                    this.extraSize = RangesKt.coerceAtLeast((int)this.extraSize, (int)MathKt.roundToInt((float)((float)size / ((Number)this.percentages.get(i2)).floatValue())));
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @NotNull
        public final Dimension getComponentDimension(int i2, @NotNull Component c) {
            Dimension dimension;
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            if (this.rules.get(i2).getValue() == SizingRule.FitSizing.PREFERRED.ordinal()) {
                Dimension dimension2 = c.getPreferredSize();
                dimension = dimension2;
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"c.preferredSize");
            } else {
                Dimension dimension3 = c.getMinimumSize();
                dimension = dimension3;
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"c.minimumSize");
            }
            return dimension;
        }

        /*
         * WARNING - void declaration
         */
        public final int getTotalSize(boolean includeExtraSize) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.sizes;
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(it > 0)) continue;
                destination$iv$iv22.add(element$iv$iv);
            }
            List notZeroSizes = (List)destination$iv$iv22;
            int gapsNeeded = RangesKt.coerceAtLeast((int)(notZeroSizes.size() - 1), (int)0);
            object = this.extraSize;
            int destination$iv$iv22 = ((Number)object).intValue();
            int n = CollectionsKt.sumOfInt((Iterable)notZeroSizes) + this.gap * gapsNeeded;
            boolean bl = false;
            boolean bl2 = includeExtraSize;
            Object object2 = bl2 ? object : null;
            return n + (object2 != null ? (Integer)object2 : 0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PosSize> getBounds(int start, int totalSpace) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable $this$mapTo$iv$iv;
            if (this.sizes.size() == 0) {
                return CollectionsKt.emptyList();
            }
            int remainingSpace = totalSpace - CollectionsKt.sumOfInt((Iterable)this.sizes);
            Iterable $this$map$iv = this.sizes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PosSize posSize;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PosSize $this$getBounds_u24lambda_u2d7_u24lambda_u2d6 = posSize = new PosSize(0, 0, 3, null);
                boolean bl2 = false;
                $this$getBounds_u24lambda_u2d7_u24lambda_u2d6.setSize((int)it);
                collection.add(posSize);
            }
            List bounds = (List)destination$iv$iv;
            if (remainingSpace > 0) {
                PosSize $this$forEach$iv2;
                Iterator $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2;
                int spaceUsed = 0;
                int lastIndex = 0;
                lastIndex = -1;
                $this$mapTo$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)this.rules);
                boolean $i$f$filter = false;
                void $i$f$mapTo2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator it = $this$filterTo$iv$iv2.iterator();
                while (it.hasNext()) {
                    Object element$iv$iv = it.next();
                    int it2 = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(this.rules.get(it2).getType() == SizingRule.Type.PROPORTIONAL)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv2;
                boolean $i$f$forEach = false;
                $this$filterTo$iv$iv2 = $this$forEach$iv2.iterator();
                while ($this$filterTo$iv$iv2.hasNext()) {
                    Object element$iv = $this$filterTo$iv$iv2.next();
                    int i2 = ((Number)element$iv).intValue();
                    boolean bl = false;
                    ((PosSize)bounds.get(i2)).setSize(MathKt.roundToInt((float)((float)remainingSpace * ((Number)this.percentages.get(i2)).floatValue())));
                    spaceUsed += ((PosSize)bounds.get(i2)).getSize();
                    lastIndex = i2;
                }
                if (spaceUsed != remainingSpace && lastIndex >= 0) {
                    $this$forEach$iv2 = (PosSize)bounds.get(lastIndex);
                    $this$forEach$iv2.setSize($this$forEach$iv2.getSize() + (remainingSpace - spaceUsed));
                }
            }
            int pos = 0;
            pos = start;
            Iterable lastIndex = bounds;
            boolean $i$f$filter = false;
            void $i$f$forEach = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PosSize it = (PosSize)element$iv$iv;
                boolean bl = false;
                if (!(it.getSize() > 0)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                PosSize it = (PosSize)element$iv;
                boolean bl = false;
                it.setPos(pos);
                pos += it.getSize() + this.gap;
            }
            return bounds;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SizingRule.Type.values().length];
                nArray[SizingRule.Type.PROPORTIONAL.ordinal()] = 1;
                nArray[SizingRule.Type.FIXED.ordinal()] = 2;
                nArray[SizingRule.Type.FIT.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/adtui/TabularLayout$PosSize;", "", "pos", "", "size", "(II)V", "getPos", "()I", "setPos", "(I)V", "getSize", "setSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.adt.ui"})
    private static final class PosSize {
        private int pos;
        private int size;

        public PosSize(int pos, int size) {
            this.pos = pos;
            this.size = size;
        }

        public /* synthetic */ PosSize(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        public final int component1() {
            return this.pos;
        }

        public final int component2() {
            return this.size;
        }

        @NotNull
        public final PosSize copy(int pos, int size) {
            return new PosSize(pos, size);
        }

        public static /* synthetic */ PosSize copy$default(PosSize posSize, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = posSize.pos;
            }
            if ((n3 & 2) != 0) {
                n2 = posSize.size;
            }
            return posSize.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "PosSize(pos=" + this.pos + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.pos);
            result = result * 31 + Integer.hashCode(this.size);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PosSize)) {
                return false;
            }
            PosSize posSize = (PosSize)other;
            if (this.pos != posSize.pos) {
                return false;
            }
            return this.size == posSize.size;
        }

        public PosSize() {
            this(0, 0, 3, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/adtui/TabularLayout$LayoutResult;", "", "container", "Ljava/awt/Container;", "(Lcom/android/tools/adtui/TabularLayout;Ljava/awt/Container;)V", "colCalculator", "Lcom/android/tools/adtui/TabularLayout$SizeCalculator;", "getColCalculator", "()Lcom/android/tools/adtui/TabularLayout$SizeCalculator;", "insets", "Ljava/awt/Insets;", "getInsets", "()Ljava/awt/Insets;", "rowCalculator", "getRowCalculator", "intellij.android.adt.ui"})
    private final class LayoutResult {
        @NotNull
        private final Insets insets;
        @NotNull
        private final SizeCalculator colCalculator;
        @NotNull
        private final SizeCalculator rowCalculator;

        /*
         * WARNING - void declaration
         */
        public LayoutResult(Container container) {
            void $this$filterTo$iv$iv;
            Object it;
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            this.colCalculator = new SizeCalculator(TabularLayout.this.colSizes, 0);
            boolean bl = EdtInvocationManager.getInstance().isEventDispatchThread();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            List components = new ArrayList();
            int numRows = 0;
            Insets insets = container.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"container.insets");
            this.insets = insets;
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)container.getComponentCount());
            boolean $i$f$map22 = false;
            void var7_12 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(container.getComponent((int)it2));
            }
            $this$map$iv = (List)destination$iv$iv;
            TabularLayout $i$f$map22 = TabularLayout.this;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Constraint constraint;
                it = (Component)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                components.add(it);
                if ((Constraint)$i$f$map22.constraints.get(it) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)constraint, (String)"constraints[it] ?: return@forEach");
                numRows = RangesKt.coerceAtLeast((int)numRows, (int)(constraint.getRow() + 1));
            }
            this.rowCalculator = new SizeCalculator(TabularLayout.this.rowSizes, numRows, TabularLayout.this.vGap);
            Iterable $this$filter$iv = components;
            boolean $i$f$filter = false;
            Iterable $i$f$forEach22 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Component it3 = (Component)element$iv$iv;
                boolean bl4 = false;
                if (!it3.isVisible()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            TabularLayout tabularLayout = TabularLayout.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Dimension size;
                Constraint constraint;
                it = (Component)element$iv;
                boolean bl5 = false;
                if ((Constraint)tabularLayout.constraints.get(it) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)constraint, (String)"constraints[it] ?: return@forEach");
                if (constraint.getColSpan() == 1) {
                    size = this.colCalculator.getComponentDimension(constraint.getCol(), (Component)it);
                    this.colCalculator.notifySize(constraint.getCol(), size.width);
                }
                if (constraint.getRowSpan() != 1) continue;
                size = this.rowCalculator.getComponentDimension(constraint.getRow(), (Component)it);
                this.rowCalculator.notifySize(constraint.getRow(), size.height);
            }
        }

        @NotNull
        public final Insets getInsets() {
            return this.insets;
        }

        @NotNull
        public final SizeCalculator getColCalculator() {
            return this.colCalculator;
        }

        @NotNull
        public final SizeCalculator getRowCalculator() {
            return this.rowCalculator;
        }
    }
}

