/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.RotatedLabel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AxisComponent
extends AnimatedComponent {
    private static final BasicStroke DEFAULT_AXIS_STROKE = new BasicStroke(1.0f);
    private static final int MARKER_LABEL_OFFSET_PX = 5;
    private static final int MAXIMUM_LABEL_WIDTH = 50;
    private static final int DEFAULT_MAJOR_MARKER_LENGTH = 10;
    private static final int DEFAULT_MINOR_MARKER_LENGTH = 4;
    @VisibleForTesting
    static final float REMOVE_MAJOR_TICK_DENSITY = 1.1f;
    private static final JBColor DEFAULT_VERT_AXIS_TICK_COLOR = new JBColor(new Color(0, 0, 0, 64), new Color(255, 255, 255, 102));
    private static final JBColor DEFAULT_HORIZ_AXIS_TICK_COLOR = new JBColor(new Color(0xB9B9B9), new Color(0x656464));
    @Nullable
    private JLabel myLabel;
    private int myAxisLength;
    private final FloatArrayList myMajorMarkerPositions;
    private final FloatArrayList myMinorMarkerPositions;
    @NotNull
    private final List<String> myMarkerLabels;
    @NotNull
    private Color myMarkerColor;
    private float myMarkerLabelDensity;
    private String myMaxLabel;
    private String myMinLabel;
    private AxisComponentModel myModel;
    @NotNull
    private final AxisOrientation myOrientation;
    private boolean myCalculateMarkers;
    private int myMajorMarkerLength = 10;
    private int myMinorMarkerLength = 4;
    private int myStartMargin;
    private int myEndMargin;
    private boolean myShowMin;
    private boolean myShowMax;
    private boolean myOnlyShowUnitAtMax;
    private boolean myShowAxisLine = true;
    private boolean myShowLabels = true;
    private boolean myHideTickAtMin;

    public AxisComponent(@NotNull AxisComponentModel model2, @NotNull AxisOrientation orientation) {
        this.myModel = model2;
        this.myMajorMarkerPositions = new FloatArrayList();
        this.myMinorMarkerPositions = new FloatArrayList();
        this.myMarkerLabels = new ArrayList<String>();
        this.myOrientation = orientation;
        switch (this.myOrientation) {
            case LEFT: 
            case RIGHT: {
                this.myMarkerColor = DEFAULT_VERT_AXIS_TICK_COLOR;
                break;
            }
            default: {
                this.myMarkerColor = DEFAULT_HORIZ_AXIS_TICK_COLOR;
            }
        }
        if (!this.myModel.getLabel().isEmpty()) {
            switch (this.myOrientation) {
                case LEFT: 
                case RIGHT: {
                    this.myLabel = new RotatedLabel(this.myModel.getLabel());
                    this.myLabel.setSize(this.mDefaultFontMetrics.getHeight(), this.mDefaultFontMetrics.stringWidth(this.myModel.getLabel()));
                    break;
                }
                default: {
                    this.myLabel = new JBLabel(this.myModel.getLabel());
                    this.myLabel.setSize(this.mDefaultFontMetrics.stringWidth(this.myModel.getLabel()), this.mDefaultFontMetrics.getHeight());
                }
            }
            this.myLabel.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        }
        this.setForeground(AdtUiUtils.DEFAULT_FONT_COLOR);
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.myModel.addDependency(this.myAspectObserver).onChange(AxisComponentModel.Aspect.AXIS, this::modelChanged);
        this.myCalculateMarkers = true;
    }

    private void modelChanged() {
        this.myCalculateMarkers = true;
        this.opaqueRepaint();
    }

    @Nullable
    public String getLabel() {
        return this.myLabel == null ? null : this.myLabel.getText();
    }

    @NotNull
    @VisibleForTesting
    public AxisOrientation getOrientation() {
        return this.myOrientation;
    }

    @VisibleForTesting
    float getMarkerLabelDensity() {
        return this.myMarkerLabelDensity;
    }

    void calculateMarkers(@NotNull Dimension dimension) {
        this.myMarkerLabels.clear();
        this.myMajorMarkerPositions.clear();
        this.myMinorMarkerPositions.clear();
        double currentMinValueRelative = this.myModel.getRange().getMin() - this.myModel.getZero();
        double currentMaxValueRelative = this.myModel.getRange().getMax() - this.myModel.getZero();
        double range = this.myModel.getRange().getLength();
        double labelRange = this.myModel.getDataRange();
        BaseAxisFormatter formatter = this.myModel.getFormatter();
        float majorInterval = formatter.getMajorInterval(range);
        float minorInterval = formatter.getMinorInterval(majorInterval);
        float minorScale = range == 0.0 ? 1.0f : (float)((double)minorInterval / range);
        double firstMarkerValue = Math.floor(currentMinValueRelative / (double)majorInterval) * (double)majorInterval;
        float firstMarkerOffset = (float)((double)minorScale * (firstMarkerValue - currentMinValueRelative) / (double)minorInterval);
        int numMarkers = (int)Math.floor((currentMaxValueRelative - firstMarkerValue) / (double)minorInterval) + 1;
        int numMinorPerMajor = (int)(majorInterval / minorInterval);
        int drawableHeight = dimension.height - this.myStartMargin - this.myEndMargin;
        int numMajorMarkers = (int)Math.floor((currentMaxValueRelative - firstMarkerValue) / (double)majorInterval) + 1;
        this.myMarkerLabelDensity = (float)drawableHeight / ((float)numMajorMarkers * (float)(this.mDefaultFontMetrics.getMaxAscent() + this.mDefaultFontMetrics.getMaxDescent()));
        for (int i2 = 0; i2 < numMarkers; ++i2) {
            float markerOffset;
            double markerValue = firstMarkerValue + (double)((float)i2 * minorInterval);
            if (!this.myModel.getMarkerRange().contains(markerValue) || (markerOffset = firstMarkerOffset + (float)i2 * minorScale) < 0.0f && i2 > 0 || markerOffset > 1.0f) continue;
            if (i2 % numMinorPerMajor == 0) {
                this.myMajorMarkerPositions.add(markerOffset);
                this.myMarkerLabels.add(formatter.getFormattedString(labelRange, markerValue, !this.myOnlyShowUnitAtMax));
                continue;
            }
            this.myMinorMarkerPositions.add(markerOffset);
        }
        if (this.myShowMin && this.myModel.getMarkerRange().contains(currentMinValueRelative)) {
            this.myMinLabel = formatter.getFormattedString(labelRange, currentMinValueRelative, !this.myOnlyShowUnitAtMax);
        }
        if (this.myShowMax && this.myModel.getMarkerRange().contains(currentMaxValueRelative)) {
            this.myMaxLabel = formatter.getFormattedString(labelRange, currentMaxValueRelative, true);
        }
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myCalculateMarkers) {
            this.calculateMarkers(dim);
            this.myCalculateMarkers = false;
        }
        Point startPoint = new Point();
        Point endPoint = new Point();
        Point labelPoint = new Point();
        switch (this.myOrientation) {
            case LEFT: {
                startPoint.x = endPoint.x = dim.width - 1;
                startPoint.y = dim.height - this.myStartMargin - 1;
                endPoint.y = this.myEndMargin;
                this.myAxisLength = startPoint.y - endPoint.y;
                labelPoint.x = 0;
                labelPoint.y = endPoint.y;
                break;
            }
            case BOTTOM: {
                startPoint.x = this.myStartMargin;
                endPoint.x = dim.width - this.myEndMargin - 1;
                endPoint.y = 0;
                startPoint.y = 0;
                this.myAxisLength = endPoint.x - startPoint.x;
                labelPoint.x = startPoint.x;
                labelPoint.y = this.getHeight() - (this.mDefaultFontMetrics.getMaxAscent() + this.mDefaultFontMetrics.getMaxDescent());
                break;
            }
            case RIGHT: {
                endPoint.x = 0;
                startPoint.x = 0;
                startPoint.y = dim.height - this.myStartMargin - 1;
                endPoint.y = this.myEndMargin;
                this.myAxisLength = startPoint.y - endPoint.y;
                labelPoint.x = this.getWidth() - this.mDefaultFontMetrics.getMaxAdvance();
                labelPoint.y = endPoint.y;
                break;
            }
            case TOP: {
                startPoint.x = this.myStartMargin;
                endPoint.x = dim.width - this.myEndMargin - 1;
                startPoint.y = endPoint.y = dim.height - 1;
                this.myAxisLength = endPoint.x - startPoint.x;
                labelPoint.x = 0;
                labelPoint.y = 0;
            }
        }
        if (this.myAxisLength > 0) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setStroke(DEFAULT_AXIS_STROKE);
            if (this.myShowAxisLine) {
                g.setColor(this.myMarkerColor);
                g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
            }
            this.drawMarkers(g, startPoint);
            if (this.myLabel != null) {
                AffineTransform initialTransform = g.getTransform();
                g.translate(labelPoint.x, labelPoint.y);
                this.myLabel.paint(g);
                g.setTransform(initialTransform);
            }
        }
    }

    private void drawMarkers(Graphics2D g2d, Point origin) {
        float scaledPosition;
        int i2;
        g2d.setFont(this.getFont());
        if (this.myShowLabels) {
            if (this.myShowMin && this.myMinLabel != null) {
                this.drawMarkerLabel(g2d, 0.0f, origin, this.myMinLabel, true);
            }
            if (this.myShowMax && this.myMaxLabel != null && this.myMajorMarkerPositions.size() > 1) {
                this.drawMarkerLabel(g2d, this.myAxisLength, origin, this.myMaxLabel, true);
            }
        }
        boolean skipRendering = (this.myOrientation == AxisOrientation.LEFT || this.myOrientation == AxisOrientation.RIGHT) && this.myMarkerLabelDensity < 1.1f;
        Line2D.Float line = new Line2D.Float();
        if (!skipRendering) {
            for (i2 = 0; i2 < this.myMinorMarkerPositions.size(); ++i2) {
                scaledPosition = this.myMinorMarkerPositions.getFloat(i2) * (float)this.myAxisLength;
                this.drawMarkerLine(g2d, line, scaledPosition, origin, this.myMinorMarkerLength);
            }
        }
        for (i2 = 0; i2 < this.myMajorMarkerPositions.size(); ++i2) {
            if (i2 > 0 && i2 < this.myMajorMarkerPositions.size() - 1 && skipRendering) continue;
            scaledPosition = this.myMajorMarkerPositions.getFloat(i2) * (float)this.myAxisLength;
            this.drawMarkerLine(g2d, line, scaledPosition, origin, this.myMajorMarkerLength);
            if (!this.myShowLabels) continue;
            boolean reserveMinMaxBufferZone = this.myShowMin || this.myShowMax || this.myHideTickAtMin && scaledPosition == 0.0f;
            this.drawMarkerLabel(g2d, scaledPosition, origin, this.myMarkerLabels.get(i2), !reserveMinMaxBufferZone);
        }
    }

    private void drawMarkerLine(Graphics2D g2d, Line2D.Float line, float markerOffset, Point origin, int markerLength) {
        if (this.myHideTickAtMin && markerOffset == 0.0f) {
            return;
        }
        float markerStartX = 0.0f;
        float markerStartY = 0.0f;
        float markerEndX = 0.0f;
        float markerEndY = 0.0f;
        switch (this.myOrientation) {
            case LEFT: {
                markerStartX = origin.x - markerLength;
                markerStartY = markerEndY = (float)origin.y - markerOffset;
                markerEndX = origin.x;
                break;
            }
            case RIGHT: {
                markerStartX = 0.0f;
                markerStartY = markerEndY = (float)origin.y - markerOffset;
                markerEndX = markerLength;
                break;
            }
            case TOP: {
                markerStartX = markerEndX = (float)origin.x + markerOffset;
                markerStartY = origin.y - markerLength;
                markerEndY = origin.y;
                break;
            }
            case BOTTOM: {
                markerStartX = markerEndX = (float)origin.x + markerOffset;
                markerStartY = 0.0f;
                markerEndY = markerLength;
            }
        }
        line.setLine(markerStartX, markerStartY, markerEndX, markerEndY);
        g2d.setColor(this.myMarkerColor);
        g2d.draw(line);
    }

    private void drawMarkerLabel(Graphics2D g2d, float markerOffset, Point origin, String value, boolean alwaysRender) {
        float reserved;
        float labelY;
        float labelX;
        int stringAscent = this.mDefaultFontMetrics.getAscent();
        int stringLength = this.mDefaultFontMetrics.stringWidth(value);
        switch (this.myOrientation) {
            case LEFT: {
                labelX = origin.x - (this.myMajorMarkerLength + stringLength + 5);
                labelY = (float)origin.y - markerOffset + (float)stringAscent * 0.5f;
                reserved = stringAscent;
                break;
            }
            case RIGHT: {
                labelX = this.myMajorMarkerLength + 5;
                labelY = (float)origin.y - markerOffset + (float)stringAscent * 0.5f;
                reserved = stringAscent;
                break;
            }
            case TOP: {
                labelX = (float)origin.x + markerOffset + 5.0f;
                labelY = origin.y - this.myMinorMarkerLength;
                reserved = stringLength;
                break;
            }
            case BOTTOM: {
                labelX = (float)origin.x + markerOffset + 5.0f;
                labelY = this.myMinorMarkerLength + stringAscent;
                reserved = stringLength;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected orientation: " + this.myOrientation));
            }
        }
        if (alwaysRender || markerOffset - reserved > 0.0f && markerOffset + reserved < (float)this.myAxisLength) {
            g2d.setColor(this.getForeground());
            g2d.drawString(value, labelX, labelY);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = Math.max(this.myMajorMarkerLength, this.myMinorMarkerLength) + 5 + 50;
        int height = 1;
        return this.myOrientation == AxisOrientation.LEFT || this.myOrientation == AxisOrientation.RIGHT ? new Dimension(width, height) : new Dimension(height, width);
    }

    public AxisComponentModel getModel() {
        return this.myModel;
    }

    public void setShowAxisLine(boolean showAxisLine) {
        this.myShowAxisLine = showAxisLine;
    }

    public void setShowMin(boolean showMin) {
        this.myShowMin = showMin;
    }

    public void setShowMax(boolean showMax) {
        this.myShowMax = showMax;
    }

    public void setOnlyShowUnitAtMax(boolean onlyShowUnitAtMax) {
        this.myOnlyShowUnitAtMax = onlyShowUnitAtMax;
    }

    public void setHideTickAtMin(boolean hideTickAtMin) {
        this.myHideTickAtMin = hideTickAtMin;
    }

    public void setMarkerLengths(int majorMarker, int minorMarker) {
        this.myMajorMarkerLength = majorMarker;
        this.myMinorMarkerLength = minorMarker;
    }

    public void setMargins(int startMargin, int endMargin) {
        this.myStartMargin = startMargin;
        this.myEndMargin = endMargin;
    }

    public void setMarkerColor(@NotNull Color markerColor) {
        this.myMarkerColor = markerColor;
    }

    public void setShowLabels(boolean show2) {
        this.myShowLabels = show2;
    }

    @VisibleForTesting
    String getMinLabel() {
        return this.myMinLabel;
    }

    @VisibleForTesting
    String getMaxLabel() {
        return this.myMaxLabel;
    }

    public static enum AxisOrientation {
        LEFT,
        BOTTOM,
        RIGHT,
        TOP;

    }
}

