/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.LifecycleAction;
import com.android.tools.adtui.model.event.LifecycleEvent;
import com.android.tools.adtui.model.event.LifecycleEventModel;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public class ActivityComponent
extends AnimatedComponent {
    public static final int EVENT_LINE_WIDTH_PX = 4;
    public static final int EVENT_LINE_GAP_WIDTH_PX = 1;
    private static final Color DISABLED_ACTION = new JBColor(14409698, 6184800);
    private static final Color ENABLED_ACTION = new JBColor(6609078, 1224865);
    private static final Color EVENT_LINE = new JBColor(9014158, 0x999A9A);
    private static final int SEGMENT_SPACING = 5;
    private static final float DEFAULT_LINE_THICKNESS = 0.3f;
    private static final float FONT_PADDING = 10.0f;
    @NotNull
    private final LifecycleEventModel myEventModel;
    private List<ActivityRenderData> myActivities = new ArrayList<ActivityRenderData>();
    private List<Double> myFragmentPositions = new ArrayList<Double>();
    private boolean myRender;

    public ActivityComponent(@NotNull LifecycleEventModel lifecycleEventModel) {
        this.myEventModel = lifecycleEventModel;
        this.myEventModel.addDependency(this.myAspectObserver).onChange(EventModel.Aspect.EVENT, this::modelChanged);
        this.myRender = true;
    }

    private void modelChanged() {
        this.myRender = true;
        this.opaqueRepaint();
    }

    private void renderActivity() {
        LifecycleAction data;
        double viewMin = this.myEventModel.getActivitySeries().getXRange().getMin();
        double viewMax = this.myEventModel.getActivitySeries().getXRange().getMax();
        this.myActivities.clear();
        for (SeriesData<EventAction<LifecycleEvent>> seriesData : this.myEventModel.getActivitySeries().getSeries()) {
            data = (LifecycleAction)seriesData.value;
            double endTime = data.getEndUs() == 0L ? viewMax : (double)data.getEndUs();
            double normalizedEndPosition = (endTime - viewMin) / (viewMax - viewMin);
            double dataClampedStartUs = Math.max((double)data.getStartUs(), this.myEventModel.getActivitySeries().getIntersection().getMin());
            double normalizedStartPosition = (dataClampedStartUs - viewMin) / (viewMax - viewMin);
            if (normalizedStartPosition < 0.0) {
                normalizedStartPosition = 0.0;
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(normalizedStartPosition, 0.7f, normalizedEndPosition - normalizedStartPosition, 0.3f);
            this.myActivities.add(new ActivityRenderData(data, rect));
        }
        this.myActivities.sort((erd1, erd2) -> {
            if (erd1.getAction().getEndUs() == 0L && erd2.getAction().getEndUs() != 0L) {
                return -1;
            }
            if (erd1.getAction().getEndUs() != 0L && erd2.getAction().getEndUs() == 0L) {
                return 1;
            }
            if (erd1.getAction().getEndUs() != 0L && erd2.getAction().getEndUs() != 0L) {
                return erd1.getAction().getEndUs() - erd2.getAction().getEndUs() >= 0L ? 1 : -1;
            }
            return erd1.getAction().getStartUs() - erd2.getAction().getStartUs() >= 0L ? 1 : -1;
        });
        this.myFragmentPositions.clear();
        for (SeriesData<EventAction<LifecycleEvent>> seriesData : this.myEventModel.getFragmentSeries().getSeries()) {
            data = (LifecycleAction)seriesData.value;
            if ((double)data.getEndUs() >= viewMin && (double)data.getEndUs() < viewMax) {
                double dataClampedEndUs = Math.max((double)data.getEndUs(), viewMin);
                this.myFragmentPositions.add((dataClampedEndUs - viewMin) / (viewMax - viewMin));
            }
            if (!((double)data.getStartUs() >= viewMin) || !((double)data.getStartUs() < viewMax)) continue;
            double dataClampedStartUs = Math.max((double)data.getStartUs(), viewMin);
            this.myFragmentPositions.add((dataClampedStartUs - viewMin) / (viewMax - viewMin));
        }
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.myRender) {
            this.renderActivity();
            this.myRender = false;
        }
        this.drawActivity(g2d, dim);
    }

    private void drawActivity(Graphics2D g2d, Dimension dim) {
        int scaleFactor = dim.width;
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, dim.height - 5);
        double viewMin = this.myEventModel.getActivitySeries().getXRange().getMin();
        double viewMax = this.myEventModel.getActivitySeries().getXRange().getMax();
        FontMetrics metrics = g2d.getFontMetrics();
        Object previousHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        ListIterator<ActivityRenderData> itor = this.myActivities.listIterator();
        while (itor.hasNext()) {
            ActivityRenderData renderData = itor.next();
            EventAction<LifecycleEvent> event = renderData.getAction();
            g2d.setColor(event.getEndUs() == 0L ? ENABLED_ACTION : DISABLED_ACTION);
            Shape shape = scale.createTransformedShape(renderData.getPath());
            g2d.fill(shape);
            String text = "";
            if (event.getType() != LifecycleEvent.NONE) {
                text = ((LifecycleAction)event).getName();
            }
            double dataClampedStartUs = Math.max((double)event.getStartUs(), this.myEventModel.getActivitySeries().getIntersection().getMin());
            double normalizedStartPosition = (dataClampedStartUs - viewMin) / (viewMax - viewMin);
            double lifetime = event.getEndUs();
            if (event.getEndUs() == 0L) {
                lifetime = viewMax;
            }
            double normalizedEndPosition = (lifetime - viewMin) / (viewMax - viewMin);
            float startPosition = (float)normalizedStartPosition * (float)scaleFactor;
            float endPosition = (float)normalizedEndPosition * (float)scaleFactor;
            if (startPosition <= 10.0f) {
                startPosition = 10.0f;
            }
            if ((text = AdtUiUtils.shrinkToFit(text, metrics, endPosition - startPosition)).isEmpty()) continue;
            g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
            g2d.drawString(text, startPosition, (float)metrics.getAscent());
        }
        g2d.setColor(g2d.getBackground());
        for (Double normalizedPosition : this.myFragmentPositions) {
            g2d.fill(scale.createTransformedShape(new Rectangle2D.Double(normalizedPosition - 3.0 / dim.getWidth(), 0.7f, 6.0 / dim.getWidth(), 0.3f)));
        }
        g2d.setColor(EVENT_LINE);
        for (Double normalizedPosition : this.myFragmentPositions) {
            g2d.fill(scale.createTransformedShape(new Rectangle2D.Double(normalizedPosition - 2.0 / dim.getWidth(), 0.7f, 4.0 / dim.getWidth(), 0.3f)));
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, previousHint);
    }

    private static class ActivityRenderData {
        private final EventAction<LifecycleEvent> mAction;
        private final Rectangle2D mPath;

        public EventAction<LifecycleEvent> getAction() {
            return this.mAction;
        }

        public Rectangle2D getPath() {
            return this.mPath;
        }

        public ActivityRenderData(EventAction<LifecycleEvent> action, Rectangle2D path) {
            this.mAction = action;
            this.mPath = path;
        }
    }
}

