/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryFiles;

final class HgRepositoryUpdater
implements Disposable,
BulkFileListener {
    private final Project myProject;
    @NotNull
    private final HgRepositoryFiles myRepositoryFiles;
    @Nullable
    private final MessageBusConnection myMessageBusConnection;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @Nullable
    private final VirtualFile myBranchHeadsDir;
    private static final int TIME_SPAN = 300;
    @Nullable
    private VirtualFile myMqDir;
    @Nullable
    private final LocalFileSystem.WatchRequest myWatchRequest;
    @NotNull
    private final MergingUpdateQueue myUpdateConfigQueue;
    private final HgRepository myRepository;
    private final VcsDirtyScopeManager myDirtyScopeManager;

    HgRepositoryUpdater(@NotNull HgRepository repository) {
        this.myRepository = repository;
        VirtualFile hgDir = this.myRepository.getHgDir();
        this.myWatchRequest = LocalFileSystem.getInstance().addRootToWatch(hgDir.getPath(), true);
        this.myRepositoryFiles = HgRepositoryFiles.getInstance(hgDir);
        DvcsUtil.visitVcsDirVfs((VirtualFile)hgDir, HgRepositoryFiles.getSubDirRelativePaths());
        this.myBranchHeadsDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getBranchHeadsDirPath());
        this.myMqDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getMQDirPath());
        this.myProject = repository.getProject();
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myUpdateQueue = new MergingUpdateQueue("HgRepositoryUpdate", 300, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myUpdateConfigQueue = new MergingUpdateQueue("HgConfigUpdate", 300, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        if (!this.myProject.isDisposed()) {
            this.myMessageBusConnection = this.myProject.getMessageBus().connect((Disposable)this);
            this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        } else {
            this.myMessageBusConnection = null;
        }
    }

    public void dispose() {
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(this.myWatchRequest);
        }
        this.myUpdateQueue.cancelAllUpdates();
        this.myUpdateConfigQueue.cancelAllUpdates();
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
        }
    }

    public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        boolean branchHeadsChanged = false;
        boolean branchFileChanged = false;
        boolean dirstateFileChanged = false;
        boolean mergeFileChanged = false;
        boolean rebaseFileChanged = false;
        boolean bookmarksFileChanged = false;
        boolean tagsFileChanged = false;
        boolean localTagsFileChanged = false;
        boolean currentBookmarkFileChanged = false;
        boolean mqChanged = false;
        boolean hgIgnoreChanged = false;
        boolean configHgrcChanged = false;
        for (VFileEvent vFileEvent : events) {
            String filePath = vFileEvent.getPath();
            if (filePath == null) continue;
            if (this.myRepositoryFiles.isbranchHeadsFile(filePath)) {
                branchHeadsChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBranchFile(filePath)) {
                branchFileChanged = true;
                DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myBranchHeadsDir);
                continue;
            }
            if (this.myRepositoryFiles.isDirstateFile(filePath)) {
                dirstateFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isMergeFile(filePath)) {
                mergeFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isRebaseFile(filePath)) {
                rebaseFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBookmarksFile(filePath)) {
                bookmarksFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isTagsFile(filePath)) {
                tagsFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isLocalTagsFile(filePath)) {
                localTagsFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isCurrentBookmarksFile(filePath)) {
                currentBookmarkFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isMqFile(filePath)) {
                mqChanged = true;
                if (this.myMqDir == null) {
                    this.myMqDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getMQDirPath());
                }
                DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myMqDir);
                continue;
            }
            if (this.myRepositoryFiles.isConfigHgrcFile(filePath)) {
                configHgrcChanged = true;
                continue;
            }
            if (!this.myRepositoryFiles.isHgIgnore(filePath)) continue;
            hgIgnoreChanged = true;
        }
        if (branchHeadsChanged || branchFileChanged || dirstateFileChanged || mergeFileChanged || rebaseFileChanged || bookmarksFileChanged || currentBookmarkFileChanged || tagsFileChanged || localTagsFileChanged || mqChanged) {
            this.myUpdateQueue.queue((Update)new MyUpdater("hgrepositoryUpdate"));
        }
        if (configHgrcChanged) {
            this.myUpdateConfigQueue.queue((Update)new MyUpdater("hgconfigUpdate"){

                @Override
                public void run() {
                    HgRepositoryUpdater.this.myRepository.updateConfig();
                }
            });
        }
        if (dirstateFileChanged || hgIgnoreChanged) {
            this.myRepository.getIgnoredFilesHolder().startRescan();
            VirtualFile root = this.myRepository.getRoot();
            this.myDirtyScopeManager.dirDirtyRecursively(root);
            if (dirstateFileChanged) {
                ((HgUpdater)BackgroundTaskUtil.syncPublisher((Project)this.myProject, HgVcs.REMOTE_TOPIC)).update(this.myProject, root);
            }
        }
    }

    private class MyUpdater
    extends Update {
        MyUpdater(String name) {
            super((Object)name);
        }

        public boolean canEat(Update update) {
            return true;
        }

        public void run() {
            HgRepositoryUpdater.this.myRepository.update();
        }
    }
}

