/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgRevertCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRollbackEnvironment
implements RollbackEnvironment {
    private final Project project;

    public HgRollbackEnvironment(Project project) {
        this.project = project;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getRollbackOperationName() {
        return HgBundle.message("hg4idea.revert", new Object[0]);
    }

    public void rollbackChanges(List<? extends Change> changes, List<VcsException> vcsExceptions, @NotNull RollbackProgressListener listener) {
        if (changes == null || changes.isEmpty()) {
            return;
        }
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        LinkedList<FilePath> filePaths = new LinkedList<FilePath>();
        for (Change change : changes) {
            ContentRevision contentRevision = Change.Type.DELETED == change.getType() ? change.getBeforeRevision() : change.getAfterRevision();
            if (contentRevision == null) continue;
            filePaths.add(contentRevision.getFile());
            if (Change.Type.MOVED != change.getType()) continue;
            toDelete.add(contentRevision.getFile());
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.project, (String)this.getRollbackOperationName());){
            this.revert(filePaths);
            for (FilePath file : toDelete) {
                listener.accept(file);
                try {
                    File ioFile = file.getIOFile();
                    if (!ioFile.exists() || ioFile.delete()) continue;
                    vcsExceptions.add(new VcsException(HgBundle.message("error.cannot.delete.file", file.getPresentableUrl())));
                }
                catch (Exception e) {
                    vcsExceptions.add(new VcsException(HgBundle.message("error.cannot.delete.file", file.getPresentableUrl()), (Throwable)e));
                }
            }
        }
    }

    public void rollbackMissingFileDeletion(List<? extends FilePath> files, List<? super VcsException> exceptions, RollbackProgressListener listener) {
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.project, (String)this.getRollbackOperationName());){
            this.revert(files);
        }
    }

    public void rollbackModifiedWithoutCheckout(List<? extends VirtualFile> files, List<? super VcsException> exceptions, RollbackProgressListener listener) {
    }

    public List<VcsException> rollbackMissingFileDeletion(List<? extends FilePath> files) {
        if (files == null || files.isEmpty()) {
            return null;
        }
        this.revert(files);
        return null;
    }

    public void rollbackIfUnchanged(VirtualFile file) {
    }

    private void revert(@NotNull List<? extends FilePath> filePaths) {
        block0: for (Map.Entry<VirtualFile, Collection<FilePath>> entry : HgUtil.groupFilePathsByHgRoots(this.project, filePaths).entrySet()) {
            VirtualFile repo = entry.getKey();
            Collection<FilePath> files = entry.getValue();
            HgRevisionNumber revisionNumber = new HgWorkingCopyRevisionsCommand(this.project).firstParent(repo);
            for (List chunk : VcsFileUtil.chunkPaths((VirtualFile)repo, files)) {
                HgCommandResult revertResult = new HgRevertCommand(this.project).execute(repo, chunk, revisionNumber, false);
                if (HgErrorUtil.hasUncommittedChangesConflict(revertResult)) {
                    String message = XmlStringUtil.wrapInHtml((CharSequence)HgBundle.message("hg4idea.revert.failed.msg", repo.getPresentableName()));
                    int exitCode = HgUpdateCommand.showDiscardChangesConfirmation(this.project, message);
                    if (exitCode != 0) continue block0;
                    HgUpdateCommand updateCommand = new HgUpdateCommand(this.project, repo);
                    updateCommand.setClean(true);
                    updateCommand.setRevision(".");
                    updateCommand.execute();
                    continue block0;
                }
                new HgResolveCommand(this.project).markResolved(repo, files);
            }
        }
    }
}

