/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.provider.HgChangeProvider;
import org.zmlx.hg4idea.provider.HgCommittedChangeList;
import org.zmlx.hg4idea.provider.HgRepositoryLocation;
import org.zmlx.hg4idea.ui.HgVersionFilterComponent;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCommittedChangesProvider
implements CommittedChangesProvider<CommittedChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance(HgCommittedChangesProvider.class);
    private final Project project;
    private final HgVcs myVcs;
    private static final Comparator<HgCommittedChangeList> BRANCH_COLUMN_COMPARATOR = (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getBranch()), (Comparable)((Object)o2.getBranch()));
    private static final ChangeListColumn<HgCommittedChangeList> BRANCH_COLUMN = new ChangeListColumn<HgCommittedChangeList>(){

        public String getTitle() {
            return HgBundle.message("hg4idea.changelist.column.branch", new Object[0]);
        }

        public Object getValue(HgCommittedChangeList changeList) {
            String branch = changeList.getBranch();
            return branch.isEmpty() ? "default" : branch;
        }

        @NotNull
        public Comparator<HgCommittedChangeList> getComparator() {
            return BRANCH_COLUMN_COMPARATOR;
        }
    };

    public HgCommittedChangesProvider(Project project, HgVcs vcs) {
        this.project = project;
        this.myVcs = vcs;
    }

    @NotNull
    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new HgVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public RepositoryLocation getLocationFor(@NotNull FilePath filePath) {
        VirtualFile repo = VcsUtil.getVcsRootFor((Project)this.project, (FilePath)filePath);
        if (repo == null) {
            return null;
        }
        return new HgRepositoryLocation(repo.getUrl(), repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(ChangeBrowserSettings changeBrowserSettings, @NotNull RepositoryLocation repositoryLocation, int maxCount, @NotNull AsynchConsumer<? super CommittedChangeList> consumer) {
        try {
            List<CommittedChangeList> results = this.getCommittedChanges(changeBrowserSettings, repositoryLocation, maxCount);
            for (CommittedChangeList result : results) {
                consumer.consume((Object)result);
            }
        }
        finally {
            consumer.finished();
        }
    }

    @NotNull
    public List<CommittedChangeList> getCommittedChanges(ChangeBrowserSettings changeBrowserSettings, @NotNull RepositoryLocation repositoryLocation, int maxCount) {
        HgLogArgsBuilder argsBuilder;
        VirtualFile root = ((HgRepositoryLocation)repositoryLocation).getRoot();
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        LinkedList<CommittedChangeList> result = new LinkedList<CommittedChangeList>();
        HgLogCommand hgLogCommand = new HgLogCommand(this.project);
        hgLogCommand.setLogFile(false);
        List<String> args = null;
        if (changeBrowserSettings != null && (args = (argsBuilder = new HgLogArgsBuilder(changeBrowserSettings)).getLogArgs()).isEmpty()) {
            maxCount = maxCount == 0 ? VcsConfiguration.getInstance((Project)this.project).MAXIMUM_HISTORY_ROWS : maxCount;
        }
        List<HgFileRevision> localRevisions = hgLogCommand.execute(hgFile, maxCount == 0 ? -1 : maxCount, true, args);
        Collections.reverse(localRevisions);
        for (HgFileRevision revision : localRevisions) {
            HgRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
            List<? extends HgRevisionNumber> parents = vcsRevisionNumber.getParents();
            HgRevisionNumber firstParent = parents.isEmpty() ? null : parents.get(0);
            ArrayList<Change> changes = new ArrayList<Change>();
            for (String string : revision.getModifiedFiles()) {
                changes.add(this.createChange(root, string, firstParent, string, vcsRevisionNumber, FileStatus.MODIFIED));
            }
            for (String string : revision.getAddedFiles()) {
                changes.add(this.createChange(root, null, null, string, vcsRevisionNumber, FileStatus.ADDED));
            }
            for (String string : revision.getDeletedFiles()) {
                changes.add(this.createChange(root, string, firstParent, null, vcsRevisionNumber, FileStatus.DELETED));
            }
            for (Map.Entry entry : revision.getMovedFiles().entrySet()) {
                changes.add(this.createChange(root, (String)entry.getKey(), firstParent, (String)entry.getValue(), vcsRevisionNumber, HgChangeProvider.RENAMED));
            }
            result.add((CommittedChangeList)new HgCommittedChangeList(this.myVcs, vcsRevisionNumber, revision.getBranchName(), revision.getCommitMessage(), revision.getAuthor(), revision.getRevisionDate(), changes));
        }
        Collections.reverse(result);
        return result;
    }

    private Change createChange(VirtualFile root, @Nullable String fileBefore, @Nullable HgRevisionNumber revisionBefore, @Nullable String fileAfter, HgRevisionNumber revisionAfter, FileStatus aStatus) {
        HgContentRevision beforeRevision = fileBefore == null ? null : HgContentRevision.create(this.project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        HgContentRevision afterRevision = fileAfter == null ? null : HgContentRevision.create(this.project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        return new Change(beforeRevision, afterRevision, aStatus);
    }

    public ChangeListColumn @NotNull [] getColumns() {
        return new ChangeListColumn[]{BRANCH_COLUMN, ChangeListColumn.NUMBER, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION, ChangeListColumn.NAME};
    }

    @NotNull
    public VcsCommittedViewAuxiliary createActions(@NotNull DecoratorManager manager, @Nullable RepositoryLocation location) {
        DumbAwareAction copyHashAction = new DumbAwareAction(HgBundle.messagePointer("action.DumbAware.HgCommittedChangesProvider.text.copy.hash", new Object[0]), HgBundle.messagePointer("action.DumbAware.HgCommittedChangesProvider.description.copy.hash.to.clipboard", new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
                if (changeLists != null && changeLists[0] instanceof HgCommittedChangeList) {
                    HgRevisionNumber revisionNumber = ((HgCommittedChangeList)changeLists[0]).getRevisionNumber();
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(revisionNumber.getChangeset()));
                }
            }
        };
        return new VcsCommittedViewAuxiliary(Collections.singletonList(copyHashAction), () -> {}, Collections.singletonList(copyHashAction));
    }

    public int getUnlimitedCountValue() {
        return -1;
    }

    @Nullable
    public Pair<CommittedChangeList, FilePath> getOneList(VirtualFile file, @NotNull VcsRevisionNumber number) {
        ChangeBrowserSettings settings = this.createDefaultSettings();
        settings.USE_CHANGE_AFTER_FILTER = true;
        settings.USE_CHANGE_BEFORE_FILTER = true;
        settings.CHANGE_AFTER = number.asString();
        settings.CHANGE_BEFORE = number.asString();
        VirtualFile localVirtualFile = HgUtil.convertToLocalVirtualFile(file);
        if (localVirtualFile == null) {
            return null;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)localVirtualFile);
        CommittedChangeList list = this.getCommittedChangesForRevision(this.getLocationFor(filePath), number.asString());
        if (list != null) {
            return new Pair((Object)list, (Object)filePath);
        }
        return null;
    }

    public boolean supportsIncomingChanges() {
        return false;
    }

    @Nullable
    public CommittedChangeList getCommittedChangesForRevision(@Nullable RepositoryLocation repositoryLocation, String revision) {
        if (repositoryLocation == null) {
            return null;
        }
        VirtualFile root = ((HgRepositoryLocation)repositoryLocation).getRoot();
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        HgLogCommand hgLogCommand = new HgLogCommand(this.project);
        hgLogCommand.setLogFile(false);
        hgLogCommand.setFollowCopies(true);
        ArrayList<String> args = new ArrayList<String>();
        args.add("--rev");
        args.add(revision);
        List<HgFileRevision> revisions = hgLogCommand.execute(hgFile, 1, true, args);
        if (ContainerUtil.isEmpty(revisions)) {
            return null;
        }
        HgFileRevision localRevision = revisions.get(0);
        HgRevisionNumber vcsRevisionNumber = localRevision.getRevisionNumber();
        List<? extends HgRevisionNumber> parents = vcsRevisionNumber.getParents();
        HgRevisionNumber firstParent = parents.isEmpty() ? null : parents.get(0);
        ArrayList<Change> changes = new ArrayList<Change>();
        for (String string : localRevision.getModifiedFiles()) {
            changes.add(this.createChange(root, string, firstParent, string, vcsRevisionNumber, FileStatus.MODIFIED));
        }
        for (String string : localRevision.getAddedFiles()) {
            changes.add(this.createChange(root, null, null, string, vcsRevisionNumber, FileStatus.ADDED));
        }
        for (String string : localRevision.getDeletedFiles()) {
            changes.add(this.createChange(root, string, firstParent, null, vcsRevisionNumber, FileStatus.DELETED));
        }
        for (Map.Entry entry : localRevision.getMovedFiles().entrySet()) {
            changes.add(this.createChange(root, (String)entry.getKey(), firstParent, (String)entry.getValue(), vcsRevisionNumber, HgChangeProvider.RENAMED));
        }
        return new HgCommittedChangeList(this.myVcs, vcsRevisionNumber, localRevision.getBranchName(), localRevision.getCommitMessage(), localRevision.getAuthor(), localRevision.getRevisionDate(), changes);
    }

    private static class HgLogArgsBuilder {
        @NotNull
        private final ChangeBrowserSettings myBrowserSettings;

        HgLogArgsBuilder(@NotNull ChangeBrowserSettings browserSettings) {
            this.myBrowserSettings = browserSettings;
        }

        @NotNull
        List<String> getLogArgs() {
            StringBuilder args = new StringBuilder();
            Date afterDate = this.myBrowserSettings.getDateAfter();
            Date beforeDate = this.myBrowserSettings.getDateBefore();
            Long afterFilter = this.myBrowserSettings.getChangeAfterFilter();
            Long beforeFilter = this.myBrowserSettings.getChangeBeforeFilter();
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            if (afterFilter != null && beforeFilter != null) {
                args.append(afterFilter).append(":").append(beforeFilter);
            } else if (afterFilter != null) {
                args.append("tip:").append(afterFilter);
                if (afterFilter == 0L) {
                    LOG.debug("Get repository commits not from Log", new Throwable());
                }
            } else if (beforeFilter != null) {
                args.append("reverse(:").append(beforeFilter).append(")");
            }
            if (afterDate != null) {
                if (args.length() > 0) {
                    args.append(" and ");
                }
                args.append("date('>").append(dateFormatter.format(afterDate)).append("')");
            }
            if (beforeDate != null) {
                if (args.length() > 0) {
                    args.append(" and ");
                }
                args.append("date('<").append(dateFormatter.format(beforeDate)).append("')");
            }
            if (args.length() > 0) {
                ArrayList<String> logArgs = new ArrayList<String>();
                logArgs.add("-r");
                logArgs.add(args.toString());
                return logArgs;
            }
            return Collections.emptyList();
        }
    }
}

