/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.mq;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.log.HgBaseLogParser;

public class MqPatchDetails {
    @NotNull
    private final Map<MqPatchEnum, String> myPatchDetailsPresentationMap = new EnumMap<MqPatchEnum, String>(MqPatchEnum.class);
    @Nullable
    private final String myNodeId;
    @Nullable
    private final String myParent;
    @Nullable
    private final Date myDate;
    @Nullable
    private final VirtualFile myRoot;
    @Nullable
    private final String myBranch;
    @Nullable
    private final String myMessage;
    @Nullable
    private final String myUser;
    public static final MqPatchDetails EMPTY_PATCH_DETAILS = new MqPatchDetails(null, null, null, null, null, null, null);

    public MqPatchDetails(@Nullable String nodeId, @Nullable String parent, @Nullable Date date, @Nullable VirtualFile root, @Nullable String branch, @Nullable String message, @Nullable String user) {
        this.myNodeId = nodeId;
        this.myParent = parent;
        this.myDate = date;
        this.myRoot = root;
        this.myBranch = branch;
        this.myMessage = message != null ? message.trim() : null;
        this.myUser = user;
        this.createPresentationModel();
    }

    @Nullable
    public String getNodeId() {
        return this.myNodeId;
    }

    @Nullable
    public String getParent() {
        return this.myParent;
    }

    @Nullable
    public Date getDate() {
        return this.myDate;
    }

    @Nullable
    public String getBranch() {
        return this.myBranch;
    }

    @Nullable
    public String getMessage() {
        return this.myMessage;
    }

    @Nullable
    public String getUser() {
        return this.myUser;
    }

    private void createPresentationModel() {
        if (this.myDate != null) {
            this.myPatchDetailsPresentationMap.put(MqPatchEnum.Date, DateFormatUtil.formatDateTime((Date)this.myDate));
        }
        this.myPatchDetailsPresentationMap.put(MqPatchEnum.Author, this.myUser);
        this.myPatchDetailsPresentationMap.put(MqPatchEnum.Branch, this.myBranch);
        if (this.myMessage != null) {
            this.myPatchDetailsPresentationMap.put(MqPatchEnum.Subject, HgBaseLogParser.extractSubject(this.myMessage));
        }
    }

    @Nullable
    public String getPresentationDataFor(MqPatchEnum field) {
        return this.myPatchDetailsPresentationMap.get((Object)field);
    }

    public static enum MqPatchEnum {
        Name("column.mq.patch.name"),
        Subject("column.mq.patch.subject"),
        Author("column.mq.patch.author"),
        Branch("column.mq.patch.branch"),
        Date("column.mq.patch.date");

        private final String myId;

        private MqPatchEnum(String id) {
            this.myId = id;
        }

        @NlsContexts.ColumnName
        public String getColumnName() {
            return HgBundle.message(this.myId, new Object[0]);
        }
    }
}

