/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ArrayUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class HgCommandResult {
    public static final HgCommandResult CANCELLED = new HgCommandResult(new ProcessOutput(1));
    @NotNull
    private final ProcessOutput myProcessOutput;
    private final byte @NotNull [] myByteArrayOutput;

    public HgCommandResult(@NotNull ProcessOutput processOutput) {
        this(processOutput, ArrayUtilRt.EMPTY_BYTE_ARRAY);
    }

    public HgCommandResult(@NotNull ProcessOutput processOutput, byte @NotNull [] byteArrayOutput) {
        this.myProcessOutput = processOutput;
        this.myByteArrayOutput = byteArrayOutput;
    }

    public @NotNull List<@NlsSafe String> getOutputLines() {
        return this.myProcessOutput.getStdoutLines();
    }

    public @NotNull List<@NlsSafe String> getErrorLines() {
        return this.myProcessOutput.getStderrLines();
    }

    @NlsSafe
    @NotNull
    public String getRawOutput() {
        return this.myProcessOutput.getStdout();
    }

    @NlsSafe
    @NotNull
    public String getRawError() {
        return this.myProcessOutput.getStderr();
    }

    public byte @NotNull [] getBytesOutput() {
        return this.myByteArrayOutput;
    }

    public int getExitValue() {
        return this.myProcessOutput.getExitCode();
    }
}

