/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsImplUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgExecutableManager;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgLineProcessListener;
import org.zmlx.hg4idea.execution.ShellCommand;
import org.zmlx.hg4idea.execution.ShellCommandException;
import org.zmlx.hg4idea.util.HgEncodingUtil;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCommandExecutor {
    protected static final Logger LOG = Logger.getInstance((String)HgCommandExecutor.class.getName());
    private static final List<String> DEFAULT_OPTIONS = Arrays.asList("--config", "extensions.mq=", "--config", "ui.merge=internal:merge");
    protected final Project myProject;
    protected final HgVcs myVcs;
    protected final String myDestination;
    @NotNull
    private Charset myCharset;
    private boolean myIsSilent = false;
    private boolean myShowOutput = false;
    private boolean myIsBinary = false;
    private boolean myOutputAlwaysSuppressed = false;

    public HgCommandExecutor(Project project) {
        this(project, null);
    }

    public HgCommandExecutor(Project project, @Nullable String destination) {
        this.myProject = project;
        this.myVcs = HgVcs.getInstance(project);
        this.myDestination = destination;
        this.myCharset = HgEncodingUtil.getDefaultCharset(this.myProject);
    }

    public void setCharset(@Nullable Charset charset) {
        if (charset != null) {
            this.myCharset = charset;
        }
    }

    public void setSilent(boolean isSilent) {
        this.myIsSilent = isSilent;
    }

    public void setShowOutput(boolean showOutput) {
        this.myShowOutput = showOutput;
    }

    public void setBinary(boolean isBinary) {
        this.myIsBinary = isBinary;
    }

    public void setOutputAlwaysSuppressed(boolean outputAlwaysSuppressed) {
        this.myOutputAlwaysSuppressed = outputAlwaysSuppressed;
    }

    @Nullable
    public HgCommandResult executeInCurrentThread(@Nullable VirtualFile repo, @NotNull @NonNls String operation, @Nullable List<@NonNls String> arguments) {
        return this.executeInCurrentThread(repo, operation, arguments, false);
    }

    @Nullable
    public HgCommandResult executeInCurrentThread(@Nullable VirtualFile repo, @NotNull @NonNls String operation, @Nullable List<@NonNls String> arguments, boolean ignoreDefaultOptions) {
        ShellCommand.CommandResultCollector collector = new ShellCommand.CommandResultCollector(this.myIsBinary);
        boolean success = this.executeInCurrentThread(repo, operation, arguments, ignoreDefaultOptions, collector);
        return success ? collector.getResult() : null;
    }

    public boolean executeInCurrentThread(@Nullable VirtualFile repo, @NotNull @NonNls String operation, @Nullable List<@NonNls String> arguments, boolean ignoreDefaultOptions, @NotNull HgLineProcessListener listener) {
        boolean success = this.executeInCurrentThreadAndLog(repo, operation, arguments, ignoreDefaultOptions, listener);
        List errors = StringUtil.split((String)listener.getErrorOutput().toString(), (String)System.lineSeparator());
        if (success && HgErrorUtil.isUnknownEncodingError(errors)) {
            this.setCharset(StandardCharsets.UTF_8);
            return this.executeInCurrentThreadAndLog(repo, operation, arguments, ignoreDefaultOptions, listener);
        }
        return success;
    }

    private boolean executeInCurrentThreadAndLog(@Nullable VirtualFile repo, @NotNull @NonNls String operation, @Nullable List<@NonNls String> arguments, boolean ignoreDefaultOptions, @NotNull HgLineProcessListener listener) {
        if (this.myProject == null || this.myProject.isDisposed() || this.myVcs == null) {
            return false;
        }
        if (!this.myProject.isDefault() && !TrustedProjects.isTrusted((Project)this.myProject)) {
            throw new IllegalStateException("Shouldn't be possible to run a Hg command in the safe mode");
        }
        ShellCommand shellCommand = this.createShellCommandWithArgs(repo, operation, arguments, ignoreDefaultOptions);
        try {
            long startTime = System.currentTimeMillis();
            LOG.debug(String.format("hg %s started", operation));
            shellCommand.execute(this.myShowOutput, this.myIsBinary, listener);
            LOG.debug(String.format("hg %s finished. Took %s ms", operation, System.currentTimeMillis() - startTime));
            return true;
        }
        catch (ShellCommandException e) {
            this.processError(e);
            return false;
        }
    }

    private void processError(@NotNull ShellCommandException e) {
        if (this.myVcs.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
            this.showError(e);
            LOG.info(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private ShellCommand createShellCommandWithArgs(@Nullable VirtualFile repo, @NotNull @NonNls String operation, @Nullable List<@NonNls String> arguments, boolean ignoreDefaultOptions) {
        this.logCommand(operation, arguments);
        LinkedList<String> cmdLine = new LinkedList<String>();
        cmdLine.add(HgExecutableManager.getInstance().getHgExecutable(this.myProject));
        if (repo != null) {
            cmdLine.add("--repository");
            cmdLine.add(repo.getPath());
        }
        if (!ignoreDefaultOptions) {
            cmdLine.addAll(DEFAULT_OPTIONS);
        }
        cmdLine.add(operation);
        if (arguments != null && arguments.size() != 0) {
            cmdLine.addAll(arguments);
        }
        if (HgVcs.HGENCODING == null) {
            cmdLine.add("--encoding");
            cmdLine.add(HgEncodingUtil.getNameFor(this.myCharset));
        }
        String workingDir = repo != null ? repo.getPath() : null;
        return new ShellCommand(cmdLine, workingDir, this.myCharset);
    }

    protected void logCommand(@NotNull String operation, @Nullable List<String> arguments) {
        String cmdString;
        if (this.myProject.isDisposed()) {
            return;
        }
        String exeName = HgExecutableManager.getInstance().getHgExecutable(this.myProject);
        int lastSlashIndex = exeName.lastIndexOf(File.separator);
        exeName = exeName.substring(lastSlashIndex + 1);
        @NonNls String str = String.format("%s %s %s", exeName, operation, arguments == null ? "" : StringUtil.escapeStringCharacters((String)StringUtil.join(arguments, (String)" ")));
        String string = cmdString = this.myDestination != null ? HgUtil.removePasswordIfNeeded(str) : str;
        if (!this.myIsSilent) {
            LOG.info(cmdString);
            this.myVcs.showMessageInConsole(cmdString, ConsoleViewContentType.NORMAL_OUTPUT);
        } else {
            LOG.debug(cmdString);
        }
    }

    protected void showError(Exception e) {
        HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        String message = HgBundle.message("hg4idea.command.executor.error", HgExecutableManager.getInstance().getHgExecutable(this.myProject), e.getMessage());
        VcsImplUtil.showErrorMessage((Project)this.myProject, (String)message, (String)HgBundle.message("hg4idea.error", new Object[0]));
    }
}

