/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgWorkingCopyRevisionsCommand {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(HgWorkingCopyRevisionsCommand.class);

    public HgWorkingCopyRevisionsCommand(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<HgRevisionNumber> parents(@NotNull VirtualFile repo) {
        return this.getRevisions(repo, "parents", null, null, true);
    }

    @NotNull
    public Couple<HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable VirtualFile file) {
        return this.parents(repo, file, null);
    }

    @NotNull
    public Couple<HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable VirtualFile file, @Nullable HgRevisionNumber revision) {
        return this.parents(repo, VcsUtil.getFilePath((VirtualFile)file), revision);
    }

    @NotNull
    public Couple<HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable FilePath file) {
        return this.parents(repo, file, null);
    }

    @NotNull
    public Couple<HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable FilePath file, @Nullable HgRevisionNumber revision) {
        List<HgRevisionNumber> revisions = this.getRevisions(repo, "parents", file, revision, true);
        switch (revisions.size()) {
            case 1: {
                return Couple.of((Object)revisions.get(0), null);
            }
            case 2: {
                return Couple.of((Object)revisions.get(0), (Object)revisions.get(1));
            }
        }
        return Couple.of(null, null);
    }

    @Nullable
    public HgRevisionNumber firstParent(@NotNull VirtualFile repo) {
        List<HgRevisionNumber> parents = this.parents(repo);
        if (parents.isEmpty()) {
            return HgRevisionNumber.NULL_REVISION_NUMBER;
        }
        return parents.get(0);
    }

    @Nullable
    public HgRevisionNumber tip(@NotNull VirtualFile repo) {
        List<HgRevisionNumber> tips = this.getRevisions(repo, "tip", null, null, true);
        if (tips.size() > 1) {
            throw new IllegalStateException("There cannot be multiple tips");
        }
        if (!tips.isEmpty()) {
            return tips.get(0);
        }
        return HgRevisionNumber.NULL_REVISION_NUMBER;
    }

    @NotNull
    public Couple<HgRevisionNumber> identify(@NotNull VirtualFile repo) {
        List parts;
        HgCommandExecutor commandExecutor = new HgCommandExecutor(this.myProject);
        commandExecutor.setSilent(true);
        HgCommandResult result = commandExecutor.executeInCurrentThread(repo, "identify", Arrays.asList("--num", "--id"));
        if (result == null) {
            return Couple.of((Object)HgRevisionNumber.NULL_REVISION_NUMBER, null);
        }
        List<String> lines = result.getOutputLines();
        if (!lines.isEmpty() && (parts = StringUtil.split((String)lines.get(0), (String)" ")).size() >= 2) {
            String changesets = (String)parts.get(0);
            String revisions = (String)parts.get(1);
            if (changesets.indexOf(43) != changesets.lastIndexOf(43)) {
                List chsets = StringUtil.split((String)changesets, (String)"+");
                List revs = StringUtil.split((String)revisions, (String)"+");
                return Couple.of((Object)HgRevisionNumber.getInstance((String)revs.get(0) + "+", (String)chsets.get(0) + "+"), (Object)HgRevisionNumber.getInstance((String)revs.get(1) + "+", (String)chsets.get(1) + "+"));
            }
            return Couple.of((Object)HgRevisionNumber.getInstance(revisions, changesets), null);
        }
        return Couple.of((Object)HgRevisionNumber.NULL_REVISION_NUMBER, null);
    }

    @NotNull
    public List<HgRevisionNumber> getRevisions(@NotNull VirtualFile repo, @NotNull @NonNls String command, @Nullable FilePath file, @Nullable HgRevisionNumber revision, boolean silent) {
        LinkedList<String> args = new LinkedList<String>();
        args.add("--template");
        args.add(HgChangesetUtil.makeTemplate("{rev}", "{node}"));
        if (revision != null) {
            args.add("-r");
            args.add(revision.getChangeset());
        }
        if (file != null) {
            args.add(HgUtil.getOriginalFileName(file, ChangeListManager.getInstance((Project)this.myProject)).getPath());
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(silent);
        HgCommandResult result = executor.executeInCurrentThread(repo, command, args);
        if (result == null) {
            return new ArrayList<HgRevisionNumber>(0);
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : result.getRawOutput().split("\u0003")) {
            if (line.trim().isEmpty()) continue;
            lines.add(line);
        }
        if (lines.isEmpty()) {
            return new ArrayList<HgRevisionNumber>();
        }
        ArrayList<HgRevisionNumber> revisions = new ArrayList<HgRevisionNumber>(lines.size());
        for (String line : lines) {
            List parts = StringUtil.split((String)line, (String)"\u0017");
            if (parts.size() < 2) {
                LOG.error("getRevisions output parse error in line [" + line + "]\n All lines: \n" + lines);
                continue;
            }
            revisions.add(HgRevisionNumber.getInstance((String)parts.get(0), (String)parts.get(1)));
        }
        return revisions;
    }
}

