/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgPromptCommandExecutor;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgMergeCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final HgRepository repo;
    @Nullable
    private String revision;

    public HgMergeCommand(@NotNull Project project, @NotNull HgRepository repo) {
        this.project = project;
        this.repo = repo;
    }

    private void setRevision(@NotNull @NonNls String revision) {
        this.revision = revision;
    }

    @Nullable
    private HgCommandResult executeInCurrentThread() {
        HgPromptCommandExecutor commandExecutor = new HgPromptCommandExecutor(this.project);
        commandExecutor.setShowOutput(true);
        LinkedList<String> arguments = new LinkedList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.project, (String)HgBundle.message("activity.name.merge", new Object[0]));){
            HgCommandResult result = commandExecutor.executeInCurrentThread(this.repo.getRoot(), "merge", arguments);
            this.repo.update();
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
    }

    @Nullable
    public HgCommandResult mergeSynchronously() throws VcsException {
        HgCommandResult commandResult = HgErrorUtil.ensureSuccess(this.executeInCurrentThread());
        HgUtil.markDirectoryDirty(this.project, this.repo.getRoot());
        return commandResult;
    }

    public static void mergeWith(@NotNull HgRepository repository, @NotNull @NonNls String branchName, @NotNull UpdatedFiles updatedFiles) {
        HgMergeCommand.mergeWith(repository, branchName, updatedFiles, null);
    }

    public static void mergeWith(@NotNull HgRepository repository, @NotNull @NonNls String branchName, final @NotNull UpdatedFiles updatedFiles, final @Nullable Runnable onSuccessHandler) {
        final Project project = repository.getProject();
        final VirtualFile repositoryRoot = repository.getRoot();
        final HgMergeCommand hgMergeCommand = new HgMergeCommand(project, repository);
        hgMergeCommand.setRevision(branchName);
        new Task.Backgroundable(project, HgBundle.message("action.hg4idea.merge.progress", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    HgCommandResult result = hgMergeCommand.mergeSynchronously();
                    if (HgErrorUtil.isAncestorMergeError(result)) {
                        VcsNotifier.getInstance((Project)project).notifyMinorWarning("hg.merging.with.ancestor.skipped", HgBundle.message("action.hg4idea.merge.skipped.title", repositoryRoot.getPresentableName()), HgBundle.message("action.hg4idea.merge.skipped", new Object[0]));
                        return;
                    }
                    new HgConflictResolver(project, updatedFiles).resolve(repositoryRoot);
                    if (!HgConflictResolver.hasConflicts(project, repositoryRoot) && onSuccessHandler != null) {
                        onSuccessHandler.run();
                    }
                }
                catch (VcsException exception) {
                    if (exception.isWarning()) {
                        VcsNotifier.getInstance((Project)project).notifyWarning("hg.merge.warning", HgBundle.message("action.hg4idea.merge.warning", new Object[0]), exception.getMessage());
                    }
                    VcsNotifier.getInstance((Project)project).notifyError("hg.merge.exception", HgBundle.message("action.hg4idea.merge.exception", new Object[0]), exception.getMessage());
                }
            }
        }.queue();
    }
}

