/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgBookmarkCommand {
    public static void createBookmarkAsynchronously(final @NotNull List<? extends HgRepository> repositories, final @NotNull @NlsSafe String name, final boolean isActive) {
        final Project project = Objects.requireNonNull((HgRepository)ContainerUtil.getFirstItem(repositories)).getProject();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            VcsNotifier.getInstance((Project)project).notifyError("hg.bookmark.name.is.empty", HgBundle.message("hg4idea.hg.error", new Object[0]), HgBundle.message("hg4idea.bookmark.name.empty", new Object[0]));
            return;
        }
        new Task.Backgroundable(project, HgBundle.message("hg4idea.progress.bookmark", name)){

            public void run(@NotNull ProgressIndicator indicator) {
                for (HgRepository repository : repositories) {
                    HgBookmarkCommand.executeBookmarkCommandSynchronously(project, repository.getRoot(), name, isActive ? ContainerUtil.emptyList() : Collections.singletonList("--inactive"));
                }
            }
        }.queue();
    }

    public static void deleteBookmarkSynchronously(@NotNull Project project, @NotNull VirtualFile repo, @NotNull @NlsSafe String name) {
        HgBookmarkCommand.executeBookmarkCommandSynchronously(project, repo, name, Collections.singletonList("-d"));
    }

    private static void executeBookmarkCommandSynchronously(@NotNull Project project, @NotNull VirtualFile repositoryRoot, @NotNull @NlsSafe String name, @NotNull List<@NonNls String> args) {
        ArrayList<String> arguments = new ArrayList<String>(args);
        arguments.add(name);
        HgCommandResult result = new HgCommandExecutor(project).executeInCurrentThread(repositoryRoot, "bookmark", arguments);
        HgUtil.getRepositoryManager(project).updateRepository(repositoryRoot);
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(project).notifyError("hg.bookmark.error", result, HgBundle.message("hg4idea.hg.error", new Object[0]), HgBundle.message("hg4idea.bookmark.cmd.failed", repositoryRoot.getName(), name));
        }
    }
}

