/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgDisposable;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.branch.HgBranchType;
import org.zmlx.hg4idea.branch.HgCommonBranchActions;
import org.zmlx.hg4idea.command.HgBookmarkCommand;
import org.zmlx.hg4idea.command.HgBranchCreateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.commit.HgCloseBranchExecutor;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.ui.HgBookmarkDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchPopupActions {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgRepository myRepository;

    HgBranchPopupActions(@NotNull Project project, @NotNull HgRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, null, false);
    }

    ActionGroup createActions(@Nullable LightActionGroup toInsert, @Nullable HgRepository specificRepository, boolean firstLevelGroup) {
        LightActionGroup popupGroup = new LightActionGroup(false);
        popupGroup.addAction((AnAction)new HgNewBranchAction(this.myProject, Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgNewBookmarkAction(Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgCloseBranchAction(Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgShowUnnamedHeadsForCurrentBranchAction(this.myRepository));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator(specificRepository == null ? HgBundle.message("hg4idea.branch.bookmarks", new Object[0]) : HgBundle.message("hg4idea.branch.bookmarks.in.repo", DvcsUtil.getShortRepositoryName((Repository)specificRepository)));
        String currentBookmark = this.myRepository.getCurrentBookmark();
        List bookmarkActions = ((StreamEx)((StreamEx)StreamEx.of(HgUtil.getSortedNamesWithoutHashes(this.myRepository.getBookmarks())).filter(bm -> !bm.equals(currentBookmark))).map(bm -> new BookmarkActions(this.myProject, Collections.singletonList(this.myRepository), (String)bm)).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR)).toList();
        int topShownBookmarks = BranchActionUtil.getNumOfTopShownBranches((List)bookmarkActions);
        if (currentBookmark != null) {
            bookmarkActions.add(0, new CurrentActiveBookmark(this.myProject, Collections.singletonList(this.myRepository), currentBookmark));
            ++topShownBookmarks;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)bookmarkActions, (int)topShownBookmarks, (String)(firstLevelGroup ? "Hg.Branch.Popup.ShowAllBookmarks" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator(specificRepository == null ? HgBundle.message("hg4idea.branch.branches.separator", new Object[0]) : HgBundle.message("hg4idea.branch.branches.in.repo.separator", DvcsUtil.getShortRepositoryName((Repository)specificRepository)));
        List branchActions = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(this.myRepository.getOpenedBranches()).sorted(StringUtil::naturalCompare)).filter(b -> !b.equals(this.myRepository.getCurrentBranch()))).map(b -> new BranchActions(this.myProject, Collections.singletonList(this.myRepository), (String)b)).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR)).toList();
        branchActions.add(0, new CurrentBranch(this.myProject, Collections.singletonList(this.myRepository), this.myRepository.getCurrentBranch()));
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)branchActions, (int)(BranchActionUtil.getNumOfTopShownBranches((List)branchActions) + 1), (String)(firstLevelGroup ? "Hg.Branch.Popup.ShowAllBranches" : null), (boolean)firstLevelGroup);
        return popupGroup;
    }

    public static class CurrentActiveBookmark
    extends BookmarkActions
    implements PopupElementWithAdditionalInfo {
        public CurrentActiveBookmark(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            super(project, repositories, branchName);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new BookmarkActions.DeleteBookmarkAction(this.myProject, this.myRepositories, this.myBranchName)};
        }
    }

    static class BookmarkActions
    extends HgCommonBranchActions {
        BookmarkActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            super(project, repositories, branchName, HgBranchType.BOOKMARK);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return (AnAction[])ArrayUtil.append((Object[])super.getChildren(e), (Object)((Object)new DeleteBookmarkAction(this.myProject, this.myRepositories, this.myBranchName)));
        }

        private static class DeleteBookmarkAction
        extends HgBranchAbstractAction {
            DeleteBookmarkAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
                super(project, CommonBundle.messagePointer((String)"button.delete", (Object[])new Object[0]), repositories, branchName);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                BackgroundTaskUtil.executeOnPooledThread((Disposable)HgDisposable.getInstance(this.myProject), () -> {
                    for (HgRepository repository : this.myRepositories) {
                        HgBookmarkCommand.deleteBookmarkSynchronously(this.myProject, repository.getRoot(), this.myBranchName);
                    }
                });
            }
        }
    }

    public static class CurrentBranch
    extends BranchActions
    implements PopupElementWithAdditionalInfo {
        public CurrentBranch(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            super(project, repositories, branchName);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return AnAction.EMPTY_ARRAY;
        }
    }

    static class BranchActions
    extends HgCommonBranchActions {
        BranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            super(project, repositories, branchName, HgBranchType.BRANCH);
        }
    }

    public static class HgShowUnnamedHeadsForCurrentBranchAction
    extends ActionGroup
    implements DumbAware {
        @NotNull
        final HgRepository myRepository;
        @NotNull
        final String myCurrentBranchName;
        @NotNull
        Collection<Hash> myHeads;

        public HgShowUnnamedHeadsForCurrentBranchAction(@NotNull HgRepository repository) {
            super(Presentation.NULL_STRING, true);
            this.myRepository = repository;
            this.myCurrentBranchName = repository.getCurrentBranch();
            this.getTemplatePresentation().setText(HgBundle.message("action.hg4idea.show.unnamed.heads", this.myCurrentBranchName));
            this.myHeads = this.filterUnnamedHeads();
        }

        @NotNull
        private Collection<Hash> filterUnnamedHeads() {
            Collection branchWithHashes = this.myRepository.getBranches().get(this.myCurrentBranchName);
            String currentHead = this.myRepository.getCurrentRevision();
            if (branchWithHashes == null || currentHead == null || this.myRepository.getState() != Repository.State.NORMAL) {
                return Collections.emptySet();
            }
            List bookmarkHashes = ContainerUtil.map(this.myRepository.getBookmarks(), info -> info.getHash());
            branchWithHashes.removeAll(bookmarkHashes);
            branchWithHashes.remove(HashImpl.build((String)currentHead));
            return branchWithHashes;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            ArrayList<HgCommonBranchActions> branchHeadActions = new ArrayList<HgCommonBranchActions>();
            for (Hash hash : this.myHeads) {
                branchHeadActions.add(new HgCommonBranchActions(this.myRepository.getProject(), Collections.singletonList(this.myRepository), hash.toShortString()));
            }
            return branchHeadActions.toArray(AnAction.EMPTY_ARRAY);
        }

        public void update(@NotNull AnActionEvent e) {
            if (this.myRepository.isFresh() || this.myHeads.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else if (this.myRepository.getState() != Repository.State.NORMAL) {
                e.getPresentation().setEnabled(false);
            }
        }
    }

    public static class HgNewBookmarkAction
    extends DumbAwareAction {
        @NotNull
        protected final List<HgRepository> myRepositories;
        @NotNull
        final HgRepository myPreselectedRepo;

        HgNewBookmarkAction(@NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            super(HgBundle.messagePointer("action.hg4idea.bookmark.new", new Object[0]), HgBundle.messagePointer("action.hg4idea.bookmark.new.description", new Object[0]), AllIcons.General.Add);
            this.myRepositories = repositories;
            this.myPreselectedRepo = preselectedRepo;
        }

        public void update(@NotNull AnActionEvent e) {
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)HgBundle.message("action.not.possible.in.fresh.repo.new.bookmark", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name;
            HgBookmarkDialog bookmarkDialog = new HgBookmarkDialog(this.myPreselectedRepo);
            if (bookmarkDialog.showAndGet() && !StringUtil.isEmptyOrSpaces((String)(name = bookmarkDialog.getName()))) {
                HgBookmarkCommand.createBookmarkAsynchronously(this.myRepositories, name, bookmarkDialog.isActive());
            }
        }
    }

    public static class HgCloseBranchAction
    extends DumbAwareAction {
        @NotNull
        private final List<HgRepository> myRepositories;
        @NotNull
        final HgRepository myPreselectedRepo;

        HgCloseBranchAction(@NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            super(HgBundle.messagePointer("action.hg4idea.branch.close", repositories.size()), HgBundle.messagePointer("action.hg4idea.branch.close.description", repositories.size()), AllIcons.Actions.Cancel);
            this.myRepositories = repositories;
            this.myPreselectedRepo = preselectedRepo;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = this.myPreselectedRepo.getProject();
            StoreUtil.saveDocumentsAndProjectSettings((Project)project);
            ChangeListManager.getInstance((Project)project).invokeAfterUpdateWithModal(true, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), () -> this.commitAndCloseBranch(project));
        }

        private void commitAndCloseBranch(@NotNull Project project) {
            LocalChangeList activeChangeList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
            HgVcs vcs = HgVcs.getInstance(project);
            assert (vcs != null);
            HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
            List changesForRepositories = ContainerUtil.filter((Collection)activeChangeList.getChanges(), change -> this.myRepositories.contains(repositoryManager.getRepositoryForFile(ChangesUtil.getFilePath((Change)change))));
            HgCloseBranchExecutor closeBranchExecutor = vcs.getCloseBranchExecutor();
            closeBranchExecutor.setRepositories(this.myRepositories);
            CommitChangeListDialog.commitChanges((Project)project, (List)changesForRepositories, (Collection)changesForRepositories, (LocalChangeList)activeChangeList, Collections.singletonList(closeBranchExecutor), (boolean)false, (AbstractVcs)vcs, (String)"Close Branch", null, (boolean)false);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(ContainerUtil.and(this.myRepositories, repository -> repository.getOpenedBranches().contains(repository.getCurrentBranch())));
        }
    }

    public static class HgNewBranchAction
    extends NewBranchAction<HgRepository> {
        @NotNull
        final HgRepository myPreselectedRepo;

        public HgNewBranchAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            super(project, repositories);
            this.myPreselectedRepo = preselectedRepo;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            final String name = HgUtil.getNewBranchNameFromUser(this.myPreselectedRepo, HgBundle.message("hg4idea.branch.create", new Object[0]));
            if (name == null) {
                return;
            }
            new Task.Backgroundable(this.myProject, HgBundle.message("hg4idea.branch.creating.progress", this.myRepositories.size())){

                public void run(@NotNull ProgressIndicator indicator) {
                    this.createNewBranchInCurrentThread(name);
                }
            }.queue();
        }

        public void createNewBranchInCurrentThread(@NotNull String name) {
            for (HgRepository repository : this.myRepositories) {
                try {
                    HgCommandResult result = new HgBranchCreateCommand(this.myProject, repository.getRoot(), name).executeInCurrentThread();
                    repository.update();
                    if (!HgErrorUtil.hasErrorsInCommandExecution(result)) continue;
                    new HgCommandResultNotifier(this.myProject).notifyError("hg.branch.creation.error", result, HgBundle.message("hg4idea.branch.creation.error", new Object[0]), HgBundle.message("hg4idea.branch.creation.error.msg", name));
                }
                catch (HgCommandException exception) {
                    HgErrorUtil.handleException(this.myProject, "hg.branch.creation.error", HgBundle.message("hg4idea.branch.cannot.create", new Object[0]), exception);
                }
            }
        }
    }
}

