/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.action.HgProcessStateAction;
import org.zmlx.hg4idea.command.HgRebaseCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgContinueRebaseAction
extends HgProcessStateAction {
    public HgContinueRebaseAction() {
        super(Repository.State.REBASING);
    }

    @Override
    protected void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repositories, final @Nullable HgRepository selectedRepo, @NotNull DataContext dataContext) {
        new Task.Backgroundable(project, HgBundle.message("action.hg4idea.Rebase.Continue.progress", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (selectedRepo != null) {
                    HgRebaseCommand rebaseCommand = new HgRebaseCommand(project, selectedRepo);
                    HgCommandResult result = rebaseCommand.continueRebase();
                    if (HgErrorUtil.isAbort(result)) {
                        new HgCommandResultNotifier(project).notifyError("hg.rebase.continue.error", result, HgBundle.message("hg4idea.hg.error", new Object[0]), HgBundle.message("action.hg4idea.Rebase.Continue.error", new Object[0]));
                    }
                    HgUtil.markDirectoryDirty(project, selectedRepo.getRoot());
                }
            }
        }.queue();
    }
}

