/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBinaryContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.util.HgUtil;

public class HgContentRevision
implements ByteBackedContentRevision {
    private final Project myProject;
    @NotNull
    private final HgFile myHgFile;
    @NotNull
    private final HgRevisionNumber myRevisionNumber;
    private FilePath filePath;

    protected HgContentRevision(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber revisionNumber) {
        this.myProject = project;
        this.myHgFile = hgFile;
        this.myRevisionNumber = revisionNumber;
    }

    @NotNull
    public static HgContentRevision create(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber revisionNumber) {
        return !hgFile.toFilePath().getFileType().isBinary() ? new HgContentRevision(project, hgFile, revisionNumber) : new HgBinaryContentRevision(project, hgFile, revisionNumber);
    }

    @Nullable
    public String getContent() {
        if (this.myRevisionNumber.isWorkingVersion()) {
            return VcsUtil.getFileContent((String)this.myHgFile.getFile().getPath());
        }
        HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myHgFile);
        return CharsetToolkit.bytesToString((byte[])HgUtil.loadContent(this.myProject, this.myRevisionNumber, fileToCat), (Charset)this.getFile().getCharset());
    }

    public byte[] getContentAsBytes() {
        if (this.myRevisionNumber.isWorkingVersion()) {
            return VcsUtil.getFileByteContent((File)this.myHgFile.getFile());
        }
        HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myHgFile);
        return HgUtil.loadContent(this.myProject, this.myRevisionNumber, fileToCat);
    }

    @NotNull
    public FilePath getFile() {
        if (this.filePath == null) {
            this.filePath = this.myHgFile.toFilePath();
        }
        return this.filePath;
    }

    @NotNull
    public HgRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgContentRevision revision = (HgContentRevision)o;
        if (!this.myHgFile.equals(revision.myHgFile)) {
            return false;
        }
        return this.myRevisionNumber.equals(revision.myRevisionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.myHgFile, this.myRevisionNumber);
    }
}

