/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.model.fragments;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.model.CounterKt;
import trebuchet.model.CounterValue;
import trebuchet.model.fragments.CounterFragment;
import trebuchet.model.fragments.ThreadModelFragment;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u001e\u0010!\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0003J\u001c\u0010$\u001a\u00020\b2\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u000e\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0000J\u001a\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Ltrebuchet/model/fragments/ProcessModelFragment;", "", "id", "", "name", "", "hasIdCb", "Lkotlin/Function1;", "", "(ILjava/lang/String;Lkotlin/jvm/functions/Function1;)V", "_counters", "", "Ltrebuchet/model/fragments/CounterFragment;", "_id", "_threads", "Ltrebuchet/model/fragments/ThreadModelFragment;", "counters", "", "getCounters", "()Ljava/util/Map;", "value", "getId", "()I", "setId", "(I)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "threads", "", "getThreads", "()Ljava/util/Collection;", "addCounterSample", "timestamp", "", "hint", "merge", "other", "threadFor", "pid", "intellij.android.profilers.atrace"})
public final class ProcessModelFragment {
    @Nullable
    private String name;
    @Nullable
    private Function1<? super ProcessModelFragment, Unit> hasIdCb;
    private int _id;
    @NotNull
    private final Map<Integer, ThreadModelFragment> _threads;
    @NotNull
    private final Map<String, CounterFragment> _counters;

    public ProcessModelFragment(int id, @Nullable String name, @Nullable Function1<? super ProcessModelFragment, Unit> hasIdCb) {
        this.name = name;
        this.hasIdCb = hasIdCb;
        this._id = id;
        this._threads = new LinkedHashMap();
        this._counters = new LinkedHashMap();
    }

    public /* synthetic */ ProcessModelFragment(int n, String string, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        this(n, string, (Function1<? super ProcessModelFragment, Unit>)function1);
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    public final int getId() {
        return this._id;
    }

    public final void setId(int value) {
        this._id = value;
        if (this._id != -1) {
            Function1<? super ProcessModelFragment, Unit> function1 = this.hasIdCb;
            if (function1 != null) {
                function1.invoke((Object)this);
            }
            this.hasIdCb = null;
        }
    }

    @NotNull
    public final Collection<ThreadModelFragment> getThreads() {
        return this._threads.values();
    }

    @NotNull
    public final Map<String, CounterFragment> getCounters() {
        return this._counters;
    }

    @NotNull
    public final ThreadModelFragment threadFor(int pid, @Nullable String name) {
        ThreadModelFragment thread2 = this._threads.get(pid);
        if (thread2 == null) {
            thread2 = new ThreadModelFragment(pid, this, name);
            this._threads.put(pid, thread2);
        } else {
            ThreadModelFragment.hint$default(thread2, 0, name, 0, null, 13, null);
        }
        return thread2;
    }

    public static /* synthetic */ ThreadModelFragment threadFor$default(ProcessModelFragment processModelFragment, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return processModelFragment.threadFor(n, string);
    }

    public final void addCounterSample(@NotNull String name, double timestamp, int value) {
        CounterFragment counterFragment;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, CounterFragment> $this$getOrPut$iv = this._counters;
        boolean $i$f$getOrPut = false;
        CounterFragment value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            CounterFragment answer$iv = new CounterFragment(name);
            $this$getOrPut$iv.put(name, answer$iv);
            counterFragment = answer$iv;
        } else {
            counterFragment = value$iv;
        }
        counterFragment.getEvents().add(CounterKt.hasCount(timestamp, value));
    }

    public final void merge(@NotNull ProcessModelFragment other) {
        Object value;
        Map.Entry<Integer, ThreadModelFragment> entry2;
        Map.Entry<Object, Object> element$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other == this) {
            return;
        }
        if (this.getId() != -1 && this.getId() != other.getId()) {
            throw new IllegalArgumentException("Process ID mismatch");
        }
        ProcessModelFragment.hint$default(this, 0, other.name, 1, null);
        Map<Object, Object> $this$forEach$iv = other._threads;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Object, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry2 = element$iv = iterator.next();
            boolean bl = false;
            int key = ((Number)entry2.getKey()).intValue();
            value = entry2.getValue();
            if (this._threads.put(key, (ThreadModelFragment)value) != null) {
                throw new IllegalStateException("Unable to merge threads of the same ID " + key);
            }
            ((ThreadModelFragment)value).setProcess(this);
        }
        $this$forEach$iv = other._counters;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry2 = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)((Object)entry2.getKey());
            CounterFragment existing = this._counters.put(key, (CounterFragment)(value = (CounterFragment)((Object)entry2.getValue())));
            if (existing == null) continue;
            CounterFragment counterFragment = this._counters.get(key);
            Intrinsics.checkNotNull((Object)counterFragment);
            counterFragment.getEvents().addAll((Collection<CounterValue>)existing.getEvents());
        }
    }

    public final void hint(int id, @Nullable String name) {
        if (this.getId() == -1) {
            this.setId(id);
        }
        if (this.name == null) {
            this.name = name;
        }
    }

    public static /* synthetic */ void hint$default(ProcessModelFragment processModelFragment, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        processModelFragment.hint(n, string);
    }
}

