/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.model;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.ProcessModel;
import trebuchet.model.SchedSlice;
import trebuchet.model.base.SliceGroup;
import trebuchet.model.fragments.ThreadModelFragment;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019\u00a8\u0006\u001d"}, d2={"Ltrebuchet/model/ThreadModel;", "", "process", "Ltrebuchet/model/ProcessModel;", "fragment", "Ltrebuchet/model/fragments/ThreadModelFragment;", "(Ltrebuchet/model/ProcessModel;Ltrebuchet/model/fragments/ThreadModelFragment;)V", "hasContent", "", "getHasContent", "()Z", "id", "", "getId", "()I", "name", "", "getName", "()Ljava/lang/String;", "getProcess", "()Ltrebuchet/model/ProcessModel;", "schedSlices", "", "Ltrebuchet/model/SchedSlice;", "getSchedSlices", "()Ljava/util/List;", "slices", "Ltrebuchet/model/base/SliceGroup;", "getSlices", "intellij.android.profilers.atrace"})
public final class ThreadModel {
    @NotNull
    private final ProcessModel process;
    private final int id;
    @NotNull
    private final String name;
    @NotNull
    private final List<SliceGroup> slices;
    @NotNull
    private final List<SchedSlice> schedSlices;
    private final boolean hasContent;

    public ThreadModel(@NotNull ProcessModel process, @NotNull ThreadModelFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.process = process;
        this.id = fragment.getId();
        Object object = fragment.getName();
        if (object == null) {
            object = "<" + this.id + ">";
        }
        this.name = object;
        this.slices = fragment.getSlices();
        this.schedSlices = fragment.getSchedSlices();
        this.hasContent = !((Collection)this.slices).isEmpty() && !((Collection)this.schedSlices).isEmpty();
        if (this.id == -1) {
            throw new IllegalArgumentException("Thread has invalid id");
        }
    }

    @NotNull
    public final ProcessModel getProcess() {
        return this.process;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<SliceGroup> getSlices() {
        return this.slices;
    }

    @NotNull
    public final List<SchedSlice> getSchedSlices() {
        return this.schedSlices;
    }

    public final boolean getHasContent() {
        return this.hasContent;
    }
}

