/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u000223B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010&\u001a\u00020'H\u0002J\u0006\u0010(\u001a\u00020'J\b\u0010)\u001a\u00020'H\u0016J\u0010\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030+J\u0006\u0010,\u001a\u00020\u0019J\u0018\u0010-\u001a\u00020'2\u0010\u0010.\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030+J\u000e\u0010/\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u0004J\u0010\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\u0016H\u0016R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/profilers/sessions/SessionItem;", "Lcom/android/tools/adtui/model/AspectModel;", "Lcom/android/tools/profilers/sessions/SessionItem$Aspect;", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "Lcom/android/tools/profiler/proto/Common$Session;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "initialSession", "sessionMetaData", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profiler/proto/Common$Session;Lcom/android/tools/profiler/proto/Common$SessionMetaData;)V", "activeSession", "artifactProto", "getArtifactProto", "()Lcom/android/tools/profiler/proto/Common$Session;", "canExport", "", "getCanExport", "()Z", "childArtifacts", "", "durationNs", "", "isOngoing", "name", "", "getName", "()Ljava/lang/String;", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "session", "getSession", "getSessionMetaData", "()Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "timestampNs", "getTimestampNs", "()J", "waitingForAgent", "agentStatusChanged", "", "deleteSession", "doSelect", "getChildArtifacts", "", "getSubtitle", "setChildArtifacts", "artifacts", "setSession", "update", "elapsedNs", "Aspect", "Companion", "intellij.android.profilers"})
public final class SessionItem
extends AspectModel<Aspect>
implements SessionArtifact<Common.Session> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Common.SessionMetaData sessionMetaData;
    @NotNull
    private Common.Session activeSession;
    private long durationNs;
    private boolean waitingForAgent;
    @NotNull
    private final List<SessionArtifact<?>> childArtifacts;
    @NotNull
    private final String name;
    private final long timestampNs;
    private final boolean canExport;
    @NotNull
    private static final String SESSION_INITIALIZING = "Starting...";
    @NotNull
    public static final String SESSION_LOADING = "Loading...";

    public SessionItem(@NotNull StudioProfilers profilers, @NotNull Common.Session initialSession, @NotNull Common.SessionMetaData sessionMetaData) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)initialSession, (String)"initialSession");
        Intrinsics.checkNotNullParameter((Object)sessionMetaData, (String)"sessionMetaData");
        this.profilers = profilers;
        this.sessionMetaData = sessionMetaData;
        this.activeSession = initialSession;
        this.childArtifacts = new ArrayList();
        this.name = SessionItem.Companion.parseName(this.getSessionMetaData());
        if (!SessionsManager.isSessionAlive(this.activeSession)) {
            this.durationNs = this.activeSession.getEndTimestamp() - this.activeSession.getStartTimestamp();
        }
        this.getProfilers().addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, new Runnable(){

            @Override
            public final void run() {
                this.agentStatusChanged();
            }
        });
        this.agentStatusChanged();
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        return this.profilers;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        return this.sessionMetaData;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.activeSession;
    }

    @Override
    @NotNull
    public Common.Session getArtifactProto() {
        return this.activeSession;
    }

    @Override
    public long getTimestampNs() {
        return this.timestampNs;
    }

    @Override
    public boolean isOngoing() {
        return SessionsManager.isSessionAlive(this.activeSession);
    }

    @Override
    public boolean getCanExport() {
        return this.canExport;
    }

    public final void setSession(@NotNull Common.Session session) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        boolean bl2 = bl = this.activeSession.getSessionId() == session.getSessionId();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.activeSession = session;
    }

    @Override
    public void doSelect() {
        this.getProfilers().getSessionsManager().setSession(this.activeSession);
        if (this.getSessionMetaData().getType() == Common.SessionMetaData.SessionType.FULL && !Intrinsics.areEqual(this.getProfilers().getStageClass(), StudioMonitorStage.class)) {
            this.getProfilers().setStage(new StudioMonitorStage(this.getProfilers()));
        }
        this.getProfilers().getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.getProfilers().getSessionsManager().isSessionAlive());
    }

    @Override
    public void update(long elapsedNs) {
        if (SessionsManager.isSessionAlive(this.activeSession)) {
            this.durationNs += elapsedNs;
            this.changed(Aspect.MODEL);
        }
    }

    private final void agentStatusChanged() {
        boolean bl;
        boolean oldValue = this.waitingForAgent;
        if (SessionsManager.isSessionAlive(this.activeSession) && Intrinsics.areEqual((Object)this.activeSession, (Object)this.getProfilers().getSessionsManager().getSelectedSession())) {
            Common.AgentData agentData = this.getProfilers().getAgentData();
            Intrinsics.checkNotNullExpressionValue((Object)agentData, (String)"profilers.agentData");
            Common.AgentData agentData2 = agentData;
            bl = agentData2.getStatus() == Common.AgentData.Status.UNSPECIFIED;
        } else {
            bl = this.waitingForAgent = false;
        }
        if (oldValue != this.waitingForAgent) {
            this.changed(Aspect.MODEL);
        }
    }

    public final void deleteSession() {
        this.getProfilers().getSessionsManager().deleteSession(this.activeSession);
    }

    @NotNull
    public final String getSubtitle() {
        String string;
        if (this.getSessionMetaData().getType() != Common.SessionMetaData.SessionType.FULL) {
            String string2;
            if (!((Collection)this.childArtifacts).isEmpty()) {
                boolean bl;
                boolean bl2 = bl = this.childArtifacts.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                string2 = this.childArtifacts.get(0).getName();
            } else {
                string2 = SESSION_LOADING;
            }
            return string2;
        }
        if (this.waitingForAgent) {
            string = SESSION_INITIALIZING;
        } else {
            long durationUs = TimeUnit.NANOSECONDS.toMicros(this.durationNs);
            String string4 = TimeFormatter.getMultiUnitDurationString((long)durationUs);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n      val durationUs =\u2026nString(durationUs)\n    }");
        }
        return string;
    }

    @NotNull
    public final List<SessionArtifact<?>> getChildArtifacts() {
        return CollectionsKt.toList((Iterable)this.childArtifacts);
    }

    public final void setChildArtifacts(@NotNull List<? extends SessionArtifact<?>> artifacts) {
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        this.childArtifacts.clear();
        this.childArtifacts.addAll((Collection)artifacts);
        this.changed(Aspect.MODEL);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/profilers/sessions/SessionItem$Aspect;", "", "(Ljava/lang/String;I)V", "MODEL", "intellij.android.profilers"})
    public static final class Aspect
    extends Enum<Aspect> {
        public static final /* enum */ Aspect MODEL = new Aspect();
        private static final /* synthetic */ Aspect[] $VALUES;

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String value) {
            return Enum.valueOf(Aspect.class, value);
        }

        static {
            $VALUES = aspectArray = new Aspect[]{Aspect.MODEL};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/sessions/SessionItem$Companion;", "", "()V", "SESSION_INITIALIZING", "", "SESSION_LOADING", "getSESSION_LOADING$annotations", "parseName", "metaData", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSESSION_LOADING$annotations() {
        }

        private final String parseName(Common.SessionMetaData metaData) {
            Regex nameRegex = new Regex("(?<package>.+) \\((?<device>.+)\\)");
            if (metaData.getType() != Common.SessionMetaData.SessionType.FULL) {
                String string = metaData.getSessionName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"metaData.sessionName");
                return string;
            }
            String string = metaData.getSessionName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"metaData.sessionName");
            MatchResult match = nameRegex.matchEntire((CharSequence)string);
            if (match != null) {
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"package");
                Intrinsics.checkNotNull((Object)matchGroup);
                char[] cArray = new char[]{'.'};
                String appName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)matchGroup.getValue(), (char[])cArray, (boolean)false, (int)0, (int)6, null));
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"device");
                Intrinsics.checkNotNull((Object)matchGroup2);
                String deviceName = matchGroup2.getValue();
                return appName + " (" + deviceName + ")";
            }
            String string2 = metaData.getSessionName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"metaData.sessionName");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

