/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.perfetto.traceprocessor;

import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.android.tools.profilers.cpu.systemtrace.CounterModel;
import com.android.tools.profilers.cpu.systemtrace.CpuCoreModel;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SchedulingEventModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.ThreadModel;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorModelKt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import perfetto.protos.PerfettoTrace;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0002*+B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\u0011H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00182\u0006\u0010$\u001a\u00020\u0011H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel;", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "Ljava/io/Serializable;", "builder", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;", "(Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;)V", "androidFrameLayers", "", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$AndroidFrameEventsResult$Layer;", "androidFrameTimelineEvents", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;", "batteryDrain", "Lcom/android/tools/profilers/cpu/systemtrace/CounterModel;", "cpuCores", "Lcom/android/tools/profilers/cpu/systemtrace/CpuCoreModel;", "danglingThreads", "", "", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "endCaptureTimestamp", "", "powerRails", "processMap", "", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "startCaptureTimestamp", "getAndroidFrameLayers", "getAndroidFrameTimelineEvents", "getBatteryDrain", "getCaptureEndTimestampUs", "getCaptureStartTimestampUs", "getCpuCores", "getDanglingThread", "tid", "getPowerRails", "getProcessById", "id", "getProcesses", "getSystemTraceTechnology", "Lcom/android/tools/profilers/cpu/config/ProfilingConfiguration$TraceType;", "isCapturePossibleCorrupted", "", "Builder", "Companion", "intellij.android.profilers"})
public final class TraceProcessorModel
implements SystemTraceModelAdapter,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Integer, ProcessModel> processMap;
    @NotNull
    private final List<CpuCoreModel> cpuCores;
    @NotNull
    private final List<CounterModel> powerRails;
    @NotNull
    private final List<CounterModel> batteryDrain;
    @NotNull
    private final List<TraceProcessor.AndroidFrameEventsResult.Layer> androidFrameLayers;
    @NotNull
    private final List<AndroidFrameTimelineEvent> androidFrameTimelineEvents;
    @NotNull
    private final Map<Integer, ThreadModel> danglingThreads;
    private final long startCaptureTimestamp;
    private final long endCaptureTimestamp;
    private static final long serialVersionUID = -2228053132990163476L;

    /*
     * WARNING - void declaration
     */
    public TraceProcessorModel(@NotNull Builder builder) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CounterModel it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void it2;
        SortedMap updatedThreadMap;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.danglingThreads = builder.getDanglingThreads$intellij_android_profilers();
        this.startCaptureTimestamp = builder.getStartCaptureTimestamp$intellij_android_profilers();
        this.endCaptureTimestamp = builder.getEndCaptureTimestamp$intellij_android_profilers();
        Map processMapBuilder = new LinkedHashMap();
        for (ProcessModel process : builder.getProcessById$intellij_android_profilers().values()) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            CounterModel it$iv$iv;
            void $this$mapValuesTo$iv$iv;
            Map<Integer, ThreadModel> $this$mapValues$iv = process.getThreadById();
            boolean $i$f$mapValues22 = false;
            Map<Integer, ThreadModel> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo22 = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void entry2;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry4 = (Map.Entry)element$iv$iv$iv;
                object2 = it$iv$iv.getKey();
                object = map2;
                boolean bl2 = false;
                ThreadModel threadModel = ThreadModel.copy$default((ThreadModel)entry2.getValue(), 0, 0, null, builder.getThreadToEventsMap$intellij_android_profilers().getOrDefault(entry2.getKey(), CollectionsKt.emptyList()), builder.getThreadToScheduling$intellij_android_profilers().getOrDefault(entry2.getKey(), CollectionsKt.emptyList()), 7, null);
                object.put(object2, threadModel);
            }
            updatedThreadMap = MapsKt.toSortedMap((Map)destination$iv$iv);
            Iterable $i$f$mapValues22 = builder.getProcessToCounters$intellij_android_profilers().getOrDefault(process.getId(), CollectionsKt.emptyList());
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void $i$f$mapValuesTo22 = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                it$iv$iv = (CounterModel)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.put(it2.getName(), element$iv$iv);
            }
            Map counterMap = destination$iv$iv2;
            processMapBuilder.put(process.getId(), ProcessModel.copy$default(process, 0, null, updatedThreadMap, counterMap, 3, null));
        }
        this.processMap = MapsKt.toSortedMap((Map)processMapBuilder);
        Iterable iterable = builder.getPowerCounters$intellij_android_profilers();
        object = this;
        boolean $i$f$filter = false;
        updatedThreadMap = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CounterModel)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it.getName(), (CharSequence)"power.rails.", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((TraceProcessorModel)object).powerRails = (List)destination$iv$iv;
        $this$filter$iv = builder.getPowerCounters$intellij_android_profilers();
        object = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CounterModel)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it.getName(), (CharSequence)"batt.", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((TraceProcessorModel)object).batteryDrain = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)builder.getCpuCoresCount$intellij_android_profilers());
        object = this;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            int item$iv$iv;
            int it3 = item$iv$iv = ((IntIterator)iterator).nextInt();
            object2 = destination$iv$iv;
            boolean bl = false;
            Iterable $i$f$associateByTo = builder.getCoreToCpuCounters$intellij_android_profilers().getOrDefault(it3, CollectionsKt.emptyList());
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            it2 = $this$associateBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void counter;
                CounterModel counterModel = (CounterModel)element$iv$iv;
                Map map = destination$iv$iv3;
                boolean bl3 = false;
                map.put(counter.getName(), element$iv$iv);
            }
            Map cpuCountersMap = destination$iv$iv3;
            object2.add((CpuCoreModel)new CpuCoreModel(it3, builder.getCoreToScheduling$intellij_android_profilers().getOrDefault(it3, CollectionsKt.emptyList()), cpuCountersMap));
        }
        ((TraceProcessorModel)object).cpuCores = (List)destination$iv$iv;
        this.androidFrameTimelineEvents = builder.getAndroidFrameTimelineEvents$intellij_android_profilers();
        this.androidFrameLayers = this.androidFrameTimelineEvents.isEmpty() ? builder.getAndroidFrameLayers$intellij_android_profilers() : TraceProcessorModelKt.access$renumbered(builder.getAndroidFrameLayers$intellij_android_profilers(), this.androidFrameTimelineEvents, builder.getSurfaceflingerDisplayTokenToEndNs$intellij_android_profilers());
    }

    @Override
    public long getCaptureStartTimestampUs() {
        return this.startCaptureTimestamp;
    }

    @Override
    public long getCaptureEndTimestampUs() {
        return this.endCaptureTimestamp;
    }

    @Override
    @Nullable
    public ProcessModel getProcessById(int id) {
        return this.processMap.get(id);
    }

    @Override
    @NotNull
    public List<ProcessModel> getProcesses() {
        return CollectionsKt.toList((Iterable)this.processMap.values());
    }

    @Override
    @Nullable
    public ThreadModel getDanglingThread(int tid) {
        return this.danglingThreads.get(tid);
    }

    @Override
    @NotNull
    public List<CpuCoreModel> getCpuCores() {
        return this.cpuCores;
    }

    @Override
    @NotNull
    public List<CounterModel> getPowerRails() {
        return this.powerRails;
    }

    @Override
    @NotNull
    public List<CounterModel> getBatteryDrain() {
        return this.batteryDrain;
    }

    @Override
    @NotNull
    public ProfilingConfiguration.TraceType getSystemTraceTechnology() {
        return ProfilingConfiguration.TraceType.PERFETTO;
    }

    @Override
    public boolean isCapturePossibleCorrupted() {
        return false;
    }

    @Override
    @NotNull
    public List<TraceProcessor.AndroidFrameEventsResult.Layer> getAndroidFrameLayers() {
        return this.androidFrameLayers;
    }

    @Override
    @NotNull
    public List<AndroidFrameTimelineEvent> getAndroidFrameTimelineEvents() {
        return this.androidFrameTimelineEvents;
    }

    public static final long getSerialVersionUID() {
        return Companion.getSerialVersionUID();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Companion;", "", "()V", "serialVersionUID", "", "getSerialVersionUID$annotations", "getSerialVersionUID", "()J", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        public final long getSerialVersionUID() {
            return serialVersionUID;
        }

        @JvmStatic
        public static /* synthetic */ void getSerialVersionUID$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u0002082\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u0002082\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u0002082\u0006\u0010B\u001a\u00020EJ\u000e\u0010F\u001a\u0002082\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u0002082\u0006\u0010J\u001a\u00020KJ\u000e\u0010L\u001a\u0002082\u0006\u0010M\u001a\u00020NJ\u0006\u0010O\u001a\u00020PJ\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u00020\u001e2\u0006\u0010V\u001a\u00020\u001eH\u0002J\u000e\u0010W\u001a\u0002082\u0006\u0010<\u001a\u00020=J\u0010\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020[H\u0002JP\u0010_\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002030.2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u001e0a2\u0018\u0010b\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u000e0.2\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002030.H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000e0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001b0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0007R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020&0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0011R&\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0011R\u001a\u0010*\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010 \"\u0004\b,\u0010\"R&\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0.X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0011\"\u0004\b0\u00101R&\u00102\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u000e0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0011R&\u00105\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u000e0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0011\u00a8\u0006d"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;", "", "()V", "androidFrameLayers", "", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$AndroidFrameEventsResult$Layer;", "getAndroidFrameLayers$intellij_android_profilers", "()Ljava/util/List;", "androidFrameTimelineEvents", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;", "getAndroidFrameTimelineEvents$intellij_android_profilers", "coreToCpuCounters", "", "", "", "Lcom/android/tools/profilers/cpu/systemtrace/CounterModel;", "getCoreToCpuCounters$intellij_android_profilers", "()Ljava/util/Map;", "coreToScheduling", "Lcom/android/tools/profilers/cpu/systemtrace/SchedulingEventModel;", "getCoreToScheduling$intellij_android_profilers", "cpuCoresCount", "getCpuCoresCount$intellij_android_profilers", "()I", "setCpuCoresCount$intellij_android_profilers", "(I)V", "danglingThreads", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "getDanglingThreads$intellij_android_profilers", "endCaptureTimestamp", "", "getEndCaptureTimestamp$intellij_android_profilers", "()J", "setEndCaptureTimestamp$intellij_android_profilers", "(J)V", "powerCounters", "getPowerCounters$intellij_android_profilers", "processById", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "getProcessById$intellij_android_profilers", "processToCounters", "getProcessToCounters$intellij_android_profilers", "startCaptureTimestamp", "getStartCaptureTimestamp$intellij_android_profilers", "setStartCaptureTimestamp$intellij_android_profilers", "surfaceflingerDisplayTokenToEndNs", "", "getSurfaceflingerDisplayTokenToEndNs$intellij_android_profilers", "setSurfaceflingerDisplayTokenToEndNs$intellij_android_profilers", "(Ljava/util/Map;)V", "threadToEventsMap", "Lcom/android/tools/profilers/cpu/systemtrace/TraceEventModel;", "getThreadToEventsMap$intellij_android_profilers", "threadToScheduling", "getThreadToScheduling$intellij_android_profilers", "addAndroidFrameEvents", "", "frameEventsResult", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$AndroidFrameEventsResult;", "addAndroidFrameTimelineEvents", "frameTimelineResult", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$AndroidFrameTimelineResult;", "addCpuCounters", "result", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$CpuCoreCountersResult;", "addPowerCounters", "counters", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$PowerCounterTracksResult;", "addProcessCounters", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$ProcessCountersResult;", "addProcessMetadata", "processMetadataResult", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$ProcessMetadataResult;", "addSchedulingEvents", "schedEvents", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$SchedulingEventsResult;", "addTraceEvents", "traceEventsResult", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$TraceEventsResult;", "build", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel;", "convertSchedulingState", "Lcom/android/tools/profilers/cpu/ThreadState;", "state", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$SchedulingEventsResult$SchedulingEvent$SchedulingState;", "convertToUs", "tsNanos", "indexSurfaceflingerFrameTimelineEvents", "parseAppJankType", "Lperfetto/protos/PerfettoTrace$FrameTimelineEvent$JankType;", "jankTypeStr", "", "parsePresentType", "Lperfetto/protos/PerfettoTrace$FrameTimelineEvent$PresentType;", "presetTypeStr", "reconstructTraceTree", "rootIds", "", "eventToChildrenIds", "eventPerId", "intellij.android.profilers"})
    public static final class Builder {
        private long startCaptureTimestamp = Long.MAX_VALUE;
        private long endCaptureTimestamp = Long.MIN_VALUE;
        private int cpuCoresCount;
        @NotNull
        private final Map<Integer, ProcessModel> processById = new LinkedHashMap();
        @NotNull
        private final Map<Integer, ThreadModel> danglingThreads = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<TraceEventModel>> threadToEventsMap = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<SchedulingEventModel>> threadToScheduling = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<SchedulingEventModel>> coreToScheduling = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<CounterModel>> coreToCpuCounters = new LinkedHashMap();
        @NotNull
        private final Map<Integer, List<CounterModel>> processToCounters = new LinkedHashMap();
        @NotNull
        private final List<CounterModel> powerCounters = new ArrayList();
        @NotNull
        private final List<TraceProcessor.AndroidFrameEventsResult.Layer> androidFrameLayers = new ArrayList();
        @NotNull
        private final List<AndroidFrameTimelineEvent> androidFrameTimelineEvents = new ArrayList();
        @NotNull
        private Map<Long, Long> surfaceflingerDisplayTokenToEndNs = MapsKt.emptyMap();

        public final long getStartCaptureTimestamp$intellij_android_profilers() {
            return this.startCaptureTimestamp;
        }

        public final void setStartCaptureTimestamp$intellij_android_profilers(long l) {
            this.startCaptureTimestamp = l;
        }

        public final long getEndCaptureTimestamp$intellij_android_profilers() {
            return this.endCaptureTimestamp;
        }

        public final void setEndCaptureTimestamp$intellij_android_profilers(long l) {
            this.endCaptureTimestamp = l;
        }

        public final int getCpuCoresCount$intellij_android_profilers() {
            return this.cpuCoresCount;
        }

        public final void setCpuCoresCount$intellij_android_profilers(int n) {
            this.cpuCoresCount = n;
        }

        @NotNull
        public final Map<Integer, ProcessModel> getProcessById$intellij_android_profilers() {
            return this.processById;
        }

        @NotNull
        public final Map<Integer, ThreadModel> getDanglingThreads$intellij_android_profilers() {
            return this.danglingThreads;
        }

        @NotNull
        public final Map<Integer, List<TraceEventModel>> getThreadToEventsMap$intellij_android_profilers() {
            return this.threadToEventsMap;
        }

        @NotNull
        public final Map<Integer, List<SchedulingEventModel>> getThreadToScheduling$intellij_android_profilers() {
            return this.threadToScheduling;
        }

        @NotNull
        public final Map<Integer, List<SchedulingEventModel>> getCoreToScheduling$intellij_android_profilers() {
            return this.coreToScheduling;
        }

        @NotNull
        public final Map<Integer, List<CounterModel>> getCoreToCpuCounters$intellij_android_profilers() {
            return this.coreToCpuCounters;
        }

        @NotNull
        public final Map<Integer, List<CounterModel>> getProcessToCounters$intellij_android_profilers() {
            return this.processToCounters;
        }

        @NotNull
        public final List<CounterModel> getPowerCounters$intellij_android_profilers() {
            return this.powerCounters;
        }

        @NotNull
        public final List<TraceProcessor.AndroidFrameEventsResult.Layer> getAndroidFrameLayers$intellij_android_profilers() {
            return this.androidFrameLayers;
        }

        @NotNull
        public final List<AndroidFrameTimelineEvent> getAndroidFrameTimelineEvents$intellij_android_profilers() {
            return this.androidFrameTimelineEvents;
        }

        @NotNull
        public final Map<Long, Long> getSurfaceflingerDisplayTokenToEndNs$intellij_android_profilers() {
            return this.surfaceflingerDisplayTokenToEndNs;
        }

        public final void setSurfaceflingerDisplayTokenToEndNs$intellij_android_profilers(@NotNull Map<Long, Long> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.surfaceflingerDisplayTokenToEndNs = map;
        }

        /*
         * WARNING - void declaration
         */
        public final void addProcessMetadata(@NotNull TraceProcessor.ProcessMetadataResult processMetadataResult) {
            Object object;
            Integer n;
            Map<Integer, Serializable> map;
            Intrinsics.checkNotNullParameter((Object)processMetadataResult, (String)"processMetadataResult");
            for (TraceProcessor.ProcessMetadataResult.ProcessMetadata process : processMetadataResult.getProcessList()) {
                String string;
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                map = this.processById;
                n = (int)process.getId();
                int n2 = (int)process.getId();
                Intrinsics.checkNotNullExpressionValue((Object)process.getName(), (String)"process.name");
                List list = process.getThreadList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"process.threadList");
                object = list;
                int n3 = n2;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var9_9 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    TraceProcessor.ProcessMetadataResult.ThreadMetadata t = (TraceProcessor.ProcessMetadataResult.ThreadMetadata)element$iv$iv;
                    boolean bl = false;
                    Integer n4 = (int)t.getId();
                    int n5 = (int)t.getId();
                    int n6 = (int)process.getId();
                    String string2 = t.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"t.name");
                    Pair pair = TuplesKt.to((Object)n4, (Object)new ThreadModel(n5, n6, string2, CollectionsKt.emptyList(), CollectionsKt.emptyList()));
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                Map map3 = destination$iv$iv;
                Map map4 = MapsKt.emptyMap();
                Map map5 = MapsKt.toSortedMap((Map)map3);
                String string3 = string;
                int n7 = n3;
                object = new ProcessModel(n7, string3, map5, map4);
                map.put(n, (Serializable)object);
            }
            for (TraceProcessor.ProcessMetadataResult.ThreadMetadata thread2 : processMetadataResult.getDanglingThreadList()) {
                map = this.danglingThreads;
                n = (int)thread2.getId();
                int n8 = (int)thread2.getId();
                String string = thread2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"thread.name");
                object = new ThreadModel(n8, 0, string, CollectionsKt.emptyList(), CollectionsKt.emptyList());
                map.put(n, (ProcessModel)object);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addTraceEvents(@NotNull TraceProcessor.TraceEventsResult traceEventsResult) {
            Intrinsics.checkNotNullParameter((Object)traceEventsResult, (String)"traceEventsResult");
            for (TraceProcessor.TraceEventsResult.ThreadTraceEvents thread2 : traceEventsResult.getThreadList()) {
                void $this$mapNotNullTo$iv$iv;
                Object object;
                Object value$iv;
                Set rootIds = new LinkedHashSet();
                Map eventToChildrenIds = new LinkedHashMap();
                Map eventPerId = new LinkedHashMap();
                for (TraceProcessor.TraceEventsResult.TraceEvent event : thread2.getTraceEventList()) {
                    if (event.getDepth() > 0) {
                        Object object2;
                        void $this$getOrPut$iv;
                        Map map = eventToChildrenIds;
                        Long key$iv = event.getParentId();
                        boolean $i$f$getOrPut = false;
                        value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        ((List)object2).add(event.getId());
                    } else {
                        rootIds.add(event.getId());
                    }
                    long startTimestampUs = this.convertToUs(event.getTimestampNanoseconds());
                    long durationTimestampUs = this.convertToUs(event.getDurationNanoseconds());
                    long endTimestampUs = startTimestampUs + durationTimestampUs;
                    Map map = eventPerId;
                    Long l = event.getId();
                    String string = event.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.name");
                    object = new TraceEventModel(string, startTimestampUs, endTimestampUs, durationTimestampUs, CollectionsKt.emptyList());
                    map.put(l, object);
                }
                Map<Long, TraceEventModel> reconstructedTree = this.reconstructTraceTree(rootIds, eventToChildrenIds, eventPerId);
                Map<Integer, List<TraceEventModel>> map = this.threadToEventsMap;
                Integer n = (int)thread2.getThreadId();
                Iterable $this$mapNotNull$iv = rootIds;
                boolean $i$f$mapNotNull = false;
                value$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    TraceEventModel it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl = false;
                    long it = ((Number)element$iv$iv).longValue();
                    boolean bl2 = false;
                    if (reconstructedTree.get(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                map.put(n, list);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Long, TraceEventModel> reconstructTraceTree(Set<Long> rootIds, Map<Long, ? extends List<Long>> eventToChildrenIds, Map<Long, TraceEventModel> eventPerId) {
            Map reconstructedEventsPerId = new LinkedHashMap();
            Set visitedAllChildren = new LinkedHashSet();
            Deque eventIdStack = new LinkedList(rootIds);
            while (!((Collection)eventIdStack).isEmpty()) {
                TraceEventModel event;
                void $this$sortedBy$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object element$iv2;
                Long eventId = (Long)eventIdStack.getFirst();
                if (!visitedAllChildren.contains(eventId)) {
                    Intrinsics.checkNotNullExpressionValue((Object)eventId, (String)"eventId");
                    Iterable $this$forEach$iv = eventToChildrenIds.getOrDefault(eventId, (List)new ArrayList());
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        long it = ((Number)element$iv2).longValue();
                        boolean bl = false;
                        eventIdStack.addFirst(it);
                    }
                    visitedAllChildren.add(eventId);
                    continue;
                }
                eventIdStack.removeFirst();
                Intrinsics.checkNotNullExpressionValue((Object)eventId, (String)"eventId");
                Iterable $i$f$forEach = eventToChildrenIds.getOrDefault(eventId, (List)new ArrayList());
                boolean $i$f$map = false;
                element$iv2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    long l = ((Number)item$iv$iv).longValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    TraceEventModel traceEventModel = (TraceEventModel)reconstructedEventsPerId.get((long)it);
                    if (traceEventModel == null) {
                        throw new IllegalStateException("Children should have been computed already".toString());
                    }
                    collection.add(traceEventModel);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                List children2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        TraceEventModel it = (TraceEventModel)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getStartTimestampUs());
                        it = (TraceEventModel)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStartTimestampUs()));
                    }
                });
                if (eventPerId.get(eventId) == null) {
                    throw new IllegalStateException("Trace Event should be present in the map".toString());
                }
                long myStart = event.getStartTimestampUs();
                TraceEventModel traceEventModel = (TraceEventModel)CollectionsKt.lastOrNull((List)children2);
                long maxEndTs = traceEventModel != null ? traceEventModel.getEndTimestampUs() : 0L;
                long myCpuTime = event.getCpuTimeUs();
                TraceEventModel updatedEvent = TraceEventModel.copy$default(event, null, 0L, Math.max(myStart + myCpuTime, maxEndTs), 0L, children2, 11, null);
                reconstructedEventsPerId.put(eventId, updatedEvent);
                this.startCaptureTimestamp = Math.min(this.startCaptureTimestamp, updatedEvent.getStartTimestampUs());
                this.endCaptureTimestamp = Math.max(this.endCaptureTimestamp, updatedEvent.getEndTimestampUs());
            }
            return reconstructedEventsPerId;
        }

        /*
         * WARNING - void declaration
         */
        public final void addSchedulingEvents(@NotNull TraceProcessor.SchedulingEventsResult schedEvents) {
            Iterable $this$sortedBy$iv;
            Map<Integer, List<SchedulingEventModel>> map;
            Map.Entry element$iv;
            Map $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            Intrinsics.checkNotNullParameter((Object)schedEvents, (String)"schedEvents");
            this.cpuCoresCount = Math.max(this.cpuCoresCount, schedEvents.getNumCores());
            Map perThreadScheduling = new LinkedHashMap();
            Map perCoreScheduling = new LinkedHashMap();
            List list = schedEvents.getSchedEventList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schedEvents.schedEventList");
            Iterable iterable = list;
            boolean $i$f$groupBy = false;
            Iterator iterator = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                TraceProcessor.SchedulingEventsResult.SchedulingEvent it = (TraceProcessor.SchedulingEventsResult.SchedulingEvent)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.getThreadId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry $i$f$groupByTo2 = element$iv = iterator.next();
                boolean bl = false;
                long tid = ((Number)$i$f$groupByTo2.getKey()).longValue();
                List events = (List)$i$f$groupByTo2.getValue();
                Iterable $this$forEachIndexed$iv = events;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    List list2;
                    List list3;
                    List answer$iv;
                    Object $this$getOrPut$iv;
                    void event;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    TraceProcessor.SchedulingEventsResult.SchedulingEvent schedulingEvent = (TraceProcessor.SchedulingEventsResult.SchedulingEvent)item$iv;
                    int index = n;
                    boolean bl3 = false;
                    long startTimestampUs = this.convertToUs(event.getTimestampNanoseconds());
                    long durationUs = this.convertToUs(event.getDurationNanoseconds());
                    long endTimestampUs = startTimestampUs + durationUs;
                    this.startCaptureTimestamp = Math.min(this.startCaptureTimestamp, startTimestampUs);
                    this.endCaptureTimestamp = Math.max(this.endCaptureTimestamp, endTimestampUs);
                    SchedulingEventModel schedEvent = new SchedulingEventModel(ThreadState.RUNNING_CAPTURED, startTimestampUs, endTimestampUs, durationUs, durationUs, (int)event.getProcessId(), (int)event.getThreadId(), event.getCpu());
                    Map map2 = perThreadScheduling;
                    Integer key$iv = (int)tid;
                    boolean $i$f$getOrPut = false;
                    List value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        answer$iv = new ArrayList();
                        $this$getOrPut$iv.put((Integer)key$iv, (List)answer$iv);
                        list3 = answer$iv;
                    } else {
                        list3 = value$iv;
                    }
                    $this$getOrPut$iv = list3;
                    List $this$addSchedulingEvents_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d8 = (List)$this$getOrPut$iv;
                    boolean bl5 = false;
                    $this$addSchedulingEvents_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d8.add(schedEvent);
                    if (index < events.size() - 1) {
                        long nextStartTimestampUs = this.convertToUs(((TraceProcessor.SchedulingEventsResult.SchedulingEvent)events.get(index + 1)).getTimestampNanoseconds());
                        long nextDurationTimeUs = nextStartTimestampUs - endTimestampUs;
                        TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState schedulingState = event.getEndState();
                        Intrinsics.checkNotNullExpressionValue((Object)schedulingState, (String)"event.endState");
                        $this$addSchedulingEvents_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d8.add(new SchedulingEventModel(this.convertSchedulingState(schedulingState), endTimestampUs, nextStartTimestampUs, nextDurationTimeUs, nextDurationTimeUs, (int)event.getProcessId(), (int)event.getThreadId(), event.getCpu()));
                    }
                    $this$getOrPut$iv = perCoreScheduling;
                    key$iv = event.getCpu();
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl6 = false;
                        answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        list2 = answer$iv;
                    } else {
                        list2 = value$iv;
                    }
                    ((List)list2).add(schedEvent);
                }
            }
            $this$forEach$iv = perThreadScheduling;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                List list4 = this.threadToScheduling.get(it.getKey());
                if (list4 == null) {
                    list4 = CollectionsKt.emptyList();
                }
                List previousList = list4;
                map = this.threadToScheduling;
                Object k = it.getKey();
                $this$sortedBy$iv = CollectionsKt.plus((Collection)previousList, (Iterable)((Iterable)it.getValue()));
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SchedulingEventModel s = (SchedulingEventModel)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(s.getStartTimestampUs());
                        s = (SchedulingEventModel)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(s.getStartTimestampUs()));
                    }
                });
                map.put((Integer)k, (List<SchedulingEventModel>)$this$sortedBy$iv);
            }
            $this$forEach$iv = perCoreScheduling;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                List list5 = this.coreToScheduling.get(it.getKey());
                if (list5 == null) {
                    list5 = CollectionsKt.emptyList();
                }
                List previousList = list5;
                map = this.coreToScheduling;
                Object k = it.getKey();
                $this$sortedBy$iv = CollectionsKt.plus((Collection)previousList, (Iterable)((Iterable)it.getValue()));
                boolean $i$f$sortedBy = false;
                List list6 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SchedulingEventModel s = (SchedulingEventModel)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(s.getStartTimestampUs());
                        s = (SchedulingEventModel)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(s.getStartTimestampUs()));
                    }
                });
                map.put((Integer)k, list6);
            }
        }

        private final ThreadState convertSchedulingState(TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState state) {
            ThreadState threadState;
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    threadState = ThreadState.RUNNABLE_CAPTURED;
                    break;
                }
                case 2: {
                    threadState = ThreadState.RUNNABLE_CAPTURED;
                    break;
                }
                case 3: {
                    threadState = ThreadState.DEAD_CAPTURED;
                    break;
                }
                case 4: {
                    threadState = ThreadState.SLEEPING_CAPTURED;
                    break;
                }
                case 5: {
                    threadState = ThreadState.WAITING_CAPTURED;
                    break;
                }
                case 6: {
                    threadState = ThreadState.RUNNABLE_CAPTURED;
                    break;
                }
                case 7: {
                    threadState = ThreadState.RUNNABLE_CAPTURED;
                    break;
                }
                default: {
                    threadState = ThreadState.UNKNOWN;
                }
            }
            return threadState;
        }

        /*
         * WARNING - void declaration
         */
        public final void addCpuCounters(@NotNull TraceProcessor.CpuCoreCountersResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.cpuCoresCount = Math.max(this.cpuCoresCount, result.getNumCores());
            List list = result.getCountersPerCoreList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.countersPerCoreList");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                TraceProcessor.CpuCoreCountersResult.CountersPerCore countersPerCore = (TraceProcessor.CpuCoreCountersResult.CountersPerCore)element$iv;
                boolean bl = false;
                Map<Integer, List<CounterModel>> map = this.coreToCpuCounters;
                Integer n = countersPerCore.getCpu();
                List list2 = countersPerCore.getCounterList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"countersPerCore.counterList");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string;
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    void counter;
                    TraceProcessor.Counter counter2 = (TraceProcessor.Counter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)counter.getName(), (String)"counter.name");
                    List list3 = counter.getValueList();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"counter.valueList");
                    Iterable iterable2 = list3;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    void var24_24 = $this$associate$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map2 = destination$iv$iv2;
                        TraceProcessor.CounterValue it = (TraceProcessor.CounterValue)element$iv$iv;
                        boolean bl3 = false;
                        Pair pair = TuplesKt.to((Object)this.convertToUs(it.getTimestampNanoseconds()), (Object)it.getValue());
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                    SortedMap sortedMap = MapsKt.toSortedMap((Map)destination$iv$iv2);
                    String string2 = string;
                    collection.add(new CounterModel(string2, sortedMap));
                }
                List list4 = (List)destination$iv$iv;
                map.put(n, list4);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addProcessCounters(@NotNull TraceProcessor.ProcessCountersResult counters) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)counters, (String)"counters");
            Map<Integer, List<CounterModel>> map = this.processToCounters;
            Integer n = (int)counters.getProcessId();
            List list = counters.getCounterList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"counters.counterList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                void counter;
                TraceProcessor.Counter counter2 = (TraceProcessor.Counter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)counter.getName(), (String)"counter.name");
                List list2 = counter.getValueList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"counter.valueList");
                Iterable iterable2 = list2;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var17_17 = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv2;
                    TraceProcessor.CounterValue it = (TraceProcessor.CounterValue)element$iv$iv;
                    boolean bl2 = false;
                    Pair pair = TuplesKt.to((Object)this.convertToUs(it.getTimestampNanoseconds()), (Object)it.getValue());
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                SortedMap sortedMap = MapsKt.toSortedMap((Map)destination$iv$iv2);
                String string2 = string;
                collection.add(new CounterModel(string2, sortedMap));
            }
            List list3 = (List)destination$iv$iv;
            map.put(n, list3);
        }

        /*
         * WARNING - void declaration
         */
        public final void addPowerCounters(@NotNull TraceProcessor.PowerCounterTracksResult counters) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)counters, (String)"counters");
            List list = counters.getCounterList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"counters.counterList");
            Iterable iterable = list;
            List<CounterModel> list2 = this.powerCounters;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                void counter;
                TraceProcessor.Counter counter2 = (TraceProcessor.Counter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)counter.getName(), (String)"counter.name");
                List list3 = counter.getValueList();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"counter.valueList");
                Iterable iterable2 = list3;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var15_16 = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv2;
                    TraceProcessor.CounterValue it = (TraceProcessor.CounterValue)element$iv$iv;
                    boolean bl2 = false;
                    Pair pair = TuplesKt.to((Object)this.convertToUs(it.getTimestampNanoseconds()), (Object)it.getValue());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                SortedMap sortedMap = MapsKt.toSortedMap((Map)destination$iv$iv2);
                String string2 = string;
                collection.add(new CounterModel(string2, sortedMap));
            }
            list2.addAll((List)destination$iv$iv);
        }

        public final void addAndroidFrameEvents(@NotNull TraceProcessor.AndroidFrameEventsResult frameEventsResult) {
            Intrinsics.checkNotNullParameter((Object)frameEventsResult, (String)"frameEventsResult");
            List list = frameEventsResult.getLayerList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"frameEventsResult.layerList");
            this.androidFrameLayers.addAll(list);
        }

        /*
         * WARNING - void declaration
         */
        public final void addAndroidFrameTimelineEvents(@NotNull TraceProcessor.AndroidFrameTimelineResult frameTimelineResult) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)frameTimelineResult, (String)"frameTimelineResult");
            List list = frameTimelineResult.getExpectedSliceList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"frameTimelineResult.expectedSliceList");
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                TraceProcessor.AndroidFrameTimelineResult.ExpectedSlice expectedSlice = (TraceProcessor.AndroidFrameTimelineResult.ExpectedSlice)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getSurfaceFrameToken(), element$iv$iv);
            }
            Map expectedSlicesBySurfaceFrame = destination$iv$iv;
            List list2 = frameTimelineResult.getActualSliceList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"frameTimelineResult.actualSliceList");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TraceProcessor.AndroidFrameTimelineResult.ExpectedSlice expectedSlice;
                TraceProcessor.AndroidFrameTimelineResult.ActualSlice actualSlice = (TraceProcessor.AndroidFrameTimelineResult.ActualSlice)element$iv;
                boolean bl = false;
                if ((TraceProcessor.AndroidFrameTimelineResult.ExpectedSlice)expectedSlicesBySurfaceFrame.get(actualSlice.getSurfaceFrameToken()) == null) continue;
                boolean bl2 = false;
                long expectedEndUs = this.convertToUs(expectedSlice.getTimestampNanoseconds() + expectedSlice.getDurationNanoseconds());
                long actualEndUs = this.convertToUs(actualSlice.getTimestampNanoseconds() + actualSlice.getDurationNanoseconds());
                long l = expectedSlice.getDisplayFrameToken();
                long l2 = expectedSlice.getSurfaceFrameToken();
                long l3 = this.convertToUs(expectedSlice.getTimestampNanoseconds());
                String string = actualSlice.getLayerName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"actualSlice.layerName");
                String string2 = actualSlice.getPresentType();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"actualSlice.presentType");
                PerfettoTrace.FrameTimelineEvent.PresentType presentType = this.parsePresentType(string2);
                String string3 = actualSlice.getJankType();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"actualSlice.jankType");
                this.androidFrameTimelineEvents.add(new AndroidFrameTimelineEvent(l, l2, l3, expectedEndUs, actualEndUs, string, presentType, this.parseAppJankType(string3), actualSlice.getOnTimeFinish(), actualSlice.getGpuComposition(), actualSlice.getLayoutDepth()));
            }
            List<AndroidFrameTimelineEvent> $this$sortBy$iv = this.androidFrameTimelineEvents;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        AndroidFrameTimelineEvent it = (AndroidFrameTimelineEvent)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getExpectedStartUs());
                        it = (AndroidFrameTimelineEvent)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getExpectedStartUs()));
                    }
                });
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void indexSurfaceflingerFrameTimelineEvents(@NotNull TraceProcessor.AndroidFrameTimelineResult frameTimelineResult) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Intrinsics.checkNotNullParameter((Object)frameTimelineResult, (String)"frameTimelineResult");
            List list = frameTimelineResult.getActualSliceList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"frameTimelineResult.actualSliceList");
            Iterable iterable = list;
            Builder builder = this;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void var5_6 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                TraceProcessor.AndroidFrameTimelineResult.ActualSlice it = (TraceProcessor.AndroidFrameTimelineResult.ActualSlice)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getDisplayFrameToken(), (Object)(it.getTimestampNanoseconds() + it.getDurationNanoseconds()));
                map.put(pair.getFirst(), pair.getSecond());
            }
            builder.surfaceflingerDisplayTokenToEndNs = destination$iv$iv;
        }

        @NotNull
        public final TraceProcessorModel build() {
            return new TraceProcessorModel(this);
        }

        private final long convertToUs(long tsNanos) {
            return TimeUnit.NANOSECONDS.toMicros(tsNanos);
        }

        private final PerfettoTrace.FrameTimelineEvent.PresentType parsePresentType(String presetTypeStr) {
            PerfettoTrace.FrameTimelineEvent.PresentType presentType;
            switch (presetTypeStr) {
                case "On-time Present": {
                    presentType = PerfettoTrace.FrameTimelineEvent.PresentType.PRESENT_ON_TIME;
                    break;
                }
                case "Late Present": {
                    presentType = PerfettoTrace.FrameTimelineEvent.PresentType.PRESENT_LATE;
                    break;
                }
                case "Early Present": {
                    presentType = PerfettoTrace.FrameTimelineEvent.PresentType.PRESENT_EARLY;
                    break;
                }
                case "Dropped Frame": {
                    presentType = PerfettoTrace.FrameTimelineEvent.PresentType.PRESENT_DROPPED;
                    break;
                }
                case "Unknown Present": {
                    presentType = PerfettoTrace.FrameTimelineEvent.PresentType.PRESENT_UNKNOWN;
                    break;
                }
                default: {
                    presentType = PerfettoTrace.FrameTimelineEvent.PresentType.PRESENT_UNSPECIFIED;
                }
            }
            return presentType;
        }

        private final PerfettoTrace.FrameTimelineEvent.JankType parseAppJankType(String jankTypeStr) {
            String[] stringArray = new String[]{", "};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)jankTypeStr, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                switch (it) {
                    case "None": {
                        return PerfettoTrace.FrameTimelineEvent.JankType.JANK_NONE;
                    }
                    case "App Deadline Missed": {
                        return PerfettoTrace.FrameTimelineEvent.JankType.JANK_APP_DEADLINE_MISSED;
                    }
                    case "Buffer Stuffing": {
                        return PerfettoTrace.FrameTimelineEvent.JankType.JANK_BUFFER_STUFFING;
                    }
                    case "Unknown Jank": {
                        return PerfettoTrace.FrameTimelineEvent.JankType.JANK_UNKNOWN;
                    }
                }
            }
            return PerfettoTrace.FrameTimelineEvent.JankType.JANK_UNSPECIFIED;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState.values().length];
                nArray[TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState.RUNNABLE.ordinal()] = 1;
                nArray[TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState.RUNNABLE_PREEMPTED.ordinal()] = 2;
                nArray[TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState.DEAD.ordinal()] = 3;
                nArray[TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState.SLEEPING.ordinal()] = 4;
                nArray[TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState.SLEEPING_UNINTERRUPTIBLE.ordinal()] = 5;
                nArray[TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState.WAKING.ordinal()] = 6;
                nArray[TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState.WAKE_KILL.ordinal()] = 7;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

