/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeFunctionClassifier;
import org.jetbrains.annotations.NotNull;

public class NativeCallStackSet
extends ClassifierSet {
    private final int myCallstackDepth;
    private final Memory.AllocationStack.StackFrame myStackFrame;

    @NotNull
    public static Classifier createDefaultClassifier() {
        return NativeFunctionClassifier.of(0);
    }

    public NativeCallStackSet(@NotNull Memory.AllocationStack.StackFrame stackFrame, int callstackDepth) {
        super(stackFrame.getMethodName());
        this.myCallstackDepth = callstackDepth;
        this.myStackFrame = stackFrame;
    }

    public String getFileName() {
        return this.myStackFrame.getFileName();
    }

    public int getLineNumber() {
        return this.myStackFrame.getLineNumber();
    }

    @NotNull
    public String getModuleName() {
        return this.myStackFrame.getModuleName();
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        return NativeFunctionClassifier.of(this.myCallstackDepth);
    }
}

