/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.MethodSet;
import com.google.common.base.Strings;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;", "captureObject", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "methodInfo", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "callstackDepth", "", "(Lcom/android/tools/profilers/memory/adapters/CaptureObject;Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;I)V", "className", "", "getClassName", "()Ljava/lang/String;", "methodName", "getMethodName", "createSubClassifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "Companion", "MethodSetInfo", "intellij.android.profilers"})
public final class MethodSet
extends ClassifierSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CaptureObject captureObject;
    @NotNull
    private final MethodSetInfo methodInfo;
    private final int callstackDepth;

    public MethodSet(@NotNull CaptureObject captureObject, final @NotNull MethodSetInfo methodInfo, int callstackDepth) {
        Intrinsics.checkNotNullParameter((Object)captureObject, (String)"captureObject");
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        super((Function0<String>)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return methodInfo.getName();
            }
        }));
        this.captureObject = captureObject;
        this.methodInfo = methodInfo;
        this.callstackDepth = callstackDepth;
    }

    @NotNull
    public final String getClassName() {
        return this.methodInfo.getClassName();
    }

    @NotNull
    public final String getMethodName() {
        return this.methodInfo.getMethodName();
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        return MethodSet.Companion.methodClassifier(this.captureObject, this.callstackDepth);
    }

    @JvmStatic
    @NotNull
    public static final Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        return Companion.createDefaultClassifier(captureObject);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "methodName", "getMethodName", "name", "getName", "ById", "ByName", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo$ById;", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo$ByName;", "intellij.android.profilers"})
    public static abstract class MethodSetInfo {
        private MethodSetInfo() {
        }

        @NotNull
        public abstract String getClassName();

        @NotNull
        public abstract String getMethodName();

        @NotNull
        public final String getName() {
            return this.getMethodName() + "()" + (String)(Strings.isNullOrEmpty((String)this.getClassName()) ? "" : " (" + this.getClassName() + ")");
        }

        public /* synthetic */ MethodSetInfo(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo$ByName;", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "className", "", "methodName", "(Ljava/lang/String;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getMethodName", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.android.profilers"})
        public static final class ByName
        extends MethodSetInfo {
            @NotNull
            private final String className;
            @NotNull
            private final String methodName;

            public ByName(@NotNull String className, @NotNull String methodName) {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                super(null);
                this.className = className;
                this.methodName = methodName;
            }

            @Override
            @NotNull
            public String getClassName() {
                return this.className;
            }

            @Override
            @NotNull
            public String getMethodName() {
                return this.methodName;
            }

            @NotNull
            public final String component1() {
                return this.getClassName();
            }

            @NotNull
            public final String component2() {
                return this.getMethodName();
            }

            @NotNull
            public final ByName copy(@NotNull String className, @NotNull String methodName) {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                return new ByName(className, methodName);
            }

            public static /* synthetic */ ByName copy$default(ByName byName, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = byName.getClassName();
                }
                if ((n & 2) != 0) {
                    string2 = byName.getMethodName();
                }
                return byName.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "ByName(className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ")";
            }

            public int hashCode() {
                int result = this.getClassName().hashCode();
                result = result * 31 + this.getMethodName().hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ByName)) {
                    return false;
                }
                ByName byName = (ByName)other;
                if (!Intrinsics.areEqual((Object)this.getClassName(), (Object)byName.getClassName())) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.getMethodName(), (Object)byName.getMethodName());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R7\u0010\u0007\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\t0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\n \n*\u0004\u0018\u00010\t0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo$ById;", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "captureObject", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "methodId", "", "(Lcom/android/tools/profilers/memory/adapters/CaptureObject;J)V", "classAndMethodName", "Lkotlin/Pair;", "", "kotlin.jvm.PlatformType", "getClassAndMethodName", "()Lkotlin/Pair;", "classAndMethodName$delegate", "Lkotlin/Lazy;", "className", "getClassName", "()Ljava/lang/String;", "methodName", "getMethodName", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.android.profilers"})
        public static final class ById
        extends MethodSetInfo {
            @NotNull
            private final CaptureObject captureObject;
            private final long methodId;
            @NotNull
            private final Lazy classAndMethodName$delegate;

            public ById(@NotNull CaptureObject captureObject, long methodId) {
                Intrinsics.checkNotNullParameter((Object)captureObject, (String)"captureObject");
                super(null);
                this.captureObject = captureObject;
                this.methodId = methodId;
                this.classAndMethodName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pair<? extends String, ? extends String>>(this){
                    final /* synthetic */ ById this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Pair<String, String> invoke() {
                        Memory.AllocationStack.StackFrame stackFrame = ById.access$getCaptureObject$p(this.this$0).getStackFrame(ById.access$getMethodId$p(this.this$0));
                        Intrinsics.checkNotNull((Object)stackFrame);
                        Memory.AllocationStack.StackFrame frameInfo = stackFrame;
                        return TuplesKt.to((Object)frameInfo.getClassName(), (Object)frameInfo.getMethodName());
                    }
                }));
            }

            @Override
            public String getClassName() {
                return (String)this.getClassAndMethodName().getFirst();
            }

            @Override
            public String getMethodName() {
                return (String)this.getClassAndMethodName().getSecond();
            }

            private final Pair<String, String> getClassAndMethodName() {
                Lazy lazy = this.classAndMethodName$delegate;
                return (Pair)lazy.getValue();
            }

            private final CaptureObject component1() {
                return this.captureObject;
            }

            private final long component2() {
                return this.methodId;
            }

            @NotNull
            public final ById copy(@NotNull CaptureObject captureObject, long methodId) {
                Intrinsics.checkNotNullParameter((Object)captureObject, (String)"captureObject");
                return new ById(captureObject, methodId);
            }

            public static /* synthetic */ ById copy$default(ById byId, CaptureObject captureObject, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    captureObject = byId.captureObject;
                }
                if ((n & 2) != 0) {
                    l = byId.methodId;
                }
                return byId.copy(captureObject, l);
            }

            @NotNull
            public String toString() {
                return "ById(captureObject=" + this.captureObject + ", methodId=" + this.methodId + ")";
            }

            public int hashCode() {
                int result = this.captureObject.hashCode();
                result = result * 31 + Long.hashCode(this.methodId);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ById)) {
                    return false;
                }
                ById byId = (ById)other;
                if (!Intrinsics.areEqual((Object)this.captureObject, (Object)byId.captureObject)) {
                    return false;
                }
                return this.methodId == byId.methodId;
            }

            public static final /* synthetic */ CaptureObject access$getCaptureObject$p(ById $this) {
                return $this.captureObject;
            }

            public static final /* synthetic */ long access$getMethodId$p(ById $this) {
                return $this.methodId;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J&\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$Companion;", "", "()V", "createDefaultClassifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "captureObject", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "getMethodInfo", "Lkotlin/Function1;", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "Lcom/android/tools/profilers/memory/adapters/classifiers/MethodSet$MethodSetInfo;", "depth", "", "methodClassifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier$Join;", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
            Intrinsics.checkNotNullParameter((Object)captureObject, (String)"captureObject");
            return this.methodClassifier(captureObject, 0);
        }

        private final Classifier.Join<MethodSetInfo> methodClassifier(CaptureObject captureObject, int depth) {
            return new Classifier.Join<MethodSetInfo>(this.getMethodInfo(captureObject, depth), (Function1)new Function1<MethodSetInfo, ClassifierSet>(captureObject, depth){
                final /* synthetic */ CaptureObject $captureObject;
                final /* synthetic */ int $depth;
                {
                    this.$captureObject = $captureObject;
                    this.$depth = $depth;
                    super(1);
                }

                @NotNull
                public final ClassifierSet invoke(@NotNull MethodSetInfo it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new MethodSet(this.$captureObject, it, this.$depth + 1);
                }
            }, Classifier.Companion.of(methodClassifier.2.INSTANCE, methodClassifier.3.INSTANCE));
        }

        private final Function1<InstanceObject, MethodSetInfo> getMethodInfo(CaptureObject captureObject, int depth) {
            return (Function1)new Function1<InstanceObject, MethodSetInfo>(depth, captureObject){
                final /* synthetic */ int $depth;
                final /* synthetic */ CaptureObject $captureObject;
                {
                    this.$depth = $depth;
                    this.$captureObject = $captureObject;
                    super(1);
                }

                @Nullable
                public final MethodSetInfo invoke(@NotNull InstanceObject inst) {
                    MethodSetInfo methodSetInfo;
                    Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
                    int stackDepth = inst.getCallStackDepth();
                    if (stackDepth <= 0 || this.$depth >= stackDepth) {
                        methodSetInfo = null;
                    } else {
                        int frameIndex = stackDepth - this.$depth - 1;
                        Memory.AllocationStack stack = inst.getAllocationCallStack();
                        if (stack == null) {
                            CodeLocation location = inst.getAllocationCodeLocations().get(frameIndex);
                            String string = Strings.nullToEmpty((String)location.getClassName());
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nullToEmpty(location.className)");
                            String string2 = Strings.nullToEmpty((String)location.getMethodName());
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nullToEmpty(location.methodName)");
                            methodSetInfo = new MethodSetInfo.ByName(string, string2);
                        } else if (stack.getFrameCase() == Memory.AllocationStack.FrameCase.FULL_STACK) {
                            Memory.AllocationStack.StackFrame stackFrame = stack.getFullStack().getFrames(frameIndex);
                            String string = stackFrame.getClassName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stackFrame.className");
                            String string3 = stackFrame.getMethodName();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"stackFrame.methodName");
                            methodSetInfo = new MethodSetInfo.ByName(string, string3);
                        } else if (stack.getFrameCase() == Memory.AllocationStack.FrameCase.ENCODED_STACK) {
                            Memory.AllocationStack.EncodedFrame smallFrame = stack.getEncodedStack().getFrames(frameIndex);
                            methodSetInfo = new MethodSetInfo.ById(this.$captureObject, smallFrame.getMethodId());
                        } else {
                            throw new UnsupportedOperationException();
                        }
                    }
                    return methodSetInfo;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

