/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.CachedFunction;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\b\u0007\b&\u0018\u0000 \u0088\u00012\u00020\u0001:\b\u0088\u0001\u0089\u0001\u008a\u0001\u008b\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010R\u001a\u0002072\u0006\u0010S\u001a\u00020 J\u000e\u0010T\u001a\u0002072\u0006\u0010S\u001a\u00020 J\u001e\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u0002072\u0006\u0010Z\u001a\u000207J \u0010[\u001a\u00020\\2\u0006\u0010S\u001a\u00020 2\u0006\u0010]\u001a\u0002072\u0006\u0010^\u001a\u00020_H\u0002J\u0018\u0010`\u001a\u0002072\u0006\u0010S\u001a\u00020 2\u0006\u0010^\u001a\u00020_H\u0002J\u0006\u0010a\u001a\u00020VJ\b\u0010b\u001a\u00020VH\u0004J\u0010\u0010c\u001a\u00020\u00182\u0006\u0010W\u001a\u00020/H\u0002J\b\u0010d\u001a\u00020eH$J\b\u0010f\u001a\u00020CH\u0002J\u0016\u0010g\u001a\u00020V2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020 0iH\u0002J\u001c\u0010j\u001a\u0004\u0018\u00010\u00002\u0012\u0010k\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002070lJ\u0010\u0010m\u001a\u0004\u0018\u00010\u00002\u0006\u0010n\u001a\u00020 J\u000e\u0010o\u001a\u0002072\u0006\u0010S\u001a\u00020 J\u000e\u0010p\u001a\u00020\u00182\u0006\u0010W\u001a\u00020/J\b\u0010q\u001a\u00020\u0003H\u0016J<\u0010r\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0012\u0010s\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002070l2\u0018\u0010t\u001a\u0014\u0012\u0004\u0012\u00020u\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0lH\u0002J\u0006\u0010v\u001a\u000207J\u0014\u0010w\u001a\u0002072\f\u0010x\u001a\b\u0012\u0004\u0012\u00020 0yJ\b\u0010z\u001a\u00020{H\u0002J\b\u0010|\u001a\u00020VH\u0002J\u0014\u0010}\u001a\u0002072\f\u0010x\u001a\b\u0012\u0004\u0012\u00020 0yJ\u0014\u0010~\u001a\u0002072\f\u0010x\u001a\b\u0012\u0004\u0012\u00020 0yJ\u000e\u0010\u007f\u001a\u0002072\u0006\u0010S\u001a\u00020 J\u000f\u0010\u0080\u0001\u001a\u0002072\u0006\u0010S\u001a\u00020 J\u000f\u0010\u0081\u0001\u001a\u0002072\u0006\u0010S\u001a\u00020 JE\u0010\u0082\u0001\u001a\u0005\u0018\u0001H\u0083\u0001\"\u0005\b\u0000\u0010\u0084\u0001\"\u0005\b\u0001\u0010\u0083\u0001*\n\u0012\u0005\u0012\u0003H\u0084\u00010\u0085\u00012\u0017\u0010\u0086\u0001\u001a\u0012\u0012\u0005\u0012\u0003H\u0084\u0001\u0012\u0007\u0012\u0005\u0018\u0001H\u0083\u00010lH\u0002\u00a2\u0006\u0003\u0010\u0087\u0001R\u001b\u0010\b\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0011R$\u0010%\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0018@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001b\"\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\"R\u001e\u0010+\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001bR*\u0010-\u001a\u001e\u0012\f\u0012\n 0*\u0004\u0018\u00010/0/\u0012\f\u0012\n 0*\u0004\u0018\u00010\u00180\u00180.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001bR\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\"R\u000e\u00105\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b6\u00108R\u0011\u00109\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b9\u00108R$\u0010:\u001a\u0002072\u0006\u0010\r\u001a\u000207@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00108\"\u0004\b;\u0010<R\u0012\u0010=\u001a\u0002078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010>\u001a\u0002078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010?\u001a\b\u0012\u0004\u0012\u00020 0\u001f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\"R\u000e\u0010A\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010D\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010\nR\u001e\u0010F\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u0011R\u0011\u0010H\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u001bR\u001e\u0010J\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u001bR\u0011\u0010L\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u0011R\u0014\u0010N\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u0011R\u001e\u0010P\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\u0011\u00a8\u0006\u008c\u0001"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;", "Lcom/android/tools/profilers/memory/adapters/MemoryObject;", "name", "", "(Ljava/lang/String;)V", "supplyName", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "_name", "get_name", "()Ljava/lang/String;", "_name$delegate", "Lkotlin/Lazy;", "<set-?>", "", "allocationSize", "getAllocationSize", "()J", "childrenClassifierSets", "", "getChildrenClassifierSets", "()Ljava/util/List;", "deallocationSize", "getDeallocationSize", "", "deltaAllocationCount", "getDeltaAllocationCount", "()I", "deltaDeallocationCount", "getDeltaDeallocationCount", "deltaInstanceStream", "Ljava/util/stream/Stream;", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "getDeltaInstanceStream", "()Ljava/util/stream/Stream;", "deltaShallowSize", "getDeltaShallowSize", "filterMatchCount", "getFilterMatchCount", "setFilterMatchCount", "(I)V", "filterMatches", "getFilterMatches", "filteredObjectSetCount", "getFilteredObjectSetCount", "instanceFilterMatchCounter", "Lcom/android/tools/profilers/CachedFunction;", "Lcom/android/tools/profilers/memory/adapters/instancefilters/CaptureObjectInstanceFilter;", "kotlin.jvm.PlatformType", "instancesCount", "getInstancesCount", "instancesStream", "getInstancesStream", "instancesWithStackInfoCount", "isEmpty", "", "()Z", "isFiltered", "isMatched", "setMatched", "(Z)V", "myIsFiltered", "needsRefiltering", "snapshotInstanceStream", "getSnapshotInstanceStream", "snapshotObjectCount", "state", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State;", "stringForMatching", "getStringForMatching", "totalNativeSize", "getTotalNativeSize", "totalObjectCount", "getTotalObjectCount", "totalObjectSetCount", "getTotalObjectSetCount", "totalRemainingSize", "getTotalRemainingSize", "totalRetainedSize", "getTotalRetainedSize", "totalShallowSize", "getTotalShallowSize", "addDeltaInstanceObject", "instanceObject", "addSnapshotInstanceObject", "applyFilter", "", "filter", "Lcom/android/tools/adtui/model/filter/Filter;", "hasMatchedAncestor", "filterChanged", "changeDeltaInstanceInformation", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$DeltaChange;", "isAllocation", "op", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$SetOperation;", "changeSnapshotInstanceObject", "clearClassifierSets", "coalesce", "countInstanceFilterMatch", "createSubClassifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "ensurePartitioned", "filterOutInstances", "remainders", "", "findClassifierSet", "test", "Lkotlin/Function1;", "findContainingClassifierSet", "target", "freeDeltaInstanceObject", "getInstanceFilterMatchCount", "getName", "getStreamOf", "condition", "extract", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "hasStackInfo", "immediateInstancesOverlapWith", "targetSet", "", "initState", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Delayed;", "invalidateRetainedSizeCache", "isSupersetOf", "overlapsWith", "removeAddedDeltaInstanceObject", "removeFreedDeltaInstanceObject", "removeSnapshotInstanceObject", "firstNonNullResult", "A", "T", "", "f", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "DeltaChange", "SetOperation", "State", "intellij.android.profilers"})
public abstract class ClassifierSet
implements MemoryObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy _name$delegate;
    @NotNull
    private State state;
    private int totalObjectSetCount;
    private int filteredObjectSetCount;
    private int snapshotObjectCount;
    private int deltaAllocationCount;
    private int deltaDeallocationCount;
    private long allocationSize;
    private long deallocationSize;
    private long totalNativeSize;
    private long totalShallowSize;
    private long deltaShallowSize;
    private int instancesWithStackInfoCount;
    private int filterMatchCount;
    @NotNull
    private final CachedFunction<CaptureObjectInstanceFilter, Integer> instanceFilterMatchCounter;
    private boolean isMatched;
    @JvmField
    protected boolean needsRefiltering;
    @JvmField
    protected boolean myIsFiltered;

    public ClassifierSet(@NotNull Function0<String> supplyName) {
        Intrinsics.checkNotNullParameter(supplyName, (String)"supplyName");
        this._name$delegate = LazyKt.lazy(supplyName);
        this.state = this.initState();
        this.instanceFilterMatchCounter = new CachedFunction(new IdentityHashMap(), (Function1)new Function1<CaptureObjectInstanceFilter, Integer>((Object)this){

            @NotNull
            public final Integer invoke(@NotNull CaptureObjectInstanceFilter p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ClassifierSet.access$countInstanceFilterMatch((ClassifierSet)this.receiver, p0);
            }
        });
    }

    public ClassifierSet(final @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this((Function0<String>)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return name;
            }
        }));
    }

    private final String get_name() {
        Lazy lazy = this._name$delegate;
        return (String)lazy.getValue();
    }

    public final int getTotalObjectSetCount() {
        return this.totalObjectSetCount;
    }

    public final int getFilteredObjectSetCount() {
        return this.filteredObjectSetCount;
    }

    public final int getDeltaAllocationCount() {
        return this.deltaAllocationCount;
    }

    public final int getDeltaDeallocationCount() {
        return this.deltaDeallocationCount;
    }

    public final long getAllocationSize() {
        return this.allocationSize;
    }

    public final long getDeallocationSize() {
        return this.deallocationSize;
    }

    public final long getTotalNativeSize() {
        return this.totalNativeSize;
    }

    public final long getTotalShallowSize() {
        return this.totalShallowSize;
    }

    /*
     * WARNING - void declaration
     */
    public long getTotalRetainedSize() {
        long l;
        State s = this.state;
        if (s instanceof State.Coalesced) {
            if (((State.Coalesced)s).getRetainedSize() == -1L) {
                void $this$fold$iv;
                Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)((State.Coalesced)s).getSnapshotInstances()), (Sequence)CollectionsKt.asSequence((Iterable)((State.Coalesced)s).getDeltaInstances())), (Function1)totalRetainedSize.maxRetainedSizeByClass.1.INSTANCE));
                long initial$iv = 0L;
                boolean $i$f$fold22 = false;
                long accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void entry2;
                    ClassDb.ClassEntry classEntry = (ClassDb.ClassEntry)element$iv;
                    long sum = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = entry2.getRetainedSize() == -1L || sum == Long.MAX_VALUE ? Long.MAX_VALUE : sum + entry2.getRetainedSize();
                }
                long maxRetainedSizeByClass2 = accumulator$iv;
                Sequence $i$f$fold22 = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)((State.Coalesced)s).getSnapshotInstances()), (Sequence)CollectionsKt.asSequence((Iterable)((State.Coalesced)s).getDeltaInstances()));
                long l2 = 0L;
                for (ClassDb.ClassEntry classEntry : $i$f$fold22) {
                    void it;
                    InstanceObject sum = (InstanceObject)((Object)classEntry);
                    long l3 = l2;
                    boolean bl = false;
                    long l4 = ClassifierSet.Companion.validOrZero(it.getRetainedSize());
                    l2 = l3 + l4;
                }
                long maxRetainedSizeByInstances = l2;
                long maxRetainedSize = Math.min(maxRetainedSizeByClass2, maxRetainedSizeByInstances);
                ((State.Coalesced)s).setRetainedSize(maxRetainedSize);
                l = maxRetainedSize;
            } else {
                l = ((State.Coalesced)s).getRetainedSize();
            }
        } else if (s instanceof State.Partitioned) {
            Iterable iterable = ((State.Partitioned)s).getClassifier().getAllClassifierSets();
            long l5 = 0L;
            for (Object t : iterable) {
                void it;
                ClassifierSet initial$iv = (ClassifierSet)t;
                long l6 = l5;
                boolean bl = false;
                long l7 = it.getTotalRetainedSize();
                l5 = l6 + l7;
            }
            l = l5;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    public final long getDeltaShallowSize() {
        return this.deltaShallowSize;
    }

    public final int getFilterMatchCount() {
        return this.filterMatchCount;
    }

    protected final void setFilterMatchCount(int n) {
        this.filterMatchCount = n;
    }

    public final boolean isMatched() {
        return this.isMatched;
    }

    protected final void setMatched(boolean bl) {
        this.isMatched = bl;
    }

    public final boolean isEmpty() {
        return this.snapshotObjectCount == 0 && this.deltaAllocationCount == 0 && this.deltaDeallocationCount == 0;
    }

    public final int getTotalObjectCount() {
        return this.snapshotObjectCount + this.deltaAllocationCount - this.deltaDeallocationCount;
    }

    public final long getTotalRemainingSize() {
        return this.allocationSize - this.deallocationSize;
    }

    public final int getInstancesCount() {
        return (int)this.getInstancesStream().count();
    }

    @NotNull
    public final Stream<InstanceObject> getInstancesStream() {
        return this.getStreamOf((Function1<? super ClassifierSet, Boolean>)((Function1)instancesStream.1.INSTANCE), (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)((Function1)instancesStream.2.INSTANCE));
    }

    @NotNull
    protected final Stream<InstanceObject> getDeltaInstanceStream() {
        return this.getStreamOf((Function1<? super ClassifierSet, Boolean>)((Function1)deltaInstanceStream.1.INSTANCE), (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)((Function1)deltaInstanceStream.2.INSTANCE));
    }

    @NotNull
    protected final Stream<InstanceObject> getSnapshotInstanceStream() {
        return this.getStreamOf((Function1<? super ClassifierSet, Boolean>)((Function1)snapshotInstanceStream.1.INSTANCE), (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)((Function1)snapshotInstanceStream.2.INSTANCE));
    }

    @NotNull
    public final Stream<InstanceObject> getFilterMatches() {
        return this.getStreamOf((Function1<? super ClassifierSet, Boolean>)((Function1)filterMatches.1.INSTANCE), (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)((Function1)filterMatches.2.INSTANCE));
    }

    @NotNull
    public final List<ClassifierSet> getChildrenClassifierSets() {
        List<ClassifierSet> list;
        State s = this.ensurePartitioned();
        if (s instanceof State.Coalesced) {
            list = CollectionsKt.emptyList();
        } else if (s instanceof State.Partitioned) {
            list = ((State.Partitioned)s).getClassifier().getFilteredClassifierSets();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    public final boolean isFiltered() {
        return this.isEmpty() || this.myIsFiltered;
    }

    @NotNull
    public String getStringForMatching() {
        return this.get_name();
    }

    @Override
    @NotNull
    public String getName() {
        return this.get_name();
    }

    private final void invalidateRetainedSizeCache() {
        State s = this.state;
        if (s instanceof State.Coalesced) {
            ((State.Coalesced)s).setRetainedSize(-1L);
        }
    }

    private final State ensurePartitioned() {
        State state;
        State it = state = this.state.forced();
        boolean bl = false;
        this.state = it;
        return state;
    }

    protected final void coalesce() {
        this.state = this.state.retracted((Function0<? extends Classifier>)((Function0)new Function0<Classifier>((Object)this){

            @NotNull
            public final Classifier invoke() {
                return ((ClassifierSet)this.receiver).createSubClassifier();
            }
        }));
    }

    public final int getInstanceFilterMatchCount(@NotNull CaptureObjectInstanceFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Integer n = this.instanceFilterMatchCounter.invoke(filter);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"instanceFilterMatchCounter.invoke(filter)");
        return ((Number)n).intValue();
    }

    public final boolean addSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeSnapshotInstanceObject(instanceObject, SetOperation.ADD);
    }

    public final boolean removeSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeSnapshotInstanceObject(instanceObject, SetOperation.REMOVE);
    }

    private final boolean changeSnapshotInstanceObject(InstanceObject instanceObject, SetOperation op) {
        boolean changed = false;
        State s = this.state;
        if (s instanceof State.Partitioned) {
            ClassifierSet classifierSet = ((State.Partitioned)s).getClassifier().getClassifierSet(instanceObject, op == SetOperation.ADD);
            changed = classifierSet != null && classifierSet.changeSnapshotInstanceObject(instanceObject, op);
        } else if (s instanceof State.Coalesced) {
            changed = op == SetOperation.ADD != ((State.Coalesced)s).getSnapshotInstances().contains(instanceObject);
            op.getInvoke().invoke(((State.Coalesced)s).getSnapshotInstances(), (Object)instanceObject);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (changed) {
            this.snapshotObjectCount += op.getCountChange();
            this.totalNativeSize += (long)op.getCountChange() * ClassifierSet.Companion.validOrZero(instanceObject.getNativeSize());
            this.totalShallowSize += (long)op.getCountChange() * ClassifierSet.Companion.validOrZero(instanceObject.getShallowSize());
            this.invalidateRetainedSizeCache();
            if (!instanceObject.isCallStackEmpty()) {
                this.instancesWithStackInfoCount += op.getCountChange();
            }
            this.instanceFilterMatchCounter.invalidate();
            this.needsRefiltering = true;
        }
        return changed;
    }

    public final boolean addDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeDeltaInstanceInformation(instanceObject, true, SetOperation.ADD).getInstanceChanged();
    }

    public final boolean freeDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeDeltaInstanceInformation(instanceObject, false, SetOperation.ADD).getInstanceChanged();
    }

    public final boolean removeAddedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeDeltaInstanceInformation(instanceObject, true, SetOperation.REMOVE).getInstanceChanged();
    }

    public final boolean removeFreedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        Intrinsics.checkNotNullParameter((Object)instanceObject, (String)"instanceObject");
        return this.changeDeltaInstanceInformation(instanceObject, false, SetOperation.REMOVE).getInstanceChanged();
    }

    private final DeltaChange changeDeltaInstanceInformation(InstanceObject instanceObject, boolean isAllocation, SetOperation op) {
        DeltaChange change;
        Object object;
        State s = this.state;
        boolean bl = false;
        if (s instanceof State.Partitioned) {
            ClassifierSet classifierSet = ((State.Partitioned)s).getClassifier().getClassifierSet(instanceObject, op == SetOperation.ADD);
            object = classifierSet;
            if (object == null || (object = super.changeDeltaInstanceInformation(instanceObject, isAllocation, op)) == null) {
                object = DeltaChange.UNCHANGED;
            }
        } else if (s instanceof State.Coalesced && (op == SetOperation.ADD || !instanceObject.hasTimeData()) && op == SetOperation.ADD != ((State.Coalesced)s).getDeltaInstances().contains(instanceObject)) {
            op.getInvoke().invoke(((State.Coalesced)s).getDeltaInstances(), (Object)instanceObject);
            object = DeltaChange.INSTANCE_ADDED_OR_REMOVED;
        } else {
            object = DeltaChange.INSTANCE_MODIFIED;
        }
        if ((change = object).getCountsChanged()) {
            if (isAllocation) {
                this.deltaAllocationCount += op.getCountChange() * instanceObject.getInstanceCount();
                this.allocationSize += (long)(op.getCountChange() * instanceObject.getShallowSize());
            } else {
                this.deltaDeallocationCount += op.getCountChange() * instanceObject.getInstanceCount();
                this.deallocationSize += (long)(op.getCountChange() * instanceObject.getShallowSize());
            }
            int factor = op.getCountChange() * (isAllocation ? 1 : -1);
            long deltaNativeSize = (long)factor * ClassifierSet.Companion.validOrZero(instanceObject.getNativeSize());
            long deltaShallowSize = (long)factor * ClassifierSet.Companion.validOrZero(instanceObject.getShallowSize());
            long deltaRetainedSize = (long)factor * ClassifierSet.Companion.validOrZero(instanceObject.getRetainedSize());
            this.totalNativeSize += deltaNativeSize;
            this.deltaShallowSize += deltaShallowSize;
            this.totalShallowSize += deltaShallowSize;
            this.invalidateRetainedSizeCache();
            if (change.getInstanceChanged() && !instanceObject.isCallStackEmpty()) {
                this.instancesWithStackInfoCount += op.getCountChange();
                this.needsRefiltering = true;
            }
            if (change.getInstanceChanged()) {
                this.instanceFilterMatchCounter.invalidate();
            }
        }
        return change;
    }

    public final void clearClassifierSets() {
        this.state = this.initState().forced();
        this.snapshotObjectCount = 0;
        this.deltaAllocationCount = 0;
        this.deltaDeallocationCount = 0;
        this.allocationSize = 0L;
        this.deallocationSize = 0L;
        this.totalShallowSize = 0L;
        this.totalNativeSize = 0L;
        this.invalidateRetainedSizeCache();
        this.deltaShallowSize = 0L;
        this.instancesWithStackInfoCount = 0;
        this.totalObjectSetCount = 0;
        this.filteredObjectSetCount = 0;
        this.filterMatchCount = 0;
    }

    private final Stream<InstanceObject> getStreamOf(Function1<? super ClassifierSet, Boolean> condition, Function1<? super State.Coalesced, ? extends Stream<InstanceObject>> extract2) {
        Stream stream;
        State s = this.state;
        boolean bl = false;
        if (!((Boolean)condition.invoke((Object)this)).booleanValue()) {
            Stream stream2 = Stream.empty();
            stream = stream2;
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"empty()");
        } else if (s instanceof State.Coalesced) {
            stream = (Stream)extract2.invoke((Object)s);
        } else {
            Intrinsics.checkNotNull((Object)s, (String)"null cannot be cast to non-null type com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet.State.Partitioned");
            Stream stream3 = ((State.Partitioned)s).getClassifier().getAllClassifierSets().stream().flatMap(new Function(condition, extract2){
                final /* synthetic */ Function1<ClassifierSet, Boolean> $condition;
                final /* synthetic */ Function1<State.Coalesced, Stream<InstanceObject>> $extract;
                {
                    this.$condition = $condition;
                    this.$extract = $extract;
                }

                public final Stream<? extends InstanceObject> apply(ClassifierSet it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return ClassifierSet.access$getStreamOf(it, this.$condition, this.$extract);
                }
            });
            stream = stream3;
            Intrinsics.checkNotNullExpressionValue(stream3, (String)"condition: (ClassifierSe\u2026mOf(condition, extract) }");
        }
        return stream;
    }

    public final boolean hasStackInfo() {
        return this.instancesWithStackInfoCount > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ClassifierSet findContainingClassifierSet(@NotNull InstanceObject target) {
        ClassifierSet classifierSet;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        State s = this.state;
        boolean bl = false;
        if (s instanceof State.Coalesced && (((State.Coalesced)s).getSnapshotInstances().contains(target) || ((State.Coalesced)s).getDeltaInstances().contains(target))) {
            State state = this.ensurePartitioned();
            if (state instanceof State.Coalesced) {
                classifierSet = this;
                return classifierSet;
            } else {
                if (!(state instanceof State.Partitioned)) throw new NoWhenBranchMatchedException();
                classifierSet = (ClassifierSet)this.firstNonNullResult((Iterable)this.getChildrenClassifierSets(), (Function1)new Function1<ClassifierSet, ClassifierSet>(target){
                    final /* synthetic */ InstanceObject $target;
                    {
                        this.$target = $target;
                        super(1);
                    }

                    @Nullable
                    public final ClassifierSet invoke(@NotNull ClassifierSet it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.findContainingClassifierSet(this.$target);
                    }
                });
            }
            return classifierSet;
        } else {
            classifierSet = s instanceof State.Partitioned ? (ClassifierSet)this.firstNonNullResult((Iterable)this.getChildrenClassifierSets(), (Function1)new Function1<ClassifierSet, ClassifierSet>(target){
                final /* synthetic */ InstanceObject $target;
                {
                    this.$target = $target;
                    super(1);
                }

                @Nullable
                public final ClassifierSet invoke(@NotNull ClassifierSet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.findContainingClassifierSet(this.$target);
                }
            }) : null;
        }
        return classifierSet;
    }

    @Nullable
    public final ClassifierSet findClassifierSet(@NotNull Function1<? super ClassifierSet, Boolean> test) {
        Intrinsics.checkNotNullParameter(test, (String)"test");
        return (Boolean)test.invoke((Object)this) != false ? this : (ClassifierSet)this.firstNonNullResult((Iterable)this.getChildrenClassifierSets(), (Function1)new Function1<ClassifierSet, ClassifierSet>(test){
            final /* synthetic */ Function1<ClassifierSet, Boolean> $test;
            {
                this.$test = $test;
                super(1);
            }

            @Nullable
            public final ClassifierSet invoke(@NotNull ClassifierSet it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.findClassifierSet(this.$test);
            }
        });
    }

    private final <T, A> A firstNonNullResult(Iterable<? extends T> $this$firstNonNullResult, Function1<? super T, ? extends A> f) {
        A a;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence($this$firstNonNullResult), f);
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object p0 = element$iv = iterator.next();
                boolean bl = false;
                if (!Objects.nonNull(p0)) continue;
                a = (A)element$iv;
                break block1;
            }
            a = null;
        }
        return a;
    }

    public final boolean isSupersetOf(@NotNull Set<? extends InstanceObject> targetSet) {
        Set<InstanceObject> set;
        Intrinsics.checkNotNullParameter(targetSet, (String)"targetSet");
        Set<InstanceObject> $this$isSupersetOf_u24lambda_u2d7 = set = Collections.newSetFromMap(new IdentityHashMap());
        boolean bl = false;
        $this$isSupersetOf_u24lambda_u2d7.addAll((Collection)targetSet);
        Set<InstanceObject> clone = set;
        Intrinsics.checkNotNullExpressionValue(clone, (String)"clone");
        this.filterOutInstances(clone);
        return clone.isEmpty();
    }

    private final void filterOutInstances(Set<InstanceObject> remainders) {
        State s = this.state;
        if (s instanceof State.Coalesced) {
            remainders.removeAll((Collection)((State.Coalesced)s).getDeltaInstances());
            remainders.removeAll((Collection)((State.Coalesced)s).getSnapshotInstances());
        } else if (s instanceof State.Partitioned && !((Collection)remainders).isEmpty()) {
            Iterable $this$forEach$iv = ((State.Partitioned)s).getClassifier().getAllClassifierSets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassifierSet child = (ClassifierSet)element$iv;
                boolean bl = false;
                child.filterOutInstances(remainders);
                if (!remainders.isEmpty()) continue;
                return;
            }
        }
    }

    public final boolean immediateInstancesOverlapWith(@NotNull Set<? extends InstanceObject> targetSet) {
        Intrinsics.checkNotNullParameter(targetSet, (String)"targetSet");
        State s = this.state;
        boolean bl = false;
        return s instanceof State.Coalesced && (ClassifierSet.Companion.overlaps(((State.Coalesced)s).getDeltaInstances(), targetSet) || ClassifierSet.Companion.overlaps(((State.Coalesced)s).getSnapshotInstances(), targetSet));
    }

    public final boolean overlapsWith(@NotNull Set<? extends InstanceObject> targetSet) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(targetSet, (String)"targetSet");
            State s = this.state;
            if (s instanceof State.Coalesced) {
                bl = this.immediateInstancesOverlapWith(targetSet);
            } else if (s instanceof State.Partitioned) {
                Iterable $this$any$iv = ((State.Partitioned)s).getClassifier().getAllClassifierSets();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ClassifierSet it = (ClassifierSet)element$iv;
                        boolean bl2 = false;
                        if (!it.overlapsWith(targetSet)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    protected abstract Classifier createSubClassifier();

    public final void applyFilter(@NotNull Filter filter, boolean hasMatchedAncestor, boolean filterChanged) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!filterChanged && !this.needsRefiltering) {
            return;
        }
        this.isMatched = filter.matches(this.getStringForMatching());
        this.filterMatchCount = this.isMatched ? 1 : 0;
        State s = this.ensurePartitioned();
        if (s instanceof State.Coalesced.Leaf) {
            this.myIsFiltered = !this.isMatched && !hasMatchedAncestor;
            this.needsRefiltering = false;
        } else if (s instanceof State.Partitioned) {
            this.myIsFiltered = true;
            this.snapshotObjectCount = 0;
            this.deltaAllocationCount = 0;
            this.deltaDeallocationCount = 0;
            this.allocationSize = 0L;
            this.deallocationSize = 0L;
            this.totalShallowSize = 0L;
            this.totalNativeSize = 0L;
            this.instancesWithStackInfoCount = 0;
            this.totalObjectSetCount = ((State.Partitioned)s).getClassifier().getAllClassifierSets().size();
            this.filteredObjectSetCount = 0;
            for (ClassifierSet classifierSet : ((State.Partitioned)s).getClassifier().getAllClassifierSets()) {
                classifierSet.applyFilter(filter, hasMatchedAncestor || this.isMatched, filterChanged);
                this.totalObjectSetCount += classifierSet.totalObjectSetCount;
                if (classifierSet.isFiltered()) continue;
                this.myIsFiltered = false;
                this.snapshotObjectCount += classifierSet.snapshotObjectCount;
                this.deltaAllocationCount += classifierSet.deltaAllocationCount;
                this.deltaDeallocationCount += classifierSet.deltaDeallocationCount;
                this.allocationSize += classifierSet.allocationSize;
                this.deallocationSize += classifierSet.deallocationSize;
                this.totalShallowSize += classifierSet.totalShallowSize;
                this.totalNativeSize += classifierSet.totalNativeSize;
                this.deltaShallowSize += classifierSet.deltaShallowSize;
                this.instancesWithStackInfoCount += classifierSet.instancesWithStackInfoCount;
                this.filterMatchCount += classifierSet.filterMatchCount;
                int n = this.filteredObjectSetCount;
                this.filteredObjectSetCount = n + 1;
            }
        } else {
            throw new IllegalStateException();
        }
        this.needsRefiltering = false;
    }

    private final State.Coalesced.Delayed initState() {
        return new State.Coalesced.Delayed((Function0<? extends Classifier>)((Function0)new Function0<Classifier>((Object)this){

            @NotNull
            public final Classifier invoke() {
                return ((ClassifierSet)this.receiver).createSubClassifier();
            }
        }), (Set<InstanceObject>)new LinkedHashSet(0), new LinkedHashSet(0));
    }

    /*
     * WARNING - void declaration
     */
    private final int countInstanceFilterMatch(CaptureObjectInstanceFilter filter) {
        int n;
        State s = this.state;
        if (s instanceof State.Partitioned) {
            Iterable $this$sumBy$iv = ((State.Partitioned)s).getClassifier().getAllClassifierSets();
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                ClassifierSet classifierSet = (ClassifierSet)element$iv;
                int n2 = sum$iv;
                boolean bl = false;
                int n3 = it.getInstanceFilterMatchCount(filter);
                sum$iv = n2 + n3;
            }
            n = sum$iv;
        } else if (s instanceof State.Coalesced) {
            int n4;
            int n5;
            Iterable $this$count$iv;
            Iterable $this$sumBy$iv = ((State.Coalesced)s).getDeltaInstances();
            Function1<InstanceObject, Boolean> predicate$iv = filter.getInstanceTest();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n5 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    if (!((Boolean)predicate$iv.invoke(element$iv)).booleanValue() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n5 = count$iv;
            }
            $this$count$iv = ((State.Coalesced)s).getSnapshotInstances();
            int n6 = n5;
            boolean $i$f$count2 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n4 = 0;
            } else {
                int count$iv = 0;
                for (Iterator element$iv : $this$count$iv) {
                    InstanceObject it = (InstanceObject)((Object)element$iv);
                    boolean bl = false;
                    if (!(!((State.Coalesced)s).getDeltaInstances().contains(it) && (Boolean)filter.getInstanceTest().invoke((Object)it) != false) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n4 = count$iv;
            }
            int n7 = n4;
            n = n6 + n7;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public static final /* synthetic */ Stream access$getStreamOf(ClassifierSet $this, Function1 condition, Function1 extract2) {
        return $this.getStreamOf((Function1<? super ClassifierSet, Boolean>)condition, (Function1<? super State.Coalesced, ? extends Stream<InstanceObject>>)extract2);
    }

    public static final /* synthetic */ int access$countInstanceFilterMatch(ClassifierSet $this, CaptureObjectInstanceFilter filter) {
        return $this.countInstanceFilterMatch(filter);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0000J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0082\u0001\u0002\u0005\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State;", "", "()V", "forced", "retracted", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "makeClassifier", "Lkotlin/Function0;", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "Coalesced", "Partitioned", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Partitioned;", "intellij.android.profilers"})
    private static abstract class State {
        private State() {
        }

        @NotNull
        public final Coalesced retracted(@NotNull Function0<? extends Classifier> makeClassifier) {
            Coalesced coalesced;
            Intrinsics.checkNotNullParameter(makeClassifier, (String)"makeClassifier");
            State state = this;
            if (state instanceof Coalesced) {
                coalesced = (Coalesced)this;
            } else if (state instanceof Partitioned) {
                List<ClassifierSet> subs = ((Partitioned)this).getClassifier().getAllClassifierSets();
                boolean bl = false;
                coalesced = new Coalesced.Delayed(makeClassifier, (Set<InstanceObject>)State.retracted$lambda-1$instances(subs, (Function1<? super ClassifierSet, ? extends Stream<InstanceObject>>)((Function1)retracted.1.1.INSTANCE)), (Set<InstanceObject>)State.retracted$lambda-1$instances(subs, (Function1<? super ClassifierSet, ? extends Stream<InstanceObject>>)((Function1)retracted.1.2.INSTANCE)));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return coalesced;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final State forced() {
            State state;
            State state2 = this;
            if (state2 instanceof Partitioned ? true : state2 instanceof Coalesced.Leaf) {
                state = this;
                return state;
            } else {
                if (!(state2 instanceof Coalesced.Delayed)) throw new NoWhenBranchMatchedException();
                Classifier c = (Classifier)((Coalesced.Delayed)this).getMakeClassifier().invoke();
                if (c instanceof Classifier.Id) {
                    state = new Coalesced.Leaf(((Coalesced.Delayed)this).getSnapshotInstances(), ((Coalesced.Delayed)this).getDeltaInstances());
                    return state;
                } else {
                    if (!(c instanceof Classifier.Join)) throw new NoWhenBranchMatchedException();
                    Classifier classifier = c;
                    Classifier.Join it = (Classifier.Join)classifier;
                    boolean bl = false;
                    it.partition((Collection<? extends InstanceObject>)((Coalesced.Delayed)this).getSnapshotInstances(), (Collection<? extends InstanceObject>)((Coalesced.Delayed)this).getDeltaInstances());
                    Classifier classifier2 = classifier;
                    state = new Partitioned(classifier2);
                }
            }
            return state;
        }

        private static final LinkedHashSet<InstanceObject> retracted$lambda-1$instances(List<? extends ClassifierSet> $subs, Function1<? super ClassifierSet, ? extends Stream<InstanceObject>> extract2) {
            LinkedHashSet<InstanceObject> linkedHashSet;
            LinkedHashSet<InstanceObject> $this$retracted_u24lambda_u2d1_u24instances_u24lambda_u2d0 = linkedHashSet = new LinkedHashSet<InstanceObject>();
            boolean bl = false;
            Stream stream = $subs.stream().flatMap(new Function(extract2){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNullExpressionValue(stream, (String)"subs.stream().flatMap(extract)");
            $this$retracted_u24lambda_u2d1_u24instances_u24lambda_u2d0.addAll(StreamsKt.toList(stream));
            return linkedHashSet;
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B#\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State;", "snapshotInstances", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "deltaInstances", "(Ljava/util/Set;Ljava/util/Set;)V", "getDeltaInstances", "()Ljava/util/Set;", "retainedSize", "", "getRetainedSize", "()J", "setRetainedSize", "(J)V", "getSnapshotInstances", "Delayed", "Leaf", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Delayed;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Leaf;", "intellij.android.profilers"})
        public static abstract class Coalesced
        extends State {
            @NotNull
            private final Set<InstanceObject> snapshotInstances;
            @NotNull
            private final Set<InstanceObject> deltaInstances;
            private long retainedSize;

            private Coalesced(Set<InstanceObject> snapshotInstances, Set<InstanceObject> deltaInstances) {
                super(null);
                this.snapshotInstances = snapshotInstances;
                this.deltaInstances = deltaInstances;
                this.retainedSize = -1L;
            }

            @NotNull
            public final Set<InstanceObject> getSnapshotInstances() {
                return this.snapshotInstances;
            }

            @NotNull
            public final Set<InstanceObject> getDeltaInstances() {
                return this.deltaInstances;
            }

            public final long getRetainedSize() {
                return this.retainedSize;
            }

            public final void setRetainedSize(long l) {
                this.retainedSize = l;
            }

            public /* synthetic */ Coalesced(Set snapshotInstances, Set deltaInstances, DefaultConstructorMarker $constructor_marker) {
                this(snapshotInstances, deltaInstances);
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Leaf;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "snapshotInstances", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "deltaInstances", "(Ljava/util/Set;Ljava/util/Set;)V", "intellij.android.profilers"})
            public static final class Leaf
            extends Coalesced {
                public Leaf(@NotNull Set<InstanceObject> snapshotInstances, @NotNull Set<InstanceObject> deltaInstances) {
                    Intrinsics.checkNotNullParameter(snapshotInstances, (String)"snapshotInstances");
                    Intrinsics.checkNotNullParameter(deltaInstances, (String)"deltaInstances");
                    super(snapshotInstances, deltaInstances, null);
                }
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced$Delayed;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Coalesced;", "makeClassifier", "Lkotlin/Function0;", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "snapshotInstances", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "deltaInstances", "(Lkotlin/jvm/functions/Function0;Ljava/util/Set;Ljava/util/Set;)V", "getMakeClassifier", "()Lkotlin/jvm/functions/Function0;", "intellij.android.profilers"})
            public static final class Delayed
            extends Coalesced {
                @NotNull
                private final Function0<Classifier> makeClassifier;

                public Delayed(@NotNull Function0<? extends Classifier> makeClassifier, @NotNull Set<InstanceObject> snapshotInstances, @NotNull Set<InstanceObject> deltaInstances) {
                    Intrinsics.checkNotNullParameter(makeClassifier, (String)"makeClassifier");
                    Intrinsics.checkNotNullParameter(snapshotInstances, (String)"snapshotInstances");
                    Intrinsics.checkNotNullParameter(deltaInstances, (String)"deltaInstances");
                    super(snapshotInstances, deltaInstances, null);
                    this.makeClassifier = makeClassifier;
                }

                @NotNull
                public final Function0<Classifier> getMakeClassifier() {
                    return this.makeClassifier;
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State$Partitioned;", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$State;", "classifier", "Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "(Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;)V", "getClassifier", "()Lcom/android/tools/profilers/memory/adapters/classifiers/Classifier;", "intellij.android.profilers"})
        public static final class Partitioned
        extends State {
            @NotNull
            private final Classifier classifier;

            public Partitioned(@NotNull Classifier classifier) {
                Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
                super(null);
                this.classifier = classifier;
            }

            @NotNull
            public final Classifier getClassifier() {
                return this.classifier;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$DeltaChange;", "", "countsChanged", "", "instanceChanged", "(Ljava/lang/String;IZZ)V", "getCountsChanged", "()Z", "getInstanceChanged", "UNCHANGED", "INSTANCE_MODIFIED", "INSTANCE_ADDED_OR_REMOVED", "intellij.android.profilers"})
    private static final class DeltaChange
    extends Enum<DeltaChange> {
        private final boolean countsChanged;
        private final boolean instanceChanged;
        public static final /* enum */ DeltaChange UNCHANGED = new DeltaChange(false, false);
        public static final /* enum */ DeltaChange INSTANCE_MODIFIED = new DeltaChange(true, false);
        public static final /* enum */ DeltaChange INSTANCE_ADDED_OR_REMOVED = new DeltaChange(true, true);
        private static final /* synthetic */ DeltaChange[] $VALUES;

        private DeltaChange(boolean countsChanged, boolean instanceChanged) {
            this.countsChanged = countsChanged;
            this.instanceChanged = instanceChanged;
        }

        public final boolean getCountsChanged() {
            return this.countsChanged;
        }

        public final boolean getInstanceChanged() {
            return this.instanceChanged;
        }

        public static DeltaChange[] values() {
            return (DeltaChange[])$VALUES.clone();
        }

        public static DeltaChange valueOf(String value) {
            return Enum.valueOf(DeltaChange.class, value);
        }

        static {
            $VALUES = deltaChangeArray = new DeltaChange[]{DeltaChange.UNCHANGED, DeltaChange.INSTANCE_MODIFIED, DeltaChange.INSTANCE_ADDED_OR_REMOVED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0002\u0012\u001e\u0010\u0002\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR)\u0010\u0002\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$SetOperation;", "", "invoke", "Lkotlin/Function2;", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "", "countChange", "", "(Ljava/lang/String;ILkotlin/jvm/functions/Function2;I)V", "getCountChange", "()I", "getInvoke", "()Lkotlin/jvm/functions/Function2;", "ADD", "REMOVE", "intellij.android.profilers"})
    private static final class SetOperation
    extends Enum<SetOperation> {
        @NotNull
        private final Function2<Set<InstanceObject>, InstanceObject, Unit> invoke;
        private final int countChange;
        public static final /* enum */ SetOperation ADD = new SetOperation((Function2<? super Set<InstanceObject>, ? super InstanceObject, Unit>)((Function2)1.INSTANCE), 1);
        public static final /* enum */ SetOperation REMOVE = new SetOperation((Function2<? super Set<InstanceObject>, ? super InstanceObject, Unit>)((Function2)2.INSTANCE), -1);
        private static final /* synthetic */ SetOperation[] $VALUES;

        private SetOperation(Function2<? super Set<InstanceObject>, ? super InstanceObject, Unit> invoke, int countChange) {
            this.invoke = invoke;
            this.countChange = countChange;
        }

        @NotNull
        public final Function2<Set<InstanceObject>, InstanceObject, Unit> getInvoke() {
            return this.invoke;
        }

        public final int getCountChange() {
            return this.countChange;
        }

        public static SetOperation[] values() {
            return (SetOperation[])$VALUES.clone();
        }

        public static SetOperation valueOf(String value) {
            return Enum.valueOf(SetOperation.class, value);
        }

        static {
            $VALUES = setOperationArray = new SetOperation[]{SetOperation.ADD, SetOperation.REMOVE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\f\u0010\t\u001a\u00020\n*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet$Companion;", "", "()V", "overlaps", "", "set1", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "set2", "validOrZero", "", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean overlaps(Set<? extends InstanceObject> set1, Set<? extends InstanceObject> set2) {
            boolean bl;
            block3: {
                Set<? extends InstanceObject> iter = set1.size() < set2.size() ? set1 : set2;
                Set<? extends InstanceObject> test = iter == set1 ? set2 : set1;
                Iterable $this$any$iv = iter;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        InstanceObject p0 = (InstanceObject)element$iv;
                        boolean bl2 = false;
                        if (!test.contains(p0)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final long validOrZero(long $this$validOrZero) {
            return $this$validOrZero == -1L ? 0L : $this$validOrZero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

