/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReferenceObject
implements ValueObject {
    @NotNull
    private final List<String> myReferencingFieldNames;
    @NotNull
    private final InstanceObject myReferencingInstance;
    @NotNull
    private final String myName;

    public ReferenceObject(@NotNull List<String> referencingFieldNames, @NotNull InstanceObject referencingInstance) {
        this.myReferencingFieldNames = referencingFieldNames;
        this.myReferencingInstance = referencingInstance;
        StringBuilder builder = new StringBuilder();
        if (!this.myReferencingFieldNames.isEmpty()) {
            if (this.getValueType() == ValueObject.ValueType.ARRAY) {
                builder.append("Index ");
            }
            builder.append(String.join((CharSequence)", ", this.myReferencingFieldNames));
        }
        this.myName = builder.toString();
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<String> getReferenceFieldNames() {
        return this.myReferencingFieldNames;
    }

    @NotNull
    public InstanceObject getReferenceInstance() {
        return this.myReferencingInstance;
    }

    @Override
    public int getDepth() {
        return this.myReferencingInstance.getDepth();
    }

    @Override
    public long getNativeSize() {
        return this.myReferencingInstance.getNativeSize();
    }

    @Override
    public int getShallowSize() {
        return this.myReferencingInstance.getShallowSize();
    }

    @Override
    public long getRetainedSize() {
        return this.myReferencingInstance.getRetainedSize();
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        return this.myReferencingInstance.getValueType();
    }

    @Override
    @NotNull
    public String getValueText() {
        return this.myReferencingInstance.getValueText();
    }

    @Override
    @NotNull
    public String getToStringText() {
        return this.myReferencingInstance.getToStringText();
    }
}

