/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAllocationInstanceObject
implements InstanceObject {
    @NotNull
    private final Memory.AllocationEvent.Allocation myEvent;
    @NotNull
    private final ClassDb.ClassEntry myAllocationClassEntry;
    @NotNull
    private final Memory.AllocationStack myCallStack;
    @NotNull
    private final ValueObject.ValueType myValueType;
    private final boolean myIsAllocation;
    private final int myCount;

    public NativeAllocationInstanceObject(@NotNull Memory.AllocationEvent.Allocation event, @NotNull ClassDb.ClassEntry allocationClassEntry, @NotNull Memory.AllocationStack callStack, long count2) {
        this.myEvent = event;
        this.myAllocationClassEntry = allocationClassEntry;
        this.myCallStack = callStack;
        this.myValueType = ValueObject.ValueType.BYTE;
        this.myIsAllocation = count2 > 0L;
        this.myCount = (int)Math.abs(count2);
    }

    @Override
    public int getInstanceCount() {
        return this.myCount;
    }

    @Override
    public int getHeapId() {
        return 0;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        return this.myAllocationClassEntry;
    }

    @Override
    public boolean hasTimeData() {
        return true;
    }

    @Override
    public boolean hasAllocTime() {
        return this.myIsAllocation;
    }

    @Override
    public boolean hasDeallocTime() {
        return !this.myIsAllocation;
    }

    @Override
    @Nullable
    public Memory.AllocationStack getAllocationCallStack() {
        return this.myCallStack;
    }

    @Override
    public long getNativeSize() {
        return this.myEvent.getSize();
    }

    @Override
    public long getRetainedSize() {
        return this.myEvent.getSize();
    }

    @Override
    public int getShallowSize() {
        return (int)this.myEvent.getSize();
    }

    @Override
    public int getCallStackDepth() {
        Memory.AllocationStack callStack = this.getAllocationCallStack();
        if (callStack == null) {
            return 0;
        }
        return callStack.getFullStack().getFramesCount();
    }

    @Override
    public boolean getIsRoot() {
        return false;
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        return this.myValueType;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myAllocationClassEntry.getClassName();
    }
}

