/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.energy.EnergyDuration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class MergedEnergyEventsDataSeries
implements DataSeries<Common.Event> {
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myClient;
    private final long myStreamId;
    private final int myPid;
    private final Predicate<EnergyDuration.Kind> myKindPredicate;

    public MergedEnergyEventsDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, long streamId, int pid, @NotNull Predicate<EnergyDuration.Kind> kindPredicate) {
        this.myClient = client;
        this.myStreamId = streamId;
        this.myPid = pid;
        this.myKindPredicate = kindPredicate;
    }

    public List<SeriesData<Common.Event>> getDataForRange(Range range) {
        long minNs = TimeUnit.MICROSECONDS.toNanos((long)range.getMin());
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)range.getMax());
        ArrayList<SeriesData<Common.Event>> destData = new ArrayList<SeriesData<Common.Event>>();
        HashSet<Long> activeEventGroups = new HashSet<Long>();
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamId).setPid(this.myPid).setKind(Common.Event.Kind.ENERGY_EVENT).setFromTimestamp(minNs).setToTimestamp(maxNs).build();
        Transport.GetEventGroupsResponse response = this.myClient.getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            if (!this.myKindPredicate.test(EnergyDuration.Kind.from(group.getEvents(0).getEnergyEvent()))) continue;
            for (Common.Event event : group.getEventsList()) {
                if (!event.getIsEnded()) {
                    if (activeEventGroups.isEmpty()) {
                        destData.add((SeriesData<Common.Event>)new SeriesData(TimeUnit.NANOSECONDS.toMicros(event.getTimestamp()), (Object)event));
                    }
                    activeEventGroups.add(group.getGroupId());
                    continue;
                }
                activeEventGroups.remove(group.getGroupId());
                if (!activeEventGroups.isEmpty()) continue;
                destData.add((SeriesData<Common.Event>)new SeriesData(TimeUnit.NANOSECONDS.toMicros(event.getTimestamp()), (Object)event));
            }
        }
        return destData;
    }
}

