/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.energy.EnergyMonitor;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/profilers/energy/EnergyProfiler;", "Lcom/android/tools/profilers/StudioProfiler;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "(Lcom/android/tools/profilers/StudioProfilers;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "newMonitor", "Lcom/android/tools/profilers/ProfilerMonitor;", "startProfiling", "", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "stopProfiling", "intellij.android.profilers"})
public final class EnergyProfiler
implements StudioProfiler {
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Logger logger;

    public EnergyProfiler(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        this.profilers = profilers;
        Logger logger = Logger.getInstance(EnergyProfiler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(EnergyProfiler::class.java)");
        this.logger = logger;
    }

    @Override
    @NotNull
    public ProfilerMonitor newMonitor() {
        return new EnergyMonitor(this.profilers);
    }

    @Override
    public void startProfiling(@NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (this.profilers.getDevice() == null) {
            this.logger.warn("Unable to retrieve CPU frequency files; device ID unknown.");
            return;
        }
        ProfilerClient profilerClient = this.profilers.getClient();
        Commands.Command.Builder builder = Commands.Command.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setType(Commands.Command.CommandType.GET_CPU_CORE_CONFIG);
        Commands.GetCpuCoreConfig.Builder builder2 = Commands.GetCpuCoreConfig.newBuilder();
        Common.Device device = this.profilers.getDevice();
        Intrinsics.checkNotNull((Object)device);
        profilerClient.executeAsync(builder.setGetCpuCoreConfig(builder2.setDeviceId(device.getDeviceId())).build(), this.profilers.getIdeServices().getPoolExecutor());
    }

    @Override
    public void stopProfiling(@NotNull Common.Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
    }
}

