/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.chart.statechart.DefaultStateChartReducer;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartConfig;
import com.android.tools.adtui.chart.statechart.StateChartReducer;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.energy.EnergyDuration;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class EnergyEventStateChart {
    static final EnumColors<EnergyDuration.Kind> DURATION_STATE_ENUM_COLORS = new EnumColors.Builder(1).add((Enum)EnergyDuration.Kind.ALARM, new Color[]{ProfilerColors.ENERGY_BACKGROUND}).add((Enum)EnergyDuration.Kind.JOB, new Color[]{ProfilerColors.ENERGY_BACKGROUND}).add((Enum)EnergyDuration.Kind.WAKE_LOCK, new Color[]{ProfilerColors.ENERGY_WAKE_LOCK}).add((Enum)EnergyDuration.Kind.LOCATION, new Color[]{ProfilerColors.ENERGY_LOCATION}).add((Enum)EnergyDuration.Kind.UNKNOWN, new Color[]{UIUtil.TRANSPARENT_COLOR}).build();
    private static final StateChartColorProvider<Common.Event> DURATION_STATE_COLOR_PROVIDER = new StateChartColorProvider<Common.Event>(){

        @NotNull
        public Color getColor(boolean isMouseOver, @NotNull Common.Event value) {
            if (value.getIsEnded()) {
                return UIUtil.TRANSPARENT_COLOR;
            }
            return DURATION_STATE_ENUM_COLORS.getColor((Enum)EnergyDuration.Kind.from(value.getEnergyEvent()));
        }
    };

    @NotNull
    public static StateChart<Common.Event> create(@NotNull EnergyDuration duration, @NotNull Range range) {
        DefaultDataSeries series = new DefaultDataSeries();
        duration.getEventList().forEach(evt -> series.add(TimeUnit.NANOSECONDS.toMicros(evt.getTimestamp()), evt));
        StateChartModel model = new StateChartModel();
        model.addSeries(new RangedSeries(range, (DataSeries)series));
        return EnergyEventStateChart.create((StateChartModel<Common.Event>)model);
    }

    @NotNull
    public static StateChart<Common.Event> create(@NotNull StateChartModel<Common.Event> model) {
        return new StateChart(model, DURATION_STATE_COLOR_PROVIDER, Object::toString, new StateChartConfig((StateChartReducer)new DefaultStateChartReducer(), 1.0, 1.0, 0.33f));
    }
}

