/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import org.jetbrains.annotations.NotNull;

public enum EnergyEventOrigin {
    ALL("All"),
    APP_ONLY("App only"),
    THIRD_PARTY_ONLY("Third-party only");

    @NotNull
    private final String myLabelString;

    private EnergyEventOrigin(String labelString) {
        this.myLabelString = labelString;
    }

    @NotNull
    public String getLabelString() {
        return this.myLabelString;
    }

    public boolean isValid(@NotNull String appName, @NotNull String eventOrigin) {
        if (appName.isEmpty()) {
            return true;
        }
        switch (this) {
            case APP_ONLY: {
                return !eventOrigin.isEmpty() && eventOrigin.startsWith(appName);
            }
            case THIRD_PARTY_ONLY: {
                return !eventOrigin.isEmpty() && !eventOrigin.startsWith(appName);
            }
        }
        return true;
    }
}

