/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.energy.EnergyEventStateChart;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyProfilerStageView;
import com.intellij.ui.ColorUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class EnergyEventMinibar {
    @NotNull
    private final JComponent myComponent;

    public EnergyEventMinibar(@NotNull EnergyProfilerStageView stageView) {
        StateChart<Common.Event> chart2 = EnergyEventStateChart.create(((EnergyProfilerStage)((Object)stageView.getStage())).getEventModel());
        this.myComponent = this.createUi(chart2);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    private JPanel createUi(@NotNull StateChart<Common.Event> eventChart) {
        JPanel root = new JPanel((LayoutManager)new TabularLayout("Fit,*", "*"));
        root.setBorder(ProfilerLayout.MONITOR_BORDER);
        JPanel labelContainer = new JPanel(new BorderLayout());
        labelContainer.setBackground(ColorUtil.withAlpha((Color)ProfilerColors.DEFAULT_STAGE_BACKGROUND, (double)0.75));
        labelContainer.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        JLabel label = new JLabel("SYSTEM");
        label.setVerticalAlignment(0);
        labelContainer.add(label);
        JPanel eventChartContainer = new JPanel(new BorderLayout());
        eventChartContainer.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        eventChartContainer.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        eventChartContainer.add((Component)eventChart);
        root.add((Component)labelContainer, new TabularLayout.Constraint(0, 0));
        root.add((Component)eventChartContainer, new TabularLayout.Constraint(0, 0, 2));
        return root;
    }
}

