/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.ui.BreakWordWrapHtmlTextPane;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.UiHtmlText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EnergyDetailsOverview
extends JPanel {
    @NotNull
    private final JTextPane myTextPane;

    public EnergyDetailsOverview() {
        super(new BorderLayout());
        this.setBorder((Border)new JBEmptyBorder(0, 0, 5, 0));
        this.myTextPane = new BreakWordWrapHtmlTextPane();
        this.add(this.myTextPane);
    }

    public void setDuration(@Nullable EnergyDuration duration) {
        this.myTextPane.setText("");
        if (duration == null || duration.getKind() == EnergyDuration.Kind.UNKNOWN) {
            return;
        }
        UiHtmlText html = new UiHtmlText();
        switch (duration.getKind()) {
            case WAKE_LOCK: {
                duration.getEventList().stream().filter(e -> e.getEnergyEvent().hasWakeLockAcquired()).findFirst().ifPresent(event -> html.renderWakeLockAcquired(event.getEnergyEvent().getWakeLockAcquired()));
                break;
            }
            case ALARM: {
                duration.getEventList().stream().filter(e -> e.getEnergyEvent().hasAlarmSet()).findFirst().ifPresent(event -> html.renderAlarmSet(event.getEnergyEvent().getAlarmSet()));
                break;
            }
            case JOB: {
                duration.getEventList().stream().filter(e -> e.getEnergyEvent().hasJobScheduled()).findFirst().ifPresent(event -> html.renderJobScheduled(event.getEnergyEvent().getJobScheduled()));
                duration.getEventList().stream().filter(e -> e.getEnergyEvent().hasJobFinished()).findFirst().ifPresent(event -> html.renderJobFinished(event.getEnergyEvent().getJobFinished()));
                break;
            }
            case LOCATION: {
                duration.getEventList().stream().filter(e -> e.getEnergyEvent().hasLocationUpdateRequested()).findFirst().ifPresent(event -> html.renderLocationUpdateRequested(event.getEnergyEvent().getLocationUpdateRequested()));
                break;
            }
            default: {
                EnergyDetailsOverview.getLogger().warn("Unsupported overview " + duration.getKind().name());
            }
        }
        EnergyDetailsOverview.renderDuration(html, duration);
        this.myTextPane.setText(html.toString());
    }

    private static void renderDuration(@NotNull UiHtmlText html, @NotNull EnergyDuration duration) {
        Common.Event lastEvent = (Common.Event)duration.getEventList().get(duration.getEventList().size() - 1);
        if (lastEvent.getIsEnded()) {
            long durationNs = lastEvent.getTimestamp() - ((Common.Event)duration.getEventList().get(0)).getTimestamp();
            html.appendTitleAndValue("Duration", StringUtil.formatDuration((long)TimeUnit.NANOSECONDS.toMillis(durationNs)));
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(EnergyDetailsOverview.class);
    }
}

