/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.energy.EnergyUsage;
import org.jetbrains.annotations.NotNull;

public class DetailedEnergyUsage
extends EnergyUsage {
    @NotNull
    private final RangedContinuousSeries myCpuUsageSeries;
    @NotNull
    private final RangedContinuousSeries myNetworkUsageSeries;
    @NotNull
    private final RangedContinuousSeries myLocationUsageSeries;

    public DetailedEnergyUsage(@NotNull StudioProfilers profilers) {
        super(profilers);
        long streamId = profilers.getSession().getStreamId();
        int pid = profilers.getSession().getPid();
        UnifiedEventDataSeries cpuDataSeries = new UnifiedEventDataSeries(profilers.getClient().getTransportClient(), streamId, pid, Common.Event.Kind.ENERGY_USAGE, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(event -> event.getEnergyUsage().getCpuUsage()));
        UnifiedEventDataSeries networkDataSeries = new UnifiedEventDataSeries(profilers.getClient().getTransportClient(), streamId, pid, Common.Event.Kind.ENERGY_USAGE, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(event -> event.getEnergyUsage().getNetworkUsage()));
        UnifiedEventDataSeries locationDataSeries = new UnifiedEventDataSeries(profilers.getClient().getTransportClient(), streamId, pid, Common.Event.Kind.ENERGY_USAGE, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(event -> event.getEnergyUsage().getLocationUsage()));
        this.myLocationUsageSeries = new RangedContinuousSeries("Location", profilers.getTimeline().getViewRange(), this.getUsageRange(), locationDataSeries);
        this.add(this.myLocationUsageSeries);
        this.myNetworkUsageSeries = new RangedContinuousSeries("Network", profilers.getTimeline().getViewRange(), this.getUsageRange(), networkDataSeries);
        this.add(this.myNetworkUsageSeries);
        this.myCpuUsageSeries = new RangedContinuousSeries("CPU", profilers.getTimeline().getViewRange(), this.getUsageRange(), cpuDataSeries);
        this.add(this.myCpuUsageSeries);
    }

    @NotNull
    public RangedContinuousSeries getCpuUsageSeries() {
        return this.myCpuUsageSeries;
    }

    @NotNull
    public RangedContinuousSeries getNetworkUsageSeries() {
        return this.myNetworkUsageSeries;
    }

    @NotNull
    public RangedContinuousSeries getLocationUsageSeries() {
        return this.myLocationUsageSeries;
    }
}

