/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.customevent;

import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.profilers.customevent.UserCounterModel;
import org.jetbrains.annotations.NotNull;

public class CustomEventTrackModel {
    @NotNull
    private final UserCounterModel myLineChartModel;
    @NotNull
    private final AxisComponentModel myAxisComponentModel;
    @NotNull
    private final Legends myLegends;

    public CustomEventTrackModel(UserCounterModel userCounterModel, Range dataRange) {
        this.myLineChartModel = userCounterModel;
        this.myAxisComponentModel = new ResizingAxisComponentModel.Builder(this.myLineChartModel.getUsageRange(), (BaseAxisFormatter)new SingleUnitAxisFormatter(1, 5, 5, "")).build();
        this.myLegends = new Legends(this.myLineChartModel, dataRange);
    }

    @NotNull
    public LineChartModel getLineChartModel() {
        return this.myLineChartModel;
    }

    @NotNull
    public AxisComponentModel getAxisComponentModel() {
        return this.myAxisComponentModel;
    }

    @NotNull
    public Legends getLegends() {
        return this.myLegends;
    }

    @NotNull
    public String getName() {
        return this.myLineChartModel.getEventName();
    }

    public static class Legends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myTrackLegend;

        public Legends(@NotNull LineChartModel usage, @NotNull Range range) {
            super(range);
            this.myTrackLegend = new SeriesLegend((RangedContinuousSeries)usage.getSeries().get(0), (BaseAxisFormatter)new SingleUnitAxisFormatter(1, 5, 10, ""), range, Interpolatable.SegmentInterpolator);
            this.add((Legend)this.myTrackLegend);
        }

        @NotNull
        public SeriesLegend getTrackLegend() {
            return this.myTrackLegend;
        }
    }
}

