/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.android.tools.profilers.cpu.systemtrace.CounterModel;
import com.android.tools.profilers.cpu.systemtrace.CpuCoreModel;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SchedulingEventModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.ThreadModel;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.model.Counter;
import trebuchet.model.CounterValue;
import trebuchet.model.CpuModel;
import trebuchet.model.CpuProcessSlice;
import trebuchet.model.Model;
import trebuchet.model.SchedSlice;
import trebuchet.model.SchedulingState;
import trebuchet.model.base.SliceGroup;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 92\u00020\u0001:\u00019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\bH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\bH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J\b\u0010$\u001a\u00020\u001cH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u0014H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00152\u0006\u0010+\u001a\u00020\u0014H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\bH\u0016J\b\u0010-\u001a\u00020\u0005H\u0016J\b\u0010.\u001a\u00020\u0010H\u0016J$\u0010/\u001a\b\u0012\u0004\u0012\u0002000\b2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\b2\u0006\u00103\u001a\u00020\u0014H\u0002J,\u00104\u001a\b\u0012\u0004\u0012\u0002000\b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001a0\b2\u0006\u00105\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014H\u0002J\u001c\u00106\u001a\b\u0012\u0004\u0012\u0002070\b2\f\u00101\u001a\b\u0012\u0004\u0012\u0002080\bH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/TrebuchetModelAdapter;", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "trebuchetModel", "Ltrebuchet/model/Model;", "technology", "Lcom/android/tools/profilers/cpu/config/ProfilingConfiguration$TraceType;", "(Ltrebuchet/model/Model;Lcom/android/tools/profilers/cpu/config/ProfilingConfiguration$TraceType;)V", "batteryDrain", "", "Lcom/android/tools/profilers/cpu/systemtrace/CounterModel;", "beginTimestampSeconds", "", "cores", "Lcom/android/tools/profilers/cpu/systemtrace/CpuCoreModel;", "endTimestampSeconds", "possibleCorruption", "", "powerRails", "processById", "Ljava/util/SortedMap;", "", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "timeShiftFromBeginningSeconds", "convertSchedulingState", "Lcom/android/tools/profilers/cpu/ThreadState;", "slice", "Ltrebuchet/model/SchedSlice;", "convertToUserTimeUs", "", "timestampInSeconds", "getAndroidFrameLayers", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$AndroidFrameEventsResult$Layer;", "getAndroidFrameTimelineEvents", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;", "getBatteryDrain", "getCaptureEndTimestampUs", "getCaptureStartTimestampUs", "getCpuCores", "getDanglingThread", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "tid", "getPowerRails", "getProcessById", "id", "getProcesses", "getSystemTraceTechnology", "isCapturePossibleCorrupted", "mapCpuProcessSliceToSchedEvent", "Lcom/android/tools/profilers/cpu/systemtrace/SchedulingEventModel;", "slices", "Ltrebuchet/model/CpuProcessSlice;", "core", "mapSchedSliceToSchedEvent", "pid", "mapSlicesToTraceEvents", "Lcom/android/tools/profilers/cpu/systemtrace/TraceEventModel;", "Ltrebuchet/model/base/SliceGroup;", "Companion", "intellij.android.profilers"})
public final class TrebuchetModelAdapter
implements SystemTraceModelAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfilingConfiguration.TraceType technology;
    private final double beginTimestampSeconds;
    private final double endTimestampSeconds;
    private final double timeShiftFromBeginningSeconds;
    private final boolean possibleCorruption;
    @NotNull
    private final SortedMap<Integer, ProcessModel> processById;
    @NotNull
    private final List<CpuCoreModel> cores;
    @NotNull
    private final List<CounterModel> powerRails;
    @NotNull
    private final List<CounterModel> batteryDrain;
    private static final long SECONDS_TO_US = TimeUnit.SECONDS.toMicros(1L);

    /*
     * WARNING - void declaration
     */
    public TrebuchetModelAdapter(@NotNull Model trebuchetModel, @NotNull ProfilingConfiguration.TraceType technology) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Map threadMap;
        Intrinsics.checkNotNullParameter((Object)trebuchetModel, (String)"trebuchetModel");
        Intrinsics.checkNotNullParameter((Object)((Object)technology), (String)"technology");
        this.technology = technology;
        this.beginTimestampSeconds = trebuchetModel.getBeginTimestamp();
        this.endTimestampSeconds = trebuchetModel.getEndTimestamp();
        this.possibleCorruption = trebuchetModel.getRealtimeTimestamp() == 0L;
        this.processById = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        this.powerRails = CollectionsKt.emptyList();
        this.batteryDrain = CollectionsKt.emptyList();
        this.timeShiftFromBeginningSeconds = Double.compare(trebuchetModel.getParentTimestamp(), 0.0) == 0 ? 0.0 : trebuchetModel.getParentTimestamp() - trebuchetModel.getParentTimestampBootTime();
        for (trebuchet.model.ProcessModel process : trebuchetModel.getProcesses().values()) {
            Object schedEvents;
            threadMap = new LinkedHashMap();
            for (trebuchet.model.ThreadModel threadModel : process.getThreads()) {
                List<TraceEventModel> traceEvents = this.mapSlicesToTraceEvents(threadModel.getSlices());
                schedEvents = this.mapSchedSliceToSchedEvent(threadModel.getSchedSlices(), process.getId(), threadModel.getId());
                threadMap.put(threadModel.getId(), new ThreadModel(threadModel.getId(), process.getId(), threadModel.getName(), traceEvents, (List<SchedulingEventModel>)schedEvents));
            }
            Map counterMap = new LinkedHashMap();
            for (Counter counter : process.getCounters()) {
                void $this$associateTo$iv$iv;
                CounterModel $this$associate$iv;
                schedEvents = counterMap;
                object = counter.getName();
                Iterable iterable = counter.getEvents();
                String string = counter.getName();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associate$iv), (int)10)), (int)16);
                void var14_20 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    CounterValue it = (CounterValue)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)this.convertToUserTimeUs(it.getTimestamp()), (Object)it.getCount());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                SortedMap sortedMap = MapsKt.toSortedMap((Map)destination$iv$iv);
                String string2 = string;
                $this$associate$iv = new CounterModel(string2, sortedMap);
                schedEvents.put(object, $this$associate$iv);
            }
            ((Map)this.processById).put(process.getId(), new ProcessModel(process.getId(), process.getName(), threadMap, counterMap));
        }
        Iterable iterable = trebuchetModel.getCpus();
        TrebuchetModelAdapter trebuchetModelAdapter = this;
        boolean $i$f$map = false;
        threadMap = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cpu;
            object = (CpuModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new CpuCoreModel(cpu.getId(), this.mapCpuProcessSliceToSchedEvent(cpu.getSlices(), cpu.getId()), MapsKt.emptyMap()));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        trebuchetModelAdapter.cores = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CpuCoreModel core = (CpuCoreModel)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(core.getId());
                core = (CpuCoreModel)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(core.getId()));
            }
        });
    }

    @Override
    public long getCaptureStartTimestampUs() {
        return this.convertToUserTimeUs(this.beginTimestampSeconds);
    }

    @Override
    public long getCaptureEndTimestampUs() {
        return this.convertToUserTimeUs(this.endTimestampSeconds);
    }

    @Override
    @Nullable
    public ProcessModel getProcessById(int id) {
        return (ProcessModel)this.processById.get(id);
    }

    @Override
    @NotNull
    public List<ProcessModel> getProcesses() {
        Collection<ProcessModel> collection = this.processById.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"processById.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    @Nullable
    public ThreadModel getDanglingThread(int tid) {
        return null;
    }

    @Override
    @NotNull
    public List<CpuCoreModel> getCpuCores() {
        return this.cores;
    }

    @Override
    @NotNull
    public ProfilingConfiguration.TraceType getSystemTraceTechnology() {
        return this.technology;
    }

    @Override
    @NotNull
    public List<CounterModel> getPowerRails() {
        return this.powerRails;
    }

    @Override
    @NotNull
    public List<CounterModel> getBatteryDrain() {
        return this.batteryDrain;
    }

    @Override
    public boolean isCapturePossibleCorrupted() {
        return this.possibleCorruption;
    }

    @Override
    @NotNull
    public List<TraceProcessor.AndroidFrameEventsResult.Layer> getAndroidFrameLayers() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<AndroidFrameTimelineEvent> getAndroidFrameTimelineEvents() {
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<TraceEventModel> mapSlicesToTraceEvents(List<? extends SliceGroup> slices) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = slices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SliceGroup sliceGroup = (SliceGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TraceEventModel(it.getName(), this.convertToUserTimeUs(it.getStartTime()), this.convertToUserTimeUs(it.getEndTime()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getCpuTime()), this.mapSlicesToTraceEvents(it.getChildren())));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SchedulingEventModel> mapSchedSliceToSchedEvent(List<? extends SchedSlice> slices, int pid, int tid) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = slices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SchedSlice schedSlice = (SchedSlice)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SchedulingEventModel(this.convertSchedulingState((SchedSlice)it), this.convertToUserTimeUs(it.getStartTime()), this.convertToUserTimeUs(it.getEndTime()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getDuration()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getCpuTime()), pid, tid, 0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SchedulingEventModel> mapCpuProcessSliceToSchedEvent(List<? extends CpuProcessSlice> slices, int core) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = slices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CpuProcessSlice cpuProcessSlice = (CpuProcessSlice)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SchedulingEventModel(ThreadState.RUNNING_CAPTURED, this.convertToUserTimeUs(it.getStartTime()), this.convertToUserTimeUs(it.getEndTime()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getDuration()), TrebuchetModelAdapter.Companion.convertSecondsToUs(it.getCpuTime()), it.getId(), it.getThreadId(), core));
        }
        return (List)destination$iv$iv;
    }

    private final ThreadState convertSchedulingState(SchedSlice slice) {
        ThreadState threadState;
        switch (WhenMappings.$EnumSwitchMapping$0[slice.getState().ordinal()]) {
            case 1: {
                threadState = ThreadState.RUNNING_CAPTURED;
                break;
            }
            case 2: 
            case 3: {
                threadState = ThreadState.RUNNABLE_CAPTURED;
                break;
            }
            case 4: {
                threadState = ThreadState.DEAD_CAPTURED;
                break;
            }
            case 5: {
                threadState = ThreadState.SLEEPING_CAPTURED;
                break;
            }
            case 6: {
                threadState = ThreadState.WAITING_CAPTURED;
                break;
            }
            case 7: {
                threadState = ThreadState.WAITING_IO_CAPTURED;
                break;
            }
            default: {
                threadState = ThreadState.UNKNOWN;
            }
        }
        return threadState;
    }

    private final long convertToUserTimeUs(double timestampInSeconds) {
        return TrebuchetModelAdapter.Companion.convertSecondsToUs(timestampInSeconds + this.timeShiftFromBeginningSeconds);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/TrebuchetModelAdapter$Companion;", "", "()V", "SECONDS_TO_US", "", "convertSecondsToUs", "seconds", "", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        private final long convertSecondsToUs(double seconds) {
            return (long)((double)SECONDS_TO_US * seconds);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SchedulingState.values().length];
            nArray[SchedulingState.RUNNING.ordinal()] = 1;
            nArray[SchedulingState.WAKING.ordinal()] = 2;
            nArray[SchedulingState.RUNNABLE.ordinal()] = 3;
            nArray[SchedulingState.EXIT_DEAD.ordinal()] = 4;
            nArray[SchedulingState.SLEEPING.ordinal()] = 5;
            nArray[SchedulingState.UNINTR_SLEEP.ordinal()] = 6;
            nArray[SchedulingState.UNINTR_SLEEP_IO.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

