/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.MainProcessSelector;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.AtraceProducer;
import com.android.tools.profilers.cpu.systemtrace.PerfettoProducer;
import com.android.tools.profilers.cpu.systemtrace.ProcessListSorter;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCaptureBuilder;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.TrebuchetBufferProducer;
import com.android.tools.profilers.cpu.systemtrace.TrebuchetModelAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.Model;
import trebuchet.task.ImportTask;
import trebuchet.util.PrintlnImportFeedback;

public class AtraceParser
implements TraceParser {
    @NotNull
    private final MainProcessSelector processSelector;
    @NotNull
    private final ProfilingConfiguration.TraceType myCpuTraceType;

    @VisibleForTesting
    public AtraceParser() {
        this(new MainProcessSelector("", 0, null));
    }

    public AtraceParser(@NotNull MainProcessSelector processSelector) {
        this(ProfilingConfiguration.TraceType.ATRACE, processSelector);
    }

    public AtraceParser(@NotNull ProfilingConfiguration.TraceType type, @NotNull MainProcessSelector processSelector) {
        this.processSelector = processSelector;
        Preconditions.checkArgument((type == ProfilingConfiguration.TraceType.ATRACE || type == ProfilingConfiguration.TraceType.PERFETTO ? 1 : 0) != 0, (Object)"type must be ATRACE or PERFETTO.");
        this.myCpuTraceType = type;
    }

    @Override
    public CpuCapture parse(@NotNull File file, long traceId) throws IOException {
        SystemTraceModelAdapter model = this.parseToModel(file);
        if (model.getProcesses().isEmpty()) {
            throw new IllegalStateException("Invalid trace without any process information.");
        }
        ProcessListSorter sorter = new ProcessListSorter(this.processSelector.getNameHint());
        Integer selectedProcess = this.processSelector.apply(sorter.sort(model.getProcesses()));
        if (selectedProcess == null) {
            throw new IllegalStateException("It was not possible to select a process for this trace.");
        }
        SystemTraceCpuCaptureBuilder builder = new SystemTraceCpuCaptureBuilder(model);
        return builder.build(traceId, selectedProcess, new Range((double)model.getCaptureStartTimestampUs(), (double)model.getCaptureEndTimestampUs()));
    }

    private SystemTraceModelAdapter parseToModel(@NotNull File file) throws IOException {
        TrebuchetBufferProducer producer;
        if (this.myCpuTraceType == ProfilingConfiguration.TraceType.ATRACE) {
            producer = new AtraceProducer();
        } else if (this.myCpuTraceType == ProfilingConfiguration.TraceType.PERFETTO) {
            producer = new PerfettoProducer();
        } else {
            throw new IllegalStateException("Trying to parse something that is not ATRACE nor PERFETTO.");
        }
        if (!producer.parseFile(file)) {
            throw new IOException("Failed to parse file: " + file.getAbsolutePath());
        }
        ImportTask task = new ImportTask(new PrintlnImportFeedback());
        Model trebuchetModel = task.importBuffer(producer);
        return new TrebuchetModelAdapter(trebuchetModel, this.myCpuTraceType);
    }
}

