/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.capturedetails.Aggregate;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetailsView;
import com.android.tools.profilers.cpu.capturedetails.CpuTraceTreeSorter;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeModel;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.cpu.nodemodel.SystemTraceNodeModel;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeDetailsView
extends CaptureDetailsView {
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    private final AspectObserver myObserver;
    @Nullable
    protected final JTree myTree;
    @Nullable
    private final CpuTraceTreeSorter mySorter;
    private final Set<TreePath> myExpandedPaths = new HashSet<TreePath>();
    private static final Comparator<CpuTreeNode<?>> NAME_VALUE_NODE_COMPARATOR = Comparator.comparing(o -> ((Aggregate)o.getBase()).getMethodModel().getName());

    protected TreeDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CpuCapture cpuCapture, @Nullable CpuTreeModel<?> model) {
        super(profilersView);
        this.myObserver = new AspectObserver();
        if (model == null) {
            this.myPanel = TreeDetailsView.getNoDataForThread();
            this.myTree = null;
            this.mySorter = null;
            return;
        }
        this.myPanel = new JPanel(new CardLayout());
        this.myTree = new JTree();
        int defaultFontHeight = this.myTree.getFontMetrics(this.myTree.getFont()).getHeight();
        this.myTree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myTree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
        this.myTree.setModel(model);
        this.myTree.setRootVisible(model.isRootNodeIdValid());
        this.mySorter = new CpuTraceTreeSorter(this.myTree, model, Collections.reverseOrder(TreeDetailsView.doubleValueNodeComparator(CpuTreeNode::getTotal)));
        this.myPanel.add((Component)this.createTableTree(), "Content");
        this.myPanel.add((Component)TreeDetailsView.getNoDataForRange(), "Empty content");
        CodeNavigator navigator = profilersView.getStudioProfilers().getIdeServices().getCodeNavigator();
        if (cpuCapture.getSystemTraceData() == null) {
            profilersView.getIdeProfilerComponents().createContextMenuInstaller().installNavigationContextMenu((JComponent)this.myTree, navigator, () -> TreeDetailsView.getCodeLocation(this.myTree));
        }
        TreeDetailsView.switchCardLayout(this.myPanel, model.isEmpty());
        model.getAspect().addDependency(this.myObserver).onChange((Enum)CpuTreeModel.Aspect.TREE_MODEL, () -> {
            this.mySorter.sort();
            this.resetTreeExpansionState();
        });
        this.myTree.addTreeExpansionListener(new ExpansionListener());
    }

    private void resetTreeExpansionState() {
        HashSet<TreePath> paths = new HashSet<TreePath>(this.myExpandedPaths);
        this.myExpandedPaths.clear();
        assert (this.myTree != null);
        paths.forEach(this.myTree::expandPath);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    private JComponent createTableTree() {
        assert (this.myTree != null && this.mySorter != null);
        return new ColumnTreeBuilder(this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Name").setPreferredWidth(900).setMinWidth(160).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MethodNameRenderer()).setComparator(NAME_VALUE_NODE_COMPARATOR)).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Total (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setMinWidth(80).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRendererWithSparkline(CpuTreeNode::getTotal, false, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator(TreeDetailsView.doubleValueNodeComparator(CpuTreeNode::getTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(60).setMinWidth(60).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getTotal, true, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator(TreeDetailsView.doubleValueNodeComparator(CpuTreeNode::getTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Self (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setMinWidth(80).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getSelf, false, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator(TreeDetailsView.doubleValueNodeComparator(CpuTreeNode::getSelf))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(60).setMinWidth(60).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getSelf, true, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator(TreeDetailsView.doubleValueNodeComparator(CpuTreeNode::getSelf))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Children (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setMinWidth(80).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getChildrenTotal, false, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator(TreeDetailsView.doubleValueNodeComparator(CpuTreeNode::getChildrenTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(60).setMinWidth(60).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getChildrenTotal, true, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator(TreeDetailsView.doubleValueNodeComparator(CpuTreeNode::getChildrenTotal))).setTreeSorter((ColumnTreeBuilder.TreeSorter)this.mySorter).setBorder(AdtUiUtils.DEFAULT_TOP_BORDER).setBackground(ProfilerColors.DEFAULT_BACKGROUND).setShowVerticalLines(true).setTableIntercellSpacing(new Dimension()).build();
    }

    @Nullable
    private static CodeLocation getCodeLocation(@NotNull JTree tree) {
        if (tree.getSelectionPath() == null) {
            return null;
        }
        CpuTreeNode node = (CpuTreeNode)tree.getSelectionPath().getLastPathComponent();
        return TreeDetailsView.modelToCodeLocation(((Aggregate)node.getBase()).getMethodModel());
    }

    @Nullable
    private static CodeLocation modelToCodeLocation(CaptureNodeModel model) {
        if (model instanceof CppFunctionModel) {
            CppFunctionModel nativeFunction = (CppFunctionModel)model;
            return new CodeLocation.Builder(nativeFunction.getClassOrNamespace()).setMethodName(nativeFunction.getName()).setMethodParameters(nativeFunction.getParameters()).setNativeCode(true).setFileName(nativeFunction.getFileName()).setNativeVAddress(nativeFunction.getVAddress()).build();
        }
        if (model instanceof JavaMethodModel) {
            JavaMethodModel javaMethod = (JavaMethodModel)model;
            return new CodeLocation.Builder(javaMethod.getClassName()).setMethodName(javaMethod.getName()).setMethodSignature(javaMethod.getSignature()).setNativeCode(false).build();
        }
        return null;
    }

    private static Comparator<CpuTreeNode<?>> doubleValueNodeComparator(Function<CpuTreeNode, Double> getter) {
        return Comparator.comparingDouble(getter::apply);
    }

    private static SimpleTextAttributes getTextAttributes(@NotNull CpuTreeNode node) {
        switch (((Aggregate)node.getBase()).getFilterType()) {
            case MATCH: {
                return SimpleTextAttributes.REGULAR_ATTRIBUTES;
            }
            case EXACT_MATCH: {
                return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            case UNMATCH: {
                return SimpleTextAttributes.GRAY_ATTRIBUTES;
            }
        }
        throw new IllegalStateException();
    }

    private class ExpansionListener
    implements TreeExpansionListener {
        private final Set<TreePath> myCollapsedParentChildExpandedPaths = new HashSet<TreePath>();

        private ExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TreePath toBeExpandedPath = event.getPath();
            HashSet<TreePath> expandedChildren = new HashSet<TreePath>();
            expandedChildren.add(toBeExpandedPath);
            this.myCollapsedParentChildExpandedPaths.forEach(path -> {
                if (toBeExpandedPath.isDescendant((TreePath)path) && path.getParentPath().equals(toBeExpandedPath)) {
                    expandedChildren.add((TreePath)path);
                }
            });
            this.myCollapsedParentChildExpandedPaths.removeAll(expandedChildren);
            TreeDetailsView.this.myExpandedPaths.addAll(expandedChildren);
            expandedChildren.forEach(TreeDetailsView.this.myTree::expandPath);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            TreePath toBeCollapsedPath = event.getPath();
            HashSet<TreePath> childExpandedPaths = new HashSet<TreePath>();
            childExpandedPaths.add(toBeCollapsedPath);
            TreeDetailsView.this.myExpandedPaths.forEach(path -> {
                if (toBeCollapsedPath.isDescendant((TreePath)path)) {
                    childExpandedPaths.add((TreePath)path);
                }
            });
            TreeDetailsView.this.myExpandedPaths.removeAll(childExpandedPaths);
            this.myCollapsedParentChildExpandedPaths.addAll(childExpandedPaths);
        }
    }

    public static class BottomUpDetailsView
    extends TreeDetailsView {
        private final CaptureDetails.BottomUp myBottomUp;

        public BottomUpDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureDetails.BottomUp bottomUp) {
            super(profilersView, bottomUp.getCapture(), bottomUp.getModel());
            this.myBottomUp = bottomUp;
            final CpuTreeModel model = bottomUp.getModel();
            if (model == null) {
                return;
            }
            assert (this.myTree != null);
            this.myTree.setRootVisible(false);
            model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    if (type == TreeModelAdapter.EventType.NodesInserted && event.getTreePath().getPathCount() == 1) {
                        Object root = model.getRoot();
                        Object[] inserted = event.getChildren();
                        if (inserted != null && inserted.length == ((CpuTreeNode)root).getChildCount()) {
                            myTree.expandPath(new TreePath(root));
                        }
                    }
                    CaptureDetailsView.switchCardLayout(myPanel, model.isEmpty());
                }
            });
        }

        @Override
        public void onRemoved() {
            this.myBottomUp.onRemoved();
        }

        @Override
        public void onReattached() {
            this.myBottomUp.onReattached();
        }
    }

    public static class TopDownDetailsView
    extends TreeDetailsView {
        private final CaptureDetails.TopDown myTopDown;

        public TopDownDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureDetails.TopDown topDown) {
            super(profilersView, topDown.getCapture(), topDown.getModel());
            this.myTopDown = topDown;
            final CpuTreeModel model = topDown.getModel();
            if (model == null) {
                return;
            }
            assert (this.myTree != null);
            TopDownDetailsView.expandTreeNodes(this.myTree);
            model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    CaptureDetailsView.switchCardLayout(myPanel, model.isEmpty());
                }
            });
        }

        @Override
        public void onRemoved() {
            this.myTopDown.onRemoved();
        }

        @Override
        public void onReattached() {
            this.myTopDown.onReattached();
        }

        private static void expandTreeNodes(JTree tree) {
            int maxRowsToExpand = 8;
            int i = 0;
            while (i < tree.getRowCount() && i < maxRowsToExpand) {
                tree.expandRow(i++);
            }
        }
    }

    private static class MethodNameRenderer
    extends ColoredTreeCellRenderer {
        private MethodNameRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof CpuTreeNode) {
                CpuTreeNode node = (CpuTreeNode)value;
                SimpleTextAttributes attributes = TreeDetailsView.getTextAttributes(node);
                CaptureNodeModel model = ((Aggregate)node.getBase()).getMethodModel();
                String classOrNamespace = "";
                if (model instanceof CppFunctionModel) {
                    classOrNamespace = ((CppFunctionModel)model).getClassOrNamespace();
                } else if (model instanceof JavaMethodModel) {
                    classOrNamespace = ((JavaMethodModel)model).getClassName();
                }
                if (model.getName().isEmpty()) {
                    this.setIcon(AllIcons.Debugger.ThreadSuspended);
                    this.append(classOrNamespace, attributes);
                } else {
                    this.setIcon(PlatformIcons.METHOD_ICON);
                    if (model instanceof SystemTraceNodeModel) {
                        this.append(model.getName());
                    } else {
                        this.append(model.getName() + "()", attributes);
                        this.append(" (" + classOrNamespace + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            } else {
                this.append(value.toString());
            }
        }
    }

    private static class DoubleValueCellRendererWithSparkline
    extends DoubleValueCellRenderer {
        private Color mySparkLineColor = ProfilerColors.CAPTURE_SPARKLINE;
        private double myPercentage = Double.NEGATIVE_INFINITY;

        DoubleValueCellRendererWithSparkline(Function<CpuTreeNode, Double> getter, boolean showPercentage, int alignment) {
            super(getter, showPercentage, alignment);
        }

        @Override
        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
            CpuTreeNode node = (CpuTreeNode)value;
            if (node != null) {
                this.myPercentage = this.getGetter().apply(node) / ((CpuTreeNode)tree.getModel().getRoot()).getChildrenTotal();
            }
            this.mySparkLineColor = selected ? ProfilerColors.CAPTURE_SPARKLINE_SELECTED : ProfilerColors.CAPTURE_SPARKLINE;
        }

        protected void paintComponent(Graphics g) {
            if (this.myPercentage > 0.0) {
                g.setColor(this.mySparkLineColor);
                int sparkLineWidth = (int)(this.myPercentage * (double)(this.getWidth() - ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_RIGHT_PADDING));
                g.fillRect(this.getWidth() - sparkLineWidth - ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_RIGHT_PADDING, ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_TOP_BOTTOM_PADDING, sparkLineWidth, this.getHeight() - ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_TOP_BOTTOM_PADDING * 2);
            }
            super.paintComponent(g);
        }
    }

    private static class DoubleValueCellRenderer
    extends ColoredTreeCellRenderer {
        private final Function<CpuTreeNode, Double> myGetter;
        private final boolean myShowPercentage;
        private final int myAlignment;

        DoubleValueCellRenderer(Function<CpuTreeNode, Double> getter, boolean showPercentage, int alignment) {
            this.myGetter = getter;
            this.myShowPercentage = showPercentage;
            this.myAlignment = alignment;
            this.setTextAlign(alignment);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            CpuTreeNode node = (CpuTreeNode)value;
            if (node != null) {
                SimpleTextAttributes attributes = TreeDetailsView.getTextAttributes(node);
                double v = this.myGetter.apply(node);
                if (this.myShowPercentage) {
                    CpuTreeNode root = (CpuTreeNode)tree.getModel().getRoot();
                    this.append(String.format(Locale.getDefault(), "%.2f", v / root.getTotal() * 100.0), attributes);
                } else {
                    this.append(String.format(Locale.getDefault(), "%,.0f", v), attributes);
                }
            } else {
                this.append(value.toString());
            }
            if (this.myAlignment == 2) {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_CELL_INSETS);
            } else {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_CELL_INSETS);
            }
        }

        protected Function<CpuTreeNode, Double> getGetter() {
            return this.myGetter;
        }
    }
}

