/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AsyncUpdater;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.capturedetails.Aggregate;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeModel;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001@B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u001bH\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000 2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u00101\u001a\u00020/2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u00020-H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0016J\u0010\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020-H\u0016J\u0006\u00106\u001a\u00020\fJ\u0006\u00107\u001a\u00020\fJ\b\u00108\u001a\u00020\fH\u0002J\u0010\u00109\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u001bH\u0016J*\u0010:\u001a\u00020\f2\"\u0010;\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000 0\u001fj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000 `!J\u0018\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020-H\u0016R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001e\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000 0\u001fj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000 `!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000 @BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/tools/profilers/cpu/capturedetails/CpuTreeModel;", "T", "Lcom/android/tools/profilers/cpu/capturedetails/Aggregate;", "Ljavax/swing/tree/TreeModel;", "clockType", "Lcom/android/tools/perflib/vmtrace/ClockType;", "range", "Lcom/android/tools/adtui/model/Range;", "base", "runModelUpdate", "Lkotlin/Function1;", "Ljava/lang/Runnable;", "", "(Lcom/android/tools/perflib/vmtrace/ClockType;Lcom/android/tools/adtui/model/Range;Lcom/android/tools/profilers/cpu/capturedetails/Aggregate;Lkotlin/jvm/functions/Function1;)V", "aspect", "Lcom/android/tools/adtui/model/AspectModel;", "Lcom/android/tools/profilers/cpu/capturedetails/CpuTreeModel$Aspect;", "getAspect", "()Lcom/android/tools/adtui/model/AspectModel;", "getClockType", "()Lcom/android/tools/perflib/vmtrace/ClockType;", "isEmpty", "", "()Z", "isRootNodeIdValid", "listeners", "", "Ljavax/swing/event/TreeModelListener;", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "order", "Ljava/util/Comparator;", "Lcom/android/tools/profilers/cpu/capturedetails/CpuTreeNode;", "Lkotlin/Comparator;", "rangeChanged", "Lkotlin/Function0;", "newRoot", "root", "setRoot", "(Lcom/android/tools/profilers/cpu/capturedetails/CpuTreeNode;)V", "treeRange", "addTreeModelListener", "l", "getChild", "parent", "", "index", "", "getChildCount", "getIndexOfChild", "child", "getRoot", "isLeaf", "node", "onDestroyed", "onReattached", "reload", "removeTreeModelListener", "sort", "newOrder", "valueForPathChanged", "path", "Ljavax/swing/tree/TreePath;", "newValue", "Aspect", "intellij.android.profilers"})
public final class CpuTreeModel<T extends Aggregate<T>>
implements TreeModel {
    @NotNull
    private final ClockType clockType;
    @NotNull
    private final Range range;
    @NotNull
    private Range treeRange;
    @NotNull
    private Comparator<CpuTreeNode<T>> order;
    @NotNull
    private final AspectModel<Aspect> aspect;
    @NotNull
    private final AspectObserver observer;
    @NotNull
    private final List<TreeModelListener> listeners;
    @NotNull
    private CpuTreeNode<T> root;
    private final boolean isRootNodeIdValid;
    @NotNull
    private final Function0<Unit> rangeChanged;

    public CpuTreeModel(@NotNull ClockType clockType, @NotNull Range range, @NotNull T base, @NotNull Function1<? super Runnable, Unit> runModelUpdate) {
        Intrinsics.checkNotNullParameter((Object)clockType, (String)"clockType");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(base, (String)"base");
        Intrinsics.checkNotNullParameter(runModelUpdate, (String)"runModelUpdate");
        this.clockType = clockType;
        this.range = range;
        this.treeRange = new Range(this.range);
        Function1[] function1Array = new Function1[]{order.1.INSTANCE, order.2.INSTANCE};
        this.order = ComparisonsKt.compareBy((Function1[])function1Array);
        this.aspect = new AspectModel();
        this.observer = new AspectObserver();
        this.listeners = new ArrayList();
        this.root = CpuTreeNode.Companion.of(base, this.clockType, this.treeRange, this.order);
        this.isRootNodeIdValid = ((CharSequence)((Aggregate)this.root.getBase()).getId()).length() > 0;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
        this.rangeChanged = AsyncUpdater.by((Function1)((Function1)new Function1<Runnable, Unit>((Object)application){

            public final void invoke(@NotNull Runnable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((Application)this.receiver).invokeAndWait(p0);
            }
        }), runModelUpdate, (Function0)new Function0<CpuTreeNode<T>>(this){
            final /* synthetic */ CpuTreeModel<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CpuTreeNode<T> invoke() {
                return CpuTreeModel.access$getRoot$p(this.this$0);
            }
        }, (Function1)new Function1<CpuTreeNode<T>, CpuTreeNode<T>>(this){
            final /* synthetic */ CpuTreeModel<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CpuTreeNode<T> invoke(@NotNull CpuTreeNode<T> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.withRange$intellij_android_profilers(this.this$0.getClockType(), CpuTreeModel.access$getRange$p(this.this$0), CpuTreeModel.access$getTreeRange$p(this.this$0), CpuTreeModel.access$getOrder$p(this.this$0));
            }
        }, (Function1)new Function1<CpuTreeNode<T>, Unit>(this){
            final /* synthetic */ CpuTreeModel<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CpuTreeNode<T> newRoot) {
                Intrinsics.checkNotNullParameter(newRoot, (String)"newRoot");
                CpuTreeModel.access$setRoot(this.this$0, newRoot);
                CpuTreeModel.access$getTreeRange$p(this.this$0).set(CpuTreeModel.access$getRange$p(this.this$0));
                this.this$0.getAspect().changed((Enum)Aspect.TREE_MODEL);
            }
        });
        this.onReattached();
    }

    @NotNull
    public final ClockType getClockType() {
        return this.clockType;
    }

    @NotNull
    public final AspectModel<Aspect> getAspect() {
        return this.aspect;
    }

    private final void setRoot(CpuTreeNode<T> newRoot) {
        if (newRoot != this.root) {
            this.root = newRoot;
            this.reload();
        }
    }

    public final boolean isRootNodeIdValid() {
        return this.isRootNodeIdValid;
    }

    public final boolean isEmpty() {
        return this.root.getTotal() == 0.0;
    }

    public final void sort(@NotNull Comparator<CpuTreeNode<T>> newOrder) {
        Intrinsics.checkNotNullParameter(newOrder, (String)"newOrder");
        if (!Intrinsics.areEqual(newOrder, this.order)) {
            this.order = newOrder;
            this.setRoot(this.root.withOrder$intellij_android_profilers(newOrder, this.clockType, this.treeRange));
        }
    }

    public final void onDestroyed() {
        this.range.removeDependencies(this.observer);
    }

    public final void onReattached() {
        Function0<Unit> function0 = this.rangeChanged;
        this.range.addDependency(this.observer).onChange((Enum)Range.Aspect.RANGE, new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void run() {
                this.function.invoke();
            }
        });
        this.rangeChanged.invoke();
    }

    private final void reload() {
        Object[] objectArray = new CpuTreeNode[]{this.root};
        TreeModelEvent event = new TreeModelEvent((Object)this, objectArray, null, null);
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable(this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeModelListener it = (TreeModelListener)element$iv;
            boolean bl = false;
            it.treeStructureChanged(event);
        }
    }

    @Override
    @NotNull
    public CpuTreeNode<T> getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public CpuTreeNode<T> getChild(@NotNull Object parent, int index) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return ((CpuTreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(@NotNull Object parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return ((CpuTreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(@NotNull Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return ((CpuTreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(@NotNull TreePath path, @NotNull Object newValue) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
    }

    @Override
    public int getIndexOfChild(@NotNull Object parent, @NotNull Object child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return ((CpuTreeNode)parent).getIndex((CpuTreeNode)child);
    }

    @Override
    public void addTreeModelListener(@NotNull TreeModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(@NotNull TreeModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    public static final /* synthetic */ CpuTreeNode access$getRoot$p(CpuTreeModel $this) {
        return $this.root;
    }

    public static final /* synthetic */ Range access$getRange$p(CpuTreeModel $this) {
        return $this.range;
    }

    public static final /* synthetic */ Range access$getTreeRange$p(CpuTreeModel $this) {
        return $this.treeRange;
    }

    public static final /* synthetic */ Comparator access$getOrder$p(CpuTreeModel $this) {
        return $this.order;
    }

    public static final /* synthetic */ void access$setRoot(CpuTreeModel $this, CpuTreeNode newRoot) {
        $this.setRoot(newRoot);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/profilers/cpu/capturedetails/CpuTreeModel$Aspect;", "", "(Ljava/lang/String;I)V", "TREE_MODEL", "intellij.android.profilers"})
    public static final class Aspect
    extends Enum<Aspect> {
        public static final /* enum */ Aspect TREE_MODEL = new Aspect();
        private static final /* synthetic */ Aspect[] $VALUES;

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String value) {
            return Enum.valueOf(Aspect.class, value);
        }

        static {
            $VALUES = aspectArray = new Aspect[]{Aspect.TREE_MODEL};
        }
    }
}

