/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ChartTooltipViewBase;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CaptureNode;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class CpuChartTooltipView
extends ChartTooltipViewBase<CaptureNode> {
    private final Range myDataRange;

    CpuChartTooltipView(@NotNull HTreeChart<CaptureNode> chart2, @NotNull Range dataRange, @NotNull JLayeredPane tooltipRoot) {
        super(chart2, tooltipRoot);
        this.myDataRange = dataRange;
    }

    @Override
    public void showTooltip(@NotNull CaptureNode node) {
        long start = (long)((double)node.getStart() - this.myDataRange.getMin());
        long end = (long)((double)node.getEnd() - this.myDataRange.getMin());
        long totalDuration = node.getDuration();
        this.getTooltipContainer().removeAll();
        JLabel nameLabel = new JLabel(node.getData().getFullName());
        nameLabel.setFont(TooltipView.TOOLTIP_BODY_FONT);
        nameLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        this.getTooltipContainer().add((Component)nameLabel, new TabularLayout.Constraint(0, 0));
        JLabel timelineLabel = new JLabel(String.format("%s - %s", TimeFormatter.getFullClockString((long)start), TimeFormatter.getFullClockString((long)end)));
        timelineLabel.setFont(TooltipView.TOOLTIP_BODY_FONT);
        timelineLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        timelineLabel.setBorder((Border)JBUI.Borders.empty());
        JLabel durationLabel = new JLabel(String.format("%s", TimeFormatter.getSingleUnitDurationString((long)totalDuration)));
        durationLabel.setFont(TooltipView.TOOLTIP_BODY_FONT);
        durationLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        durationLabel.setBorder((Border)JBUI.Borders.empty());
        this.getTooltipContainer().add((Component)timelineLabel, new TabularLayout.Constraint(1, 0));
        this.getTooltipContainer().add((Component)durationLabel, new TabularLayout.Constraint(2, 0));
    }
}

