/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.CpuCaptureNodeTooltip;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureNodeTooltipView
extends TooltipView {
    @NotNull
    private final CaptureNode myCaptureNode;

    public CpuCaptureNodeTooltipView(@NotNull JComponent parent, @NotNull CpuCaptureNodeTooltip tooltip2) {
        super(tooltip2.getTimeline());
        this.myCaptureNode = tooltip2.getCaptureNode();
    }

    @NotNull
    protected JComponent createTooltip() {
        long totalDuration = this.myCaptureNode.getDuration();
        long threadDuration = Math.min(totalDuration, Math.max(0L, this.myCaptureNode.getEndThread() - this.myCaptureNode.getStartThread()));
        long idleDuration = totalDuration - threadDuration;
        JLabel nameLabel = new JLabel(this.myCaptureNode.getData().getFullNameWithSuffix());
        JLabel runningLabel = new JLabel(String.format("Running: %s", TimeFormatter.getSingleUnitDurationString((long)threadDuration)));
        JLabel idleLabel = new JLabel(String.format("Idle: %s", TimeFormatter.getSingleUnitDurationString((long)idleDuration)));
        JLabel totalLabel = new JLabel(String.format("Total: %s", TimeFormatter.getSingleUnitDurationString((long)totalDuration)));
        JLabel contextHelpLabel = new JLabel("Click to inspect");
        JLabel contextHelpSecondaryLabel = new JLabel("Click + drag to select multiple events");
        contextHelpLabel.setForeground(ProfilerColors.TOOLTIP_LOW_CONTRAST);
        contextHelpSecondaryLabel.setForeground(ProfilerColors.TOOLTIP_LOW_CONTRAST);
        JPanel content = new JPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        content.add((Component)nameLabel, new TabularLayout.Constraint(0, 0));
        content.add((Component)runningLabel, new TabularLayout.Constraint(1, 0));
        content.add((Component)idleLabel, new TabularLayout.Constraint(2, 0));
        content.add((Component)totalLabel, new TabularLayout.Constraint(3, 0));
        content.add((Component)AdtUiUtils.createHorizontalSeparator(), new TabularLayout.Constraint(4, 0));
        content.add((Component)contextHelpLabel, new TabularLayout.Constraint(5, 0));
        content.add((Component)contextHelpSecondaryLabel, new TabularLayout.Constraint(6, 0));
        return content;
    }
}

