/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.FullTraceAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.HelpTextView;
import com.android.tools.profilers.cpu.analysis.SummaryDetailsViewBase;
import com.google.common.annotations.VisibleForTesting;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/profilers/cpu/analysis/FullTraceSummaryDetailsView;", "Lcom/android/tools/profilers/cpu/analysis/SummaryDetailsViewBase;", "Lcom/android/tools/profilers/cpu/analysis/FullTraceAnalysisSummaryTabModel;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "tabModel", "(Lcom/android/tools/profilers/StudioProfilersView;Lcom/android/tools/profilers/cpu/analysis/FullTraceAnalysisSummaryTabModel;)V", "durationLabel", "Ljavax/swing/JLabel;", "getDurationLabel", "()Ljavax/swing/JLabel;", "timeRangeLabel", "getTimeRangeLabel", "updateRangeLabels", "", "intellij.android.profilers.ui"})
public final class FullTraceSummaryDetailsView
extends SummaryDetailsViewBase<FullTraceAnalysisSummaryTabModel> {
    @NotNull
    private final JLabel timeRangeLabel;
    @NotNull
    private final JLabel durationLabel;

    public FullTraceSummaryDetailsView(@NotNull StudioProfilersView profilersView, @NotNull FullTraceAnalysisSummaryTabModel tabModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilersView), (String)"profilersView");
        Intrinsics.checkNotNullParameter((Object)tabModel, (String)"tabModel");
        super(profilersView, (CpuAnalysisSummaryTabModel)tabModel);
        this.timeRangeLabel = new JLabel();
        this.durationLabel = new JLabel();
        this.addRowToCommonSection("Time Range", this.timeRangeLabel);
        this.addRowToCommonSection("Duration", this.durationLabel);
        tabModel.getSelectionRange().addDependency(this.getObserver()).onChange((Enum)Range.Aspect.RANGE, new Runnable(){

            @Override
            public final void run() {
                this.updateRangeLabels();
            }
        });
        this.updateRangeLabels();
        this.addSection(new HelpTextView());
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getTimeRangeLabel() {
        return this.timeRangeLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getDurationLabel() {
        return this.durationLabel;
    }

    private final void updateRangeLabels() {
        Range range = ((FullTraceAnalysisSummaryTabModel)this.getTabModel()).getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"tabModel.selectionRange");
        Range range2 = range;
        this.timeRangeLabel.setText(this.formatTimeRangeAsString(range2));
        this.durationLabel.setText(TimeFormatter.getSingleUnitDurationString((long)((long)range2.getLength())));
    }
}

