/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisStats;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c2\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c2\u0003J3\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u001eH\u0016J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020\"H\u00d6\u0001J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u0003H\u0002J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisModel;", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalyzable;", "node", "Lcom/android/tools/profilers/cpu/CaptureNode;", "capture", "Lcom/android/tools/profilers/cpu/CpuCapture;", "runModelUpdate", "Lkotlin/Function1;", "Ljava/lang/Runnable;", "", "(Lcom/android/tools/profilers/cpu/CaptureNode;Lcom/android/tools/profilers/cpu/CpuCapture;Lkotlin/jvm/functions/Function1;)V", "allOccurrenceStats", "Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisStats;", "getAllOccurrenceStats", "()Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisStats;", "getNode", "()Lcom/android/tools/profilers/cpu/CaptureNode;", "nodeRange", "Lcom/android/tools/adtui/model/Range;", "getNodeRange", "()Lcom/android/tools/adtui/model/Range;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getAnalysisModel", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisModel;", "getLongestRunningOccurrences", "", "k", "", "hashCode", "matchesFullName", "otherNode", "toString", "", "intellij.android.profilers"})
public final class CaptureNodeAnalysisModel
implements CpuAnalyzable<CaptureNodeAnalysisModel> {
    @NotNull
    private final CaptureNode node;
    @NotNull
    private final CpuCapture capture;
    @NotNull
    private final Function1<Runnable, Unit> runModelUpdate;

    public CaptureNodeAnalysisModel(@NotNull CaptureNode node, @NotNull CpuCapture capture, @NotNull Function1<? super Runnable, Unit> runModelUpdate) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
        Intrinsics.checkNotNullParameter(runModelUpdate, (String)"runModelUpdate");
        this.node = node;
        this.capture = capture;
        this.runModelUpdate = runModelUpdate;
    }

    @NotNull
    public final CaptureNode getNode() {
        return this.node;
    }

    @NotNull
    public final Range getNodeRange() {
        return new Range((double)this.node.getStart(), (double)this.node.getEnd());
    }

    @NotNull
    public final CaptureNodeAnalysisStats getAllOccurrenceStats() {
        Stream<CaptureNode> stream = this.node.findRootNode().getDescendantsStream().filter(new Predicate(this){
            final /* synthetic */ CaptureNodeAnalysisModel $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final boolean test(@NotNull CaptureNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CaptureNodeAnalysisModel.access$matchesFullName(this.$tmp0, p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(stream, (String)"node.findRootNode().desc\u2026filter(::matchesFullName)");
        List allOccurrences2 = StreamsKt.toList(stream);
        return CaptureNodeAnalysisStats.Companion.fromNodes(allOccurrences2);
    }

    @NotNull
    public final List<CaptureNode> getLongestRunningOccurrences(int k) {
        return this.node.findRootNode().getTopKNodes(k, new Predicate(this){
            final /* synthetic */ CaptureNodeAnalysisModel $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final boolean test(@NotNull CaptureNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CaptureNodeAnalysisModel.access$matchesFullName(this.$tmp0, p0);
            }
        }, new Comparator(){

            public final int compare(T a, T b) {
                CaptureNode p0 = (CaptureNode)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(p0.getDuration());
                p0 = (CaptureNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getDuration()));
            }
        });
    }

    private final boolean matchesFullName(CaptureNode otherNode) {
        return Intrinsics.areEqual((Object)this.node.getData().getFullName(), (Object)otherNode.getData().getFullName());
    }

    @Override
    @NotNull
    public CpuAnalysisModel<CaptureNodeAnalysisModel> getAnalysisModel() {
        CpuAnalysisModel<CaptureNodeAnalysisModel> cpuAnalysisModel;
        Range nodeRange = this.getNodeRange();
        Set nodes = SetsKt.setOf((Object)this.node);
        CpuAnalysisModel<CaptureNodeAnalysisModel> model = cpuAnalysisModel = new CpuAnalysisModel<CaptureNodeAnalysisModel>(this.node.getData().getNameWithSuffix(), "%d events");
        boolean bl = false;
        Range range = this.capture.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"capture.range");
        ProfilingConfiguration.TraceType traceType = this.capture.getType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)traceType), (String)"capture.type");
        CaptureNodeAnalysisModel.getAnalysisModel$lambda-0$add(this, model, new CaptureNodeAnalysisSummaryTabModel(range, traceType));
        CaptureNodeAnalysisModel.getAnalysisModel$lambda-0$add(this, model, new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.FLAME_CHART, nodeRange, this.capture, (Function1)new Function1<CaptureNodeAnalysisModel, Collection<? extends CaptureNode>>((Set<? extends CaptureNode>)nodes){
            final /* synthetic */ Set<CaptureNode> $nodes;
            {
                this.$nodes = $nodes;
                super(1);
            }

            @NotNull
            public final Collection<CaptureNode> invoke(@NotNull CaptureNodeAnalysisModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$nodes;
            }
        }, this.runModelUpdate));
        CaptureNodeAnalysisModel.getAnalysisModel$lambda-0$add(this, model, new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.TOP_DOWN, nodeRange, this.capture, (Function1)new Function1<CaptureNodeAnalysisModel, Collection<? extends CaptureNode>>((Set<? extends CaptureNode>)nodes){
            final /* synthetic */ Set<CaptureNode> $nodes;
            {
                this.$nodes = $nodes;
                super(1);
            }

            @NotNull
            public final Collection<CaptureNode> invoke(@NotNull CaptureNodeAnalysisModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$nodes;
            }
        }, this.runModelUpdate));
        CaptureNodeAnalysisModel.getAnalysisModel$lambda-0$add(this, model, new CpuAnalysisChartModel(CpuAnalysisTabModel.Type.BOTTOM_UP, nodeRange, this.capture, (Function1)new Function1<CaptureNodeAnalysisModel, Collection<? extends CaptureNode>>((Set<? extends CaptureNode>)nodes){
            final /* synthetic */ Set<CaptureNode> $nodes;
            {
                this.$nodes = $nodes;
                super(1);
            }

            @NotNull
            public final Collection<CaptureNode> invoke(@NotNull CaptureNodeAnalysisModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$nodes;
            }
        }, this.runModelUpdate));
        Range range2 = this.capture.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"capture.range");
        CaptureNodeAnalysisModel.getAnalysisModel$lambda-0$add(this, model, new CaptureNodeAnalysisEventsTabModel(range2));
        return cpuAnalysisModel;
    }

    @NotNull
    public final CaptureNode component1() {
        return this.node;
    }

    private final CpuCapture component2() {
        return this.capture;
    }

    private final Function1<Runnable, Unit> component3() {
        return this.runModelUpdate;
    }

    @NotNull
    public final CaptureNodeAnalysisModel copy(@NotNull CaptureNode node, @NotNull CpuCapture capture, @NotNull Function1<? super Runnable, Unit> runModelUpdate) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)capture, (String)"capture");
        Intrinsics.checkNotNullParameter(runModelUpdate, (String)"runModelUpdate");
        return new CaptureNodeAnalysisModel(node, capture, runModelUpdate);
    }

    public static /* synthetic */ CaptureNodeAnalysisModel copy$default(CaptureNodeAnalysisModel captureNodeAnalysisModel, CaptureNode captureNode, CpuCapture cpuCapture, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            captureNode = captureNodeAnalysisModel.node;
        }
        if ((n & 2) != 0) {
            cpuCapture = captureNodeAnalysisModel.capture;
        }
        if ((n & 4) != 0) {
            function1 = captureNodeAnalysisModel.runModelUpdate;
        }
        return captureNodeAnalysisModel.copy(captureNode, cpuCapture, function1);
    }

    @NotNull
    public String toString() {
        return "CaptureNodeAnalysisModel(node=" + this.node + ", capture=" + this.capture + ", runModelUpdate=" + this.runModelUpdate + ")";
    }

    public int hashCode() {
        int result = this.node.hashCode();
        result = result * 31 + this.capture.hashCode();
        result = result * 31 + this.runModelUpdate.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CaptureNodeAnalysisModel)) {
            return false;
        }
        CaptureNodeAnalysisModel captureNodeAnalysisModel = (CaptureNodeAnalysisModel)other;
        if (!Intrinsics.areEqual((Object)this.node, (Object)captureNodeAnalysisModel.node)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.capture, (Object)captureNodeAnalysisModel.capture)) {
            return false;
        }
        return Intrinsics.areEqual(this.runModelUpdate, captureNodeAnalysisModel.runModelUpdate);
    }

    private static final void getAnalysisModel$lambda-0$add(CaptureNodeAnalysisModel this$0, CpuAnalysisModel<CaptureNodeAnalysisModel> $model, CpuAnalysisTabModel<CaptureNodeAnalysisModel> tab) {
        tab.getDataSeries().add(this$0);
        $model.addTabModel(tab);
    }

    public static final /* synthetic */ boolean access$matchesFullName(CaptureNodeAnalysisModel $this, CaptureNode otherNode) {
        return $this.matchesFullName(otherNode);
    }
}

