/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.Interval;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.VsyncPanel;
import com.android.tools.profilers.cpu.VsyncPanelKt;
import com.intellij.ide.ui.UISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0007J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/cpu/VsyncPanel;", "", "()V", "of", "Ljavax/swing/JComponent;", "content", "viewRange", "Lcom/android/tools/adtui/model/Range;", "vsyncValues", "", "Lcom/android/tools/adtui/model/SeriesData;", "", "vsyncEnabler", "Ljava/util/function/BooleanSupplier;", "series", "Lcom/android/tools/adtui/model/RangedSeries;", "intellij.android.profilers.ui"})
public final class VsyncPanel {
    @NotNull
    public static final VsyncPanel INSTANCE = new VsyncPanel();

    private VsyncPanel() {
    }

    @JvmStatic
    @NotNull
    public static final JComponent of(@NotNull JComponent content, @NotNull Range viewRange, @NotNull List<SeriesData<Long>> vsyncValues, @NotNull BooleanSupplier vsyncEnabler) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)viewRange, (String)"viewRange");
        Intrinsics.checkNotNullParameter(vsyncValues, (String)"vsyncValues");
        Intrinsics.checkNotNullParameter((Object)vsyncEnabler, (String)"vsyncEnabler");
        return VsyncPanel.of(content, (RangedSeries<Long>)new RangedSeries(viewRange, (DataSeries)new LazyDataSeries(new Supplier(vsyncValues){
            final /* synthetic */ List<SeriesData<Long>> $vsyncValues;
            {
                this.$vsyncValues = $vsyncValues;
            }

            public final List<SeriesData<Long>> get() {
                return this.$vsyncValues;
            }
        }), null, 4, null), vsyncEnabler);
    }

    @JvmStatic
    @NotNull
    public static final JComponent of(@NotNull JComponent content, @NotNull RangedSeries<Long> series, @NotNull BooleanSupplier vsyncEnabler) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(series, (String)"series");
        Intrinsics.checkNotNullParameter((Object)vsyncEnabler, (String)"vsyncEnabler");
        Serializable serializable = new BorderLayout();
        Serializable $this$of_u24lambda_u2d0 = serializable = new JPanel(series, vsyncEnabler, (BorderLayout)serializable){
            @NotNull
            private final StateChartModel<Long> model;
            @NotNull
            private final AspectObserver observer;
            private boolean intervalsInViewUpdated;
            @NotNull
            private final List<Interval> intervalsInView;
            final /* synthetic */ BooleanSupplier $vsyncEnabler;
            {
                void $this$model_u24lambda_u2d0;
                StateChartModel stateChartModel;
                this.$vsyncEnabler = $vsyncEnabler;
                super($super_call_param$1);
                StateChartModel stateChartModel2 = stateChartModel = new StateChartModel();
                of.2 var7_6 = this;
                boolean bl = false;
                $this$model_u24lambda_u2d0.addSeries($series);
                var7_6.model = stateChartModel;
                this.observer = new AspectObserver();
                this.intervalsInView = new ArrayList<E>();
            }

            @NotNull
            public final StateChartModel<Long> getModel() {
                return this.model;
            }

            @NotNull
            public final AspectObserver getObserver() {
                return this.observer;
            }

            public final boolean getIntervalsInViewUpdated() {
                return this.intervalsInViewUpdated;
            }

            public final void setIntervalsInViewUpdated(boolean bl) {
                this.intervalsInViewUpdated = bl;
            }

            @NotNull
            public final List<Interval> getIntervalsInView() {
                return this.intervalsInView;
            }

            protected void paintComponent(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                if (this.$vsyncEnabler.getAsBoolean()) {
                    Graphics graphics = g.create();
                    Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    Graphics2D g2d = (Graphics2D)graphics;
                    boolean bl = false;
                    UISettings.Companion.setupAntialiasing((Graphics)g2d);
                    this.draw(g2d);
                    g2d.dispose();
                }
            }

            private final void updateIntervalsInView() {
                if (!this.intervalsInViewUpdated) {
                    this.intervalsInViewUpdated = true;
                    this.intervalsInView.clear();
                    RangedSeries data = (RangedSeries)this.model.getSeries().get(0);
                    double min = data.getXRange().getMin();
                    double max = data.getXRange().getMax();
                    double invRange = 1.0 / (max - min);
                    List dataList = data.getSeries();
                    if (!((Collection)dataList).isEmpty()) {
                        double previousX = ((SeriesData)dataList.get((int)0)).x;
                        Object object = ((SeriesData)dataList.get((int)0)).value;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dataList[0].value");
                        boolean previousVal = ((Number)object).longValue() > 0L;
                        for (SeriesData event : dataList.subList(1, dataList.size())) {
                            double x = event.x;
                            if (x >= min) {
                                of.2.updateIntervalsInView$addInterval(this, min, invRange, Math.max(min, previousX), Math.min(max, x), previousVal);
                            }
                            previousX = x;
                            Object object2 = event.value;
                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"event.value");
                            boolean bl = previousVal = ((Number)object2).longValue() > 0L;
                            if (!(previousX >= max)) continue;
                        }
                        if (previousX < max) {
                            of.2.updateIntervalsInView$addInterval(this, min, invRange, Math.max(min, previousX), max, previousVal);
                        }
                    }
                }
            }

            private final void draw(Graphics2D g2d) {
                int endIndexExclusive;
                int n;
                int n2;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                float scaleX = this.getWidth();
                float scaleY = this.getHeight();
                Rectangle clipRect = g2d.getClipBounds();
                this.updateIntervalsInView();
                if (clipRect != null && clipRect.x != 0) {
                    int it = of.2.draw$overlapIndex(this, (float)clipRect.x / scaleX, 0.0f);
                    boolean bl = false;
                    n2 = it < 0 ? -(it + 1) : it;
                } else {
                    n2 = 0;
                }
                int startIndexInclusive = n2;
                if (clipRect != null && clipRect.width != this.getWidth()) {
                    int it = of.2.draw$overlapIndex(this, (float)(clipRect.x + clipRect.width) / scaleX, 0.0f);
                    boolean bl = false;
                    n = it < 0 ? -(it + 1) : it + 1;
                } else {
                    n = endIndexExclusive = this.intervalsInView.size();
                }
                if ((float)(endIndexExclusive - startIndexInclusive) < scaleX) {
                    Iterable $this$forEach$iv = this.intervalsInView.subList(startIndexInclusive, endIndexExclusive);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Interval interval = (Interval)element$iv;
                        boolean bl = false;
                        float x = interval.component1();
                        float w = interval.component2();
                        boolean on = interval.component3();
                        g2d.setColor(on ? ProfilerColors.VSYNC_BACKGROUND : ProfilerColors.DEFAULT_BACKGROUND);
                        g2d.fill(new Rectangle2D.Float(x * scaleX, 0.0f, w * scaleX, scaleY));
                    }
                }
            }

            private static final boolean updateIntervalsInView$addInterval(of.2 this$0, double min, double invRange, double previousX, double x, boolean on) {
                return this$0.intervalsInView.add(new Interval((float)((previousX - min) * invRange), (float)((x - previousX) * invRange), on));
            }

            private static final int draw$overlapIndex(of.2 this$0, float x, float w) {
                return CollectionsKt.binarySearch$default(this$0.intervalsInView, (int)0, (int)0, (Function1)((Function1)new Function1<Interval, Integer>(x, w){
                    final /* synthetic */ float $x;
                    final /* synthetic */ float $w;
                    {
                        this.$x = $x;
                        this.$w = $w;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull Interval value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        return value.getX() + value.getW() < this.$x ? -1 : (value.getX() > this.$x + this.$w ? 1 : 0);
                    }
                }), (int)3, null);
            }
        };
        boolean bl = false;
        ((Container)$this$of_u24lambda_u2d0).add(content);
        $this$of_u24lambda_u2d0.getModel().addDependency($this$of_u24lambda_u2d0.getObserver()).onChange((Enum)StateChartModel.Aspect.MODEL_CHANGED, new Runnable($this$of_u24lambda_u2d0){
            final /* synthetic */ of.2 $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final void run() {
                VsyncPanel.access$of$lambda-0$modelChanged(this.$this_apply);
            }
        });
        VsyncPanel.of$lambda-0$modelChanged($this$of_u24lambda_u2d0);
        MouseListener handler2 = new MouseListener(content){
            final /* synthetic */ JComponent $content;
            {
                this.$content = $content;
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }
        };
        ((Component)$this$of_u24lambda_u2d0).addMouseListener(handler2);
        ((Component)$this$of_u24lambda_u2d0).addMouseMotionListener((MouseMotionListener)((Object)handler2));
        return (JComponent)serializable;
    }

    private static final void of$lambda-0$modelChanged(of.2 $this_apply) {
        $this_apply.setIntervalsInViewUpdated(false);
        VsyncPanelKt.access$getOpaqueContainer($this_apply).repaint();
    }

    public static final /* synthetic */ void access$of$lambda-0$modelChanged(of.2 $this_apply) {
        VsyncPanel.of$lambda-0$modelChanged($this_apply);
    }
}

