/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartTextConverter;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.profilers.DataVisualizationColors;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.VsyncPanel;
import com.android.tools.profilers.cpu.systemtrace.FrameState;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import java.awt.Color;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FramesTrackRenderer
implements TrackRenderer<FrameState> {
    private final BooleanSupplier myVsyncEnabler;

    public FramesTrackRenderer(BooleanSupplier vsyncEnabler) {
        this.myVsyncEnabler = vsyncEnabler;
    }

    @NotNull
    public JComponent render(@NotNull TrackModel<FrameState, ?> trackModel) {
        return VsyncPanel.of((JComponent)new StateChart(((FrameState)trackModel.getDataModel()).getModel(), (StateChartColorProvider)new FrameColorProvider(), (StateChartTextConverter)new FrameTextConverter()), ((FrameState)trackModel.getDataModel()).getVsyncSeries(), this.myVsyncEnabler);
    }

    private static class FrameTextConverter
    implements StateChartTextConverter<SystemTraceFrame> {
        private FrameTextConverter() {
        }

        @NotNull
        public String convertToString(@NotNull SystemTraceFrame value) {
            if (value.getTotalPerfClass() == SystemTraceFrame.PerfClass.BAD) {
                return TimeFormatter.getSingleUnitDurationString((long)value.getDurationUs());
            }
            return "";
        }
    }

    private static class FrameColorProvider
    extends StateChartColorProvider<SystemTraceFrame> {
        private FrameColorProvider() {
        }

        @NotNull
        public Color getColor(boolean isMouseOver, @NotNull SystemTraceFrame value) {
            switch (value.getTotalPerfClass()) {
                case BAD: {
                    return isMouseOver ? ProfilerColors.SLOW_FRAME_COLOR_HIGHLIGHTED : ProfilerColors.SLOW_FRAME_COLOR;
                }
                case GOOD: {
                    return DataVisualizationColors.getPaletteManager().getBackgroundColor("Gray", isMouseOver);
                }
            }
            return ProfilerColors.CPU_STATECHART_DEFAULT_STATE;
        }
    }
}

