/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.AbstractDurationDataRenderer;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.intellij.ui.components.JBPanel;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CpuUsageView
extends JBPanel<CpuUsageView> {
    @NotNull
    protected final CpuProfilerStage myStage;
    @NotNull
    protected final OverlayComponent myOverlayComponent;

    public CpuUsageView(@NotNull CpuProfilerStage stage) {
        super((LayoutManager)new TabularLayout("*", "*"));
        this.myStage = stage;
        this.myOverlayComponent = new OverlayComponent((Component)new JPanel());
        DelegateMouseEventHandler.delegateTo((Component)((Object)this)).installListenerOn((Component)this.myOverlayComponent).installMotionListenerOn((Component)this.myOverlayComponent);
        this.setBorder(ProfilerLayout.MONITOR_BORDER);
        this.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.add(this.createAxisPanel(), new TabularLayout.Constraint(0, 0));
        this.add(this.createLegendPanel(), new TabularLayout.Constraint(0, 0));
        this.add((Component)this.myOverlayComponent, new TabularLayout.Constraint(0, 0));
        this.add(this.createLineChartPanel(), new TabularLayout.Constraint(0, 0));
    }

    @NotNull
    private JComponent createAxisPanel() {
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(this.myStage.getCpuUsageAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setOnlyShowUnitAtMax(false);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        AxisComponent rightAxis = new AxisComponent(this.myStage.getThreadCountAxis(), AxisComponent.AxisOrientation.LEFT);
        rightAxis.setShowAxisLine(false);
        rightAxis.setShowMax(true);
        rightAxis.setOnlyShowUnitAtMax(true);
        rightAxis.setHideTickAtMin(true);
        rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)rightAxis, "East");
        return axisPanel;
    }

    @NotNull
    private JComponent createLineChartPanel() {
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        DetailedCpuUsage cpuUsage = this.myStage.getCpuUsage();
        LineChart lineChart = new LineChart((LineChartModel)cpuUsage);
        lineChart.configure(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        lineChart.configure(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        lineChart.configure(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        lineChart.setTopPadding(ProfilerLayout.Y_AXIS_TOP_MARGIN);
        lineChart.setFillEndGap(true);
        DurationDataRenderer traceRenderer = new DurationDataRenderer.Builder(this.myStage.getTraceDurations(), ProfilerColors.CPU_CAPTURE_EVENT).setDurationBg(ProfilerColors.CPU_CAPTURE_BACKGROUND).setIconMapper(info -> info.getDurationUs() != Long.MAX_VALUE ? StudioIcons.Profiler.Toolbar.CAPTURE_CLOCK : null).setLabelProvider(info -> info.getDurationUs() == Long.MAX_VALUE ? "In progress" : "").setLabelColors(ProfilerColors.CPU_DURATION_LABEL_BACKGROUND, Color.BLACK, Color.lightGray, Color.WHITE).setBackgroundClickable(true).setClickHandler(traceInfo -> {
            if (traceInfo.getDurationUs() != Long.MAX_VALUE) {
                this.myStage.setAndSelectCapture(traceInfo.getTraceId());
            }
        }).build();
        traceRenderer.addCustomLineConfig(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        traceRenderer.addCustomLineConfig(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        traceRenderer.addCustomLineConfig(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT_CAPTURED).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        this.myOverlayComponent.addDurationDataRenderer((AbstractDurationDataRenderer)traceRenderer);
        lineChart.addCustomRenderer((LineChartCustomRenderer)traceRenderer);
        return lineChartPanel;
    }

    @NotNull
    private JComponent createLegendPanel() {
        JBPanel legendPanel2 = new JBPanel((LayoutManager)new BorderLayout());
        CpuProfilerStage.CpuStageLegends legends = this.myStage.getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        legend.configure((Legend)legends.getCpuLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_USAGE_CAPTURED));
        legend.configure((Legend)legends.getOthersLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_OTHER_USAGE_CAPTURED));
        legend.configure((Legend)legends.getThreadsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.THREADS_COUNT_CAPTURED));
        JLabel label = new JLabel(this.myStage.getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        label.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        legendPanel2.setOpaque(false);
        legendPanel2.add((Component)label, "West");
        legendPanel2.add((Component)legend, "East");
        return legendPanel2;
    }
}

