/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuThreadCountDataSeries
implements DataSeries<Long> {
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myClient;
    private final long myStreamId;
    private final int myPid;

    public CpuThreadCountDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, long streamId, int pid) {
        this.myClient = client;
        this.myStreamId = streamId;
        this.myPid = pid;
    }

    public List<SeriesData<Long>> getDataForRange(Range rangeUs) {
        long minNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamId).setPid(this.myPid).setKind(Common.Event.Kind.CPU_THREAD).setFromTimestamp(minNs).setToTimestamp(maxNs).build();
        Transport.GetEventGroupsResponse response = this.myClient.getEventGroups(request);
        TreeMap<Long, Long> timestampToCountMap = new TreeMap<Long, Long>();
        for (Transport.EventGroup group : response.getGroupsList()) {
            if (group.getEventsCount() <= 0) continue;
            Common.Event first = group.getEvents(0);
            Common.Event last = group.getEvents(group.getEventsCount() - 1);
            timestampToCountMap.compute(first.getTimestamp(), (timestamp, count2) -> count2 == null ? 1L : count2 + 1L);
            if (!last.getIsEnded()) continue;
            timestampToCountMap.compute(last.getTimestamp(), (timestamp, count2) -> count2 == null ? -1L : count2 - 1L);
        }
        ArrayList<SeriesData<Long>> data = new ArrayList<SeriesData<Long>>();
        long total = 0L;
        for (Map.Entry entry2 : timestampToCountMap.entrySet()) {
            data.add((SeriesData<Long>)new SeriesData(TimeUnit.NANOSECONDS.toMicros((Long)entry2.getKey()), (Object)(total += ((Long)entry2.getValue()).longValue())));
        }
        if (timestampToCountMap.isEmpty()) {
            data.add(new SeriesData((long)rangeUs.getMin(), (Object)total));
            data.add((SeriesData<Long>)new SeriesData((long)rangeUs.getMax(), (Object)total));
        } else if ((double)((SeriesData)data.get((int)(data.size() - 1))).x < rangeUs.getMax()) {
            data.add((SeriesData<Long>)new SeriesData((long)rangeUs.getMax(), (Object)total));
        }
        return data;
    }
}

