/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.RecordingOption;
import com.android.tools.profilers.RecordingOptionsModel;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.event.EventMonitor;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends StreamingStage {
    private static final String HAS_USED_CPU_CAPTURE = "cpu.used.capture";
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    public static final int CPU_ART_STOP_TIMEOUT_SEC = Math.max(5, Math.min(Integer.getInteger("profiler.cpu.art.stop.timeout.sec", 120), 300));
    @VisibleForTesting
    static final ProfilingConfiguration API_INITIATED_TRACING_PROFILING_CONFIG = new ArtInstrumentedConfiguration("API tracing");
    private final CpuThreadsModel myThreadsStates;
    private final ClampedAxisComponentModel myCpuUsageAxis;
    private final ClampedAxisComponentModel myThreadCountAxis;
    private final ResizingAxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final RangeSelectionModel myRangeSelectionModel;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final CpuProfilerConfigModel myProfilerConfigModel;
    @NotNull
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    private final AspectModel<CpuProfilerAspect> myAspect = new AspectModel();
    @NotNull
    private final RecordingOptionsModel myRecordingOptionsModel;
    @NotNull
    private CaptureState myCaptureState;
    private long myCaptureStartTimeNs;
    private long myCaptureStopTimeNs;
    private final InProgressTraceHandler myInProgressTraceHandler;
    @NotNull
    private Cpu.CpuTraceInfo myInProgressTraceInfo = Cpu.CpuTraceInfo.getDefaultInstance();
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private final Common.Session mySession;
    private final Map<Long, CpuTraceInfo> myCompletedTraceIdToInfoMap = new HashMap<Long, CpuTraceInfo>();

    public CpuProfilerStage(@NotNull StudioProfilers profilers) {
        this(profilers, new CpuCaptureParser(profilers.getIdeServices()));
    }

    @VisibleForTesting
    CpuProfilerStage(@NotNull StudioProfilers profilers, @NotNull CpuCaptureParser captureParser) {
        super(profilers);
        this.mySession = profilers.getSession();
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        this.myProfilerConfigModel = new CpuProfilerConfigModel(profilers, this);
        this.myRecordingOptionsModel = new RecordingOptionsModel();
        Range viewRange = this.getTimeline().getViewRange();
        Range dataRange = this.getTimeline().getDataRange();
        Range selectionRange = this.getTimeline().getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER).build();
        this.myThreadCountAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS).build();
        this.myTimeAxisGuide = new ResizingAxisComponentModel.Builder(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS).setGlobalRange(dataRange).build();
        this.myLegends = new CpuStageLegends(this.myCpuUsage, dataRange);
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.getCpuTraceDataSeries()));
        this.myThreadsStates = new CpuThreadsModel(viewRange, profilers, this.mySession);
        this.myEventMonitor = new EventMonitor(profilers);
        this.myRangeSelectionModel = this.buildRangeSelectionModel(selectionRange, viewRange);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myCaptureState = CaptureState.IDLE;
        this.myUpdatableManager = new UpdatableManager(this.getStudioProfilers().getUpdater());
        this.myCaptureParser = captureParser;
        List<Cpu.CpuTraceInfo> existingCompletedTraceInfoList = CpuProfiler.getTraceInfoFromSession(this.getStudioProfilers().getClient(), this.mySession).stream().filter(info -> info.getToTimestamp() != -1L).collect(Collectors.toList());
        existingCompletedTraceInfoList.forEach(info -> this.myCompletedTraceIdToInfoMap.put(info.getTraceId(), new CpuTraceInfo((Cpu.CpuTraceInfo)info)));
        this.myInProgressTraceHandler = new InProgressTraceHandler();
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    private RangeSelectionModel buildRangeSelectionModel(@NotNull Range selectionRange, @NotNull Range viewRange) {
        RangeSelectionModel rangeSelectionModel2 = new RangeSelectionModel(selectionRange, viewRange);
        rangeSelectionModel2.addConstraint(this.myTraceDurations);
        return rangeSelectionModel2;
    }

    public boolean hasUserUsedCpuCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_CPU_CAPTURE, false);
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        return this.myRangeSelectionModel;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        return this.myInstructionsEaseOutModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    public RecordingOptionsModel getRecordingModel() {
        return this.myRecordingOptionsModel;
    }

    @NotNull
    public CpuProfilerConfigModel getProfilerConfigModel() {
        return this.myProfilerConfigModel;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().register(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myInProgressTraceHandler);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getStageType());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, this.myProfilerConfigModel::updateProfilingConfigurations);
        this.myProfilerConfigModel.updateProfilingConfigurations();
        this.setupRecordingOptions();
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myInProgressTraceHandler);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadCountAxis);
        this.myCaptureParser.abortParsing();
        this.myRangeSelectionModel.clearListeners();
        this.myUpdatableManager.releaseAll();
    }

    @Override
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.CPU_STAGE;
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        return this.myUpdatableManager;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public void toggleCapturing() {
        if (this.myCaptureState == CaptureState.CAPTURING) {
            this.stopCapturing();
        } else {
            this.startCapturing();
        }
    }

    public void startCapturing() {
        ProfilingConfiguration config = this.myProfilerConfigModel.getProfilingConfiguration();
        assert (this.getStudioProfilers().getProcess() != null);
        Common.Process process = this.getStudioProfilers().getProcess();
        String traceFilePath = String.format(Locale.US, "%s/%s-%d.trace", "/data/local/tmp/perfd", process.getName(), System.nanoTime());
        this.setCaptureState(CaptureState.STARTING);
        Trace.TraceConfiguration.Builder configurationBuilder = Trace.TraceConfiguration.newBuilder().setAppName(process.getName()).setAbiCpuArch(TransportFileManager.getShortAbiName((String)this.getStudioProfilers().getDevice().getCpuAbi())).setInitiationType(Trace.TraceInitiationType.INITIATED_BY_UI).setTempPath(traceFilePath);
        config.addOptions(configurationBuilder, Map.of(ProfilingConfiguration.AdditionalOptions.APP_PKG_NAME, process.getName(), ProfilingConfiguration.AdditionalOptions.SYMBOL_DIRS, this.getStudioProfilers().getIdeServices().getNativeSymbolsDirectories()));
        Trace.TraceConfiguration configuration = configurationBuilder.build();
        Executor poolExecutor = this.getStudioProfilers().getIdeServices().getPoolExecutor();
        Commands.Command startCommand = Commands.Command.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setType(Commands.Command.CommandType.START_CPU_TRACE).setStartCpuTrace(Cpu.StartCpuTrace.newBuilder().setConfiguration(configuration).build()).build();
        this.getStudioProfilers().getClient().executeAsync(startCommand, poolExecutor).thenAcceptAsync(response -> {
            TransportEventListener statusListener2 = new TransportEventListener(Common.Event.Kind.TRACE_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> ((Common.Session)this.mySession).getStreamId(), () -> ((Common.Session)this.mySession).getPid(), event -> {
                this.startCapturingCallback(event.getTraceStatus().getTraceStartStatus());
                return true;
            });
            this.getStudioProfilers().getTransportPoller().registerListener(statusListener2);
        }, poolExecutor);
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_CPU_CAPTURE, true);
        this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
    }

    private void startCapturingCallback(@NotNull Trace.TraceStartStatus status) {
        if (status.getStatus().equals((Object)Trace.TraceStartStatus.Status.SUCCESS)) {
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.setCaptureState(CaptureState.CAPTURING);
            this.getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + status.getStatus());
            CpuProfilerStage.getLogger().warn(status.getErrorMessage());
            this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_START_FAILURE);
            this.setCaptureState(CaptureState.IDLE);
        }
    }

    @VisibleForTesting
    void stopCapturing() {
        if (Cpu.CpuTraceInfo.getDefaultInstance().equals((Object)this.myInProgressTraceInfo)) {
            return;
        }
        this.myCaptureStopTimeNs = this.currentTimeNs();
        this.setCaptureState(CaptureState.STOPPING);
        CpuProfiler.stopTracing(this.getStudioProfilers(), this.mySession, this.myInProgressTraceInfo.getConfiguration(), this::stopCapturingCallback);
    }

    public long getCaptureStartTimeNs() {
        return this.myCaptureStartTimeNs;
    }

    public long getCaptureStopTimeNs() {
        return this.myCaptureStopTimeNs;
    }

    private void stopCapturingCallback(@NotNull Trace.TraceStopStatus status) {
        if (!status.getStatus().equals((Object)Trace.TraceStopStatus.Status.UNSPECIFIED) && !status.getStatus().equals((Object)Trace.TraceStopStatus.Status.SUCCESS)) {
            this.trackAndLogTraceStopFailures(status);
            this.setCaptureState(CaptureState.IDLE);
        }
    }

    private void trackAndLogTraceStopFailures(@NotNull Trace.TraceStopStatus status) {
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myProfilerConfigModel.getProfilingConfiguration());
        long estimateDurationMs = TimeUnit.NANOSECONDS.toMillis(this.currentTimeNs() - this.myCaptureStartTimeNs);
        captureMetadata.setCaptureDurationMs(estimateDurationMs);
        captureMetadata.setStoppingTimeMs((int)TimeUnit.NANOSECONDS.toMillis(status.getStoppingDurationNs()));
        captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.fromStopStatus(status.getStatus()));
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + status.getStatus());
        CpuProfilerStage.getLogger().warn(status.getErrorMessage());
        this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.getCaptureStopFailure(status.getStatus().toString()));
    }

    private void goToCaptureStage(long traceId) {
        CpuCaptureStage stage;
        if (this.myCompletedTraceIdToInfoMap.containsKey(traceId) && (stage = CpuCaptureStage.create(this.getStudioProfilers(), ProfilingConfiguration.fromProto(this.myCompletedTraceIdToInfoMap.get(traceId).getTraceInfo().getConfiguration()), traceId)) != null) {
            this.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> this.getStudioProfilers().setStage(stage));
            return;
        }
        this.setCaptureState(CaptureState.IDLE);
        this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
    }

    @NotNull
    public CpuCaptureParser getCaptureParser() {
        return this.myCaptureParser;
    }

    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub getCpuClient() {
        return this.getStudioProfilers().getClient().getCpuClient();
    }

    @Nullable
    CpuTraceInfo getIntersectingTraceInfo(Range range) {
        List infoList = this.getTraceDurations().getSeries().getSeriesForRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (!captureRange.intersectsWith(range)) continue;
            return (CpuTraceInfo)info.value;
        }
        return null;
    }

    public long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getTimeline().getDataRange().getMax());
    }

    public void setAndSelectCapture(long traceId) {
        this.goToCaptureStage(traceId);
    }

    public int getSelectedThread() {
        return this.myThreadsStates.getThread();
    }

    public void setSelectedThread(int id) {
        this.myThreadsStates.setThread(id);
        Range range = this.getTimeline().getSelectionRange();
        if (range.isEmpty()) {
            this.myAspect.changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
        }
    }

    @NotNull
    public CaptureState getCaptureState() {
        return this.myCaptureState;
    }

    @NotNull
    public Trace.TraceInitiationType getCaptureInitiationType() {
        return this.myInProgressTraceInfo.getConfiguration().getInitiationType();
    }

    public void setCaptureState(@NotNull CaptureState captureState) {
        if (!this.myCaptureState.equals((Object)captureState)) {
            this.myCaptureState = captureState;
            this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_STATE);
            if (captureState == CaptureState.CAPTURING) {
                if (!this.myRecordingOptionsModel.isRecording()) {
                    if (this.isApiInitiatedTracingInProgress()) {
                        RecordingOption option2 = this.addConfiguration(API_INITIATED_TRACING_PROFILING_CONFIG);
                        this.myRecordingOptionsModel.getCustomConfigurationModel().setSelectedItem(option2);
                        this.myRecordingOptionsModel.selectCurrentCustomConfiguration();
                    } else if (this.getCaptureInitiationType().equals((Object)Trace.TraceInitiationType.INITIATED_BY_STARTUP)) {
                        this.myRecordingOptionsModel.selectOptionBy((Function1<? super RecordingOption, Boolean>)((Function1)option -> option.getTitle().equals(this.myProfilerConfigModel.getProfilingConfiguration().getName())));
                    }
                }
                this.myRecordingOptionsModel.setRecording();
            }
        }
    }

    public boolean isApiInitiatedTracingInProgress() {
        return this.myCaptureState == CaptureState.CAPTURING && this.getCaptureInitiationType().equals((Object)Trace.TraceInitiationType.INITIATED_BY_API);
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        return this.myCpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        return this.myThreadsStates;
    }

    public void refreshRecordingConfigurations() {
        this.myRecordingOptionsModel.clearConfigurations();
        this.myProfilerConfigModel.getCustomProfilingConfigurationsDeviceFiltered().forEach(this::addConfiguration);
    }

    private RecordingOption addConfiguration(ProfilingConfiguration config) {
        RecordingOption option = new RecordingOption(config.getName(), "", () -> this.startRecordingConfig(config), this::stopCapturing);
        this.myRecordingOptionsModel.addConfigurations(option);
        return option;
    }

    private void startRecordingConfig(ProfilingConfiguration config) {
        this.myProfilerConfigModel.setProfilingConfiguration(config);
        this.startCapturing();
    }

    private void setupRecordingOptions() {
        for (ProfilingConfiguration configuration : this.myProfilerConfigModel.getDefaultProfilingConfigurations()) {
            ProfilingTechnology tech = ProfilingTechnology.fromConfig(configuration);
            this.myRecordingOptionsModel.addBuiltInOptions(new RecordingOption(configuration.getName(), tech.getDescription(), () -> this.startRecordingConfig(configuration), this::stopCapturing));
        }
        this.refreshRecordingConfigurations();
        this.myRecordingOptionsModel.selectOptionBy((Function1<? super RecordingOption, Boolean>)((Function1)recordingOption -> recordingOption.getTitle().equals(this.myProfilerConfigModel.getProfilingConfiguration().getName())));
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            super(dataRange);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.myCpuLegend.setCachingLastValue(true);
            this.myOthersLegend.setCachingLastValue(true);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            return this.myCpuLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            return this.myOthersLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            return this.myThreadsLegend;
        }
    }

    @VisibleForTesting
    class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        CpuTraceDataSeries() {
        }

        public List<SeriesData<CpuTraceInfo>> getDataForRange(Range range) {
            List<Cpu.CpuTraceInfo> traceInfos = CpuProfiler.getTraceInfoFromRange(CpuProfilerStage.this.getStudioProfilers().getClient(), CpuProfilerStage.this.mySession, range);
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (Cpu.CpuTraceInfo protoTraceInfo : traceInfos) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }

    private class InProgressTraceHandler
    implements Updatable {
        private InProgressTraceHandler() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.getCaptureParser().isParsing()) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
                return;
            }
            Cpu.CpuTraceInfo finishedTraceToSelect = null;
            Range dataRange = CpuProfilerStage.this.getTimeline().getDataRange();
            List<Cpu.CpuTraceInfo> traceInfoList = CpuProfiler.getTraceInfoFromRange(CpuProfilerStage.this.getStudioProfilers().getClient(), CpuProfilerStage.this.mySession, dataRange);
            for (int i = 0; i < traceInfoList.size(); ++i) {
                Cpu.CpuTraceInfo trace = traceInfoList.get(i);
                if (trace.getToTimestamp() == -1L) {
                    assert (i == traceInfoList.size() - 1);
                    finishedTraceToSelect = null;
                    this.handleInProgressTrace(trace);
                    break;
                }
                if (CpuProfilerStage.this.myCompletedTraceIdToInfoMap.containsKey(trace.getTraceId())) continue;
                CpuProfilerStage.this.myCompletedTraceIdToInfoMap.put(trace.getTraceId(), new CpuTraceInfo(trace));
                finishedTraceToSelect = trace;
                if (trace.getConfiguration().getInitiationType().equals((Object)Trace.TraceInitiationType.INITIATED_BY_API)) {
                    CpuCaptureMetadata metadata = new CpuCaptureMetadata(API_INITIATED_TRACING_PROFILING_CONFIG);
                    CpuProfilerStage.this.myCaptureParser.trackCaptureMetadata(trace.getTraceId(), metadata);
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuApiTracing(false, true, -1, -1, -1);
                }
                if (trace.getStopStatus().getStatus().equals((Object)Trace.TraceStopStatus.Status.SUCCESS)) {
                    CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(ProfilingConfiguration.fromProto(finishedTraceToSelect.getConfiguration()));
                    captureMetadata.setCaptureDurationMs(TimeUnit.NANOSECONDS.toMillis(trace.getToTimestamp() - trace.getFromTimestamp()));
                    captureMetadata.setStoppingTimeMs((int)TimeUnit.NANOSECONDS.toMillis(trace.getStopStatus().getStoppingDurationNs()));
                    CpuProfilerStage.this.myCaptureParser.trackCaptureMetadata(trace.getTraceId(), captureMetadata);
                    continue;
                }
                CpuProfilerStage.this.trackAndLogTraceStopFailures(trace.getStopStatus());
            }
            if (finishedTraceToSelect != null) {
                CpuProfilerStage.this.myInProgressTraceInfo = Cpu.CpuTraceInfo.getDefaultInstance();
                if (finishedTraceToSelect.getStopStatus().getStatus() == Trace.TraceStopStatus.Status.SUCCESS) {
                    CpuProfilerStage.this.setAndSelectCapture(finishedTraceToSelect.getTraceId());
                    CpuProfilerStage.this.getStudioProfilers().getSessionsManager().registerSelectedArtifactProto((GeneratedMessageV3)finishedTraceToSelect);
                } else {
                    CpuProfilerStage.this.setCaptureState(CaptureState.IDLE);
                }
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
            }
        }

        private void handleInProgressTrace(@NotNull Cpu.CpuTraceInfo traceInfo) {
            if (traceInfo.equals((Object)CpuProfilerStage.this.myInProgressTraceInfo)) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
                return;
            }
            CpuProfilerStage.this.myInProgressTraceInfo = traceInfo;
            CaptureState state = CaptureState.CAPTURING;
            CpuProfilerStage.this.myCaptureStartTimeNs = CpuProfilerStage.this.myInProgressTraceInfo.getFromTimestamp();
            Common.Event statusEvent = CpuProfiler.getTraceStatusEventFromId(CpuProfilerStage.this.getStudioProfilers(), CpuProfilerStage.this.myInProgressTraceInfo.getTraceId());
            if (statusEvent.getKind() == Common.Event.Kind.TRACE_STATUS && statusEvent.getTraceStatus().hasTraceStopStatus()) {
                state = CaptureState.STOPPING;
                CpuProfilerStage.this.myCaptureStopTimeNs = statusEvent.getTimestamp();
            }
            if (CpuProfilerStage.this.myInProgressTraceInfo.getConfiguration().getInitiationType() == Trace.TraceInitiationType.INITIATED_BY_API) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
            } else {
                CpuProfilerStage.this.myProfilerConfigModel.setProfilingConfiguration(ProfilingConfiguration.fromProto(traceInfo.getConfiguration()));
            }
            CpuProfilerStage.this.setCaptureState(state);
            CpuProfilerStage.this.getTimeline().setStreaming(true);
        }
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        STARTING,
        STOPPING;

    }
}

