/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profilers.Notification;
import org.jetbrains.annotations.NotNull;

final class CpuProfilerNotifications {
    @NotNull
    static final Notification CAPTURE_START_FAILURE = CpuProfilerNotifications.createError("Recording failed to start", "Try recording again, or ");
    @NotNull
    static final Notification PARSING_FAILURE = CpuProfilerNotifications.createError("Trace data was not recorded", "The profiler was unable to parse the method trace data. Try recording another method trace, or ");
    @NotNull
    static final Notification PREPROCESS_FAILURE = CpuProfilerNotifications.createError("Trace data was not recorded", "The profiler was unable to pre-process the method trace data. Try recording another method trace, or ");
    @NotNull
    static final Notification PARSING_ABORTED = CpuProfilerNotifications.createWarning("Parsing trace file aborted", "Please record another trace.");
    @NotNull
    static final Notification IMPORT_TRACE_PARSING_FAILURE = CpuProfilerNotifications.createError("Trace file was not parsed", "The profiler was unable to parse the trace file. Please make sure the file selected is a valid trace. Alternatively, try importing another file, or ");
    @NotNull
    static final Notification ATRACE_BUFFER_OVERFLOW = CpuProfilerNotifications.createWarning("System Trace Buffer Overflow Detected", "Your capture exceeded the buffer limit, some data may be missing. Consider recording a shorter trace.");

    CpuProfilerNotifications() {
    }

    @NotNull
    static Notification getCaptureStopFailure(String errorMessage) {
        return CpuProfilerNotifications.createError("Recording failed to stop (" + errorMessage + ")", "Try recording another trace, or ");
    }

    @NotNull
    private static Notification createNotification(@NotNull Notification.Severity severity, @NotNull String title, @NotNull String text, boolean reportBug) {
        if (reportBug) {
            Notification.UrlData url = new Notification.UrlData("https://issuetracker.google.com/issues/new?component=192708", "report a bug");
            return new Notification(severity, title, text, url);
        }
        return new Notification(severity, title, text, null);
    }

    @NotNull
    private static Notification createWarning(@NotNull String title, @NotNull String text) {
        return CpuProfilerNotifications.createNotification(Notification.Severity.WARNING, title, text, false);
    }

    @NotNull
    private static Notification createError(@NotNull String title, @NotNull String text) {
        return CpuProfilerNotifications.createNotification(Notification.Severity.ERROR, title, text, true);
    }
}

